/*
 * Decompiled with CFR 0.152.
 */
package com.iceteck.silicompressorr.videocompression;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.iceteck.silicompressorr.videocompression.InputSurface;
import com.iceteck.silicompressorr.videocompression.MP4Builder;
import com.iceteck.silicompressorr.videocompression.Mp4Movie;
import com.iceteck.silicompressorr.videocompression.OutputSurface;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@SuppressLint(value={"NewApi"})
public class MediaController {
    public static File cachedFile;
    public String path;
    public static Context mContext;
    public static final String MIME_TYPE = "video/avc";
    private static final int PROCESSOR_TYPE_OTHER = 0;
    private static final int PROCESSOR_TYPE_QCOM = 1;
    private static final int PROCESSOR_TYPE_INTEL = 2;
    private static final int PROCESSOR_TYPE_MTK = 3;
    private static final int PROCESSOR_TYPE_SEC = 4;
    private static final int PROCESSOR_TYPE_TI = 5;
    private static volatile MediaController Instance;
    private boolean videoConvertFirstWrite = true;
    private static final int DEFAULT_VIDEO_WIDTH = 640;
    private static final int DEFAULT_VIDEO_HEIGHT = 360;
    private static final int DEFAULT_VIDEO_BITRATE = 450000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaController getInstance(Context context) {
        MediaController localInstance = Instance;
        mContext = context;
        if (localInstance != null) return localInstance;
        Class<MediaController> clazz = MediaController.class;
        synchronized (MediaController.class) {
            localInstance = Instance;
            if (localInstance != null) return localInstance;
            Instance = localInstance = new MediaController();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(mimeType);
        int lastColorFormat = 0;
        for (int i = 0; i < capabilities.colorFormats.length; ++i) {
            int colorFormat = capabilities.colorFormats[i];
            if (!MediaController.isRecognizedFormat(colorFormat)) continue;
            lastColorFormat = colorFormat;
            if (codecInfo.getName().equals("OMX.SEC.AVC.Encoder") && colorFormat == 19) continue;
            return colorFormat;
        }
        return lastColorFormat;
    }

    private static boolean isRecognizedFormat(int colorFormat) {
        switch (colorFormat) {
            case 19: 
            case 20: 
            case 21: 
            case 39: 
            case 2130706688: {
                return true;
            }
        }
        return false;
    }

    public static native int convertVideoFrame(ByteBuffer var0, ByteBuffer var1, int var2, int var3, int var4, int var5, int var6);

    private void didWriteData(boolean last, boolean error) {
        boolean firstWrite = this.videoConvertFirstWrite;
        if (firstWrite) {
            this.videoConvertFirstWrite = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        FileChannel inChannel = new FileInputStream(src).getChannel();
        FileChannel outChannel = new FileOutputStream(dst).getChannel();
        try {
            inChannel.transferTo(1L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static MediaCodecInfo selectCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        MediaCodecInfo lastCodecInfo = null;
        for (int i = 0; i < numCodecs; ++i) {
            String[] types;
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mimeType)) continue;
                lastCodecInfo = codecInfo;
                if (!lastCodecInfo.getName().equals("OMX.SEC.avc.enc")) {
                    return lastCodecInfo;
                }
                if (!lastCodecInfo.getName().equals("OMX.SEC.AVC.Encoder")) continue;
                return lastCodecInfo;
            }
        }
        return lastCodecInfo;
    }

    public void scheduleVideoConvert(String path, File dest) {
        this.startVideoConvertFromQueue(path, dest);
    }

    private void startVideoConvertFromQueue(String path, File dest) {
        VideoConvertRunnable.runConversion(path, dest);
    }

    @TargetApi(value=16)
    private long readAndWriteTrack(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo info, long start, long end, File file, boolean isAudio) throws Exception {
        int trackIndex = this.selectTrack(extractor, isAudio);
        if (trackIndex >= 0) {
            extractor.selectTrack(trackIndex);
            MediaFormat trackFormat = extractor.getTrackFormat(trackIndex);
            int muxerTrackIndex = mediaMuxer.addTrack(trackFormat, isAudio);
            int maxBufferSize = trackFormat.getInteger("max-input-size");
            boolean inputDone = false;
            if (start > 0L) {
                extractor.seekTo(start, 0);
            } else {
                extractor.seekTo(0L, 0);
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            long startTime = -1L;
            while (!inputDone) {
                boolean eof = false;
                int index = extractor.getSampleTrackIndex();
                if (index == trackIndex) {
                    info.size = extractor.readSampleData(buffer, 0);
                    if (info.size < 0) {
                        info.size = 0;
                        eof = true;
                    } else {
                        info.presentationTimeUs = extractor.getSampleTime();
                        if (start > 0L && startTime == -1L) {
                            startTime = info.presentationTimeUs;
                        }
                        if (end < 0L || info.presentationTimeUs < end) {
                            info.offset = 0;
                            info.flags = extractor.getSampleFlags();
                            if (mediaMuxer.writeSampleData(muxerTrackIndex, buffer, info, isAudio)) {
                                // empty if block
                            }
                            extractor.advance();
                        } else {
                            eof = true;
                        }
                    }
                } else if (index == -1) {
                    eof = true;
                }
                if (!eof) continue;
                inputDone = true;
            }
            extractor.unselectTrack(trackIndex);
            return startTime;
        }
        return -1L;
    }

    @TargetApi(value=16)
    private int selectTrack(MediaExtractor extractor, boolean audio) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!(audio ? mime.startsWith("audio/") : mime.startsWith("video/"))) continue;
            return i;
        }
        return -5;
    }

    public boolean convertVideo(String sourcePath, File destDir) {
        return this.convertVideo(sourcePath, destDir, 0, 0, 0);
    }

    public boolean convertVideo(Context context, Uri videoContentUri, File destDir) {
        return this.convertVideo(context, videoContentUri, destDir, 0, 0, 0);
    }

    public boolean convertVideo(String sourcePath, File destDir, int outWidth, int outHeight, int outBitrate) {
        return this.convertVideo(null, null, sourcePath, destDir, outWidth, outHeight, outBitrate);
    }

    public boolean convertVideo(Context context, Uri videoContentUri, File destDir, int outWidth, int outHeight, int outBitrate) {
        return this.convertVideo(context, videoContentUri, null, destDir, outWidth, outHeight, outBitrate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=16)
    private boolean convertVideo(Context context, Uri videoContentUri, String sourcePath, File destDir, int outWidth, int outHeight, int outBitrate) {
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        if (sourcePath != null) {
            this.path = sourcePath;
            retriever.setDataSource(this.path);
        } else {
            if (context == null) return false;
            if (videoContentUri == null) return false;
            retriever.setDataSource(context, videoContentUri);
        }
        String width = retriever.extractMetadata(19);
        String height = retriever.extractMetadata(18);
        String rotation = retriever.extractMetadata(24);
        long startTime = -1L;
        long endTime = -1L;
        int resultWidth = outWidth > 0 ? outWidth : 640;
        int resultHeight = outHeight > 0 ? outHeight : 360;
        int rotationValue = Integer.valueOf(rotation);
        int originalWidth = Integer.valueOf(width);
        int originalHeight = Integer.valueOf(height);
        int bitrate = outBitrate > 0 ? outBitrate : 450000;
        int rotateRender = 0;
        File cacheFile = null;
        try {
            cacheFile = new File(this.getCompressedVideoPath(destDir));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (Build.VERSION.SDK_INT < 18 && resultHeight > resultWidth && resultWidth != originalWidth && resultHeight != originalHeight) {
            int temp = resultHeight;
            resultHeight = resultWidth;
            resultWidth = temp;
            rotationValue = 90;
            rotateRender = 270;
        } else if (Build.VERSION.SDK_INT > 20) {
            if (rotationValue == 90) {
                int temp = resultHeight;
                resultHeight = resultWidth;
                resultWidth = temp;
                rotationValue = 0;
                rotateRender = 270;
            } else if (rotationValue == 180) {
                rotateRender = 180;
                rotationValue = 0;
            } else if (rotationValue == 270) {
                int temp = resultHeight;
                resultHeight = resultWidth;
                resultWidth = temp;
                rotationValue = 0;
                rotateRender = 90;
            }
        }
        FileDescriptor fileDescriptor = null;
        try {
            ParcelFileDescriptor descriptor = null;
            descriptor = sourcePath != null ? mContext.getContentResolver().openFileDescriptor(Uri.fromFile((File)new File(sourcePath)), "r") : mContext.getContentResolver().openFileDescriptor(videoContentUri, "r");
            fileDescriptor = descriptor.getFileDescriptor();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        this.videoConvertFirstWrite = true;
        boolean error = false;
        long videoStartTime = startTime;
        long time = System.currentTimeMillis();
        if (resultWidth != 0 && resultHeight != 0) {
            MP4Builder mediaMuxer = null;
            MediaExtractor extractor = null;
            try {
                MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
                Mp4Movie movie = new Mp4Movie();
                movie.setCacheFile(cacheFile);
                movie.setRotation(rotationValue);
                movie.setSize(resultWidth, resultHeight);
                mediaMuxer = new MP4Builder().createMovie(movie);
                extractor = new MediaExtractor();
                if (sourcePath != null && fileDescriptor != null) {
                    extractor.setDataSource(fileDescriptor);
                } else if (context != null && videoContentUri != null) {
                    extractor.setDataSource(context, videoContentUri, null);
                } else {
                    boolean bl = false;
                    return bl;
                }
                int videoIndex = this.selectTrack(extractor, false);
                if (videoIndex >= 0) {
                    MediaCodec decoder = null;
                    MediaCodec encoder = null;
                    InputSurface inputSurface = null;
                    OutputSurface outputSurface = null;
                    try {
                        int colorFormat;
                        long videoTime = -1L;
                        boolean outputDone = false;
                        boolean inputDone = false;
                        boolean decoderDone = false;
                        int swapUV = 0;
                        int videoTrackIndex = -5;
                        int processorType = 0;
                        String manufacturer = Build.MANUFACTURER.toLowerCase();
                        if (Build.VERSION.SDK_INT < 18) {
                            MediaCodecInfo codecInfo = MediaController.selectCodec(MIME_TYPE);
                            colorFormat = MediaController.selectColorFormat(codecInfo, MIME_TYPE);
                            if (colorFormat == 0) {
                                throw new RuntimeException("no supported color format");
                            }
                            String codecName = codecInfo.getName();
                            if (codecName.contains("OMX.qcom.")) {
                                processorType = 1;
                                if (Build.VERSION.SDK_INT == 16 && (manufacturer.equals("lge") || manufacturer.equals("nokia"))) {
                                    swapUV = 1;
                                }
                            } else if (codecName.contains("OMX.Intel.")) {
                                processorType = 2;
                            } else if (codecName.equals("OMX.MTK.VIDEO.ENCODER.AVC")) {
                                processorType = 3;
                            } else if (codecName.equals("OMX.SEC.AVC.Encoder")) {
                                processorType = 4;
                                swapUV = 1;
                            } else if (codecName.equals("OMX.TI.DUCATI1.VIDEO.H264E")) {
                                processorType = 5;
                            }
                            Log.e((String)"tmessages", (String)("codec = " + codecInfo.getName() + " manufacturer = " + manufacturer + "device = " + Build.MODEL));
                        } else {
                            colorFormat = 2130708361;
                        }
                        Log.e((String)"tmessages", (String)("colorFormat = " + colorFormat));
                        int resultHeightAligned = resultHeight;
                        int padding = 0;
                        int bufferSize = resultWidth * resultHeight * 3 / 2;
                        if (processorType == 0) {
                            if (resultHeight % 16 != 0) {
                                padding = resultWidth * ((resultHeightAligned += 16 - resultHeight % 16) - resultHeight);
                                bufferSize += padding * 5 / 4;
                            }
                        } else if (processorType == 1) {
                            if (!manufacturer.toLowerCase().equals("lge")) {
                                int uvoffset = resultWidth * resultHeight + 2047 & 0xFFFFF800;
                                padding = uvoffset - resultWidth * resultHeight;
                                bufferSize += padding;
                            }
                        } else if (processorType != 5 && processorType == 3 && manufacturer.equals("baidu")) {
                            padding = resultWidth * ((resultHeightAligned += 16 - resultHeight % 16) - resultHeight);
                            bufferSize += padding * 5 / 4;
                        }
                        extractor.selectTrack(videoIndex);
                        if (startTime > 0L) {
                            extractor.seekTo(startTime, 0);
                        } else {
                            extractor.seekTo(0L, 0);
                        }
                        MediaFormat inputFormat = extractor.getTrackFormat(videoIndex);
                        MediaFormat outputFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)resultWidth, (int)resultHeight);
                        outputFormat.setInteger("color-format", colorFormat);
                        outputFormat.setInteger("bitrate", bitrate != 0 ? bitrate : 921600);
                        outputFormat.setInteger("frame-rate", 25);
                        outputFormat.setInteger("i-frame-interval", 10);
                        if (Build.VERSION.SDK_INT < 18) {
                            outputFormat.setInteger("stride", resultWidth + 32);
                            outputFormat.setInteger("slice-height", resultHeight);
                        }
                        encoder = MediaCodec.createEncoderByType((String)MIME_TYPE);
                        encoder.configure(outputFormat, null, null, 1);
                        if (Build.VERSION.SDK_INT >= 18) {
                            inputSurface = new InputSurface(encoder.createInputSurface());
                            inputSurface.makeCurrent();
                        }
                        encoder.start();
                        decoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
                        outputSurface = Build.VERSION.SDK_INT >= 18 ? new OutputSurface() : new OutputSurface(resultWidth, resultHeight, rotateRender);
                        decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                        decoder.start();
                        int TIMEOUT_USEC = 2500;
                        ByteBuffer[] decoderInputBuffers = null;
                        ByteBuffer[] encoderOutputBuffers = null;
                        ByteBuffer[] encoderInputBuffers = null;
                        if (Build.VERSION.SDK_INT < 21) {
                            decoderInputBuffers = decoder.getInputBuffers();
                            encoderOutputBuffers = encoder.getOutputBuffers();
                            if (Build.VERSION.SDK_INT < 18) {
                                encoderInputBuffers = encoder.getInputBuffers();
                            }
                        }
                        block22: while (true) {
                            if (outputDone) {
                                if (videoTime != -1L) {
                                    videoStartTime = videoTime;
                                }
                                break;
                            }
                            if (!inputDone) {
                                int inputBufIndex;
                                boolean eof = false;
                                int index = extractor.getSampleTrackIndex();
                                if (index == videoIndex) {
                                    inputBufIndex = decoder.dequeueInputBuffer(2500L);
                                    if (inputBufIndex >= 0) {
                                        ByteBuffer inputBuf = Build.VERSION.SDK_INT < 21 ? decoderInputBuffers[inputBufIndex] : decoder.getInputBuffer(inputBufIndex);
                                        int chunkSize = extractor.readSampleData(inputBuf, 0);
                                        if (chunkSize < 0) {
                                            decoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                                            inputDone = true;
                                        } else {
                                            decoder.queueInputBuffer(inputBufIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                            extractor.advance();
                                        }
                                    }
                                } else if (index == -1) {
                                    eof = true;
                                }
                                if (eof && (inputBufIndex = decoder.dequeueInputBuffer(2500L)) >= 0) {
                                    decoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                                    inputDone = true;
                                }
                            }
                            boolean decoderOutputAvailable = !decoderDone;
                            boolean encoderOutputAvailable = true;
                            while (true) {
                                boolean doRender;
                                if (!decoderOutputAvailable && !encoderOutputAvailable) continue block22;
                                int encoderStatus = encoder.dequeueOutputBuffer(info, 2500L);
                                if (encoderStatus == -1) {
                                    encoderOutputAvailable = false;
                                } else if (encoderStatus == -3) {
                                    if (Build.VERSION.SDK_INT < 21) {
                                        encoderOutputBuffers = encoder.getOutputBuffers();
                                    }
                                } else if (encoderStatus == -2) {
                                    MediaFormat newFormat = encoder.getOutputFormat();
                                    if (videoTrackIndex == -5) {
                                        videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                    }
                                } else {
                                    if (encoderStatus < 0) {
                                        throw new RuntimeException("unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                                    }
                                    ByteBuffer encodedData = Build.VERSION.SDK_INT < 21 ? encoderOutputBuffers[encoderStatus] : encoder.getOutputBuffer(encoderStatus);
                                    if (encodedData == null) {
                                        throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                                    }
                                    if (info.size > 1) {
                                        if ((info.flags & 2) == 0) {
                                            if (mediaMuxer.writeSampleData(videoTrackIndex, encodedData, info, false)) {
                                                this.didWriteData(false, false);
                                            }
                                        } else if (videoTrackIndex == -5) {
                                            byte[] csd = new byte[info.size];
                                            encodedData.limit(info.offset + info.size);
                                            encodedData.position(info.offset);
                                            encodedData.get(csd);
                                            ByteBuffer sps = null;
                                            ByteBuffer pps = null;
                                            for (int a = info.size - 1; a >= 0 && a > 3; --a) {
                                                if (csd[a] != 1 || csd[a - 1] != 0 || csd[a - 2] != 0 || csd[a - 3] != 0) continue;
                                                sps = ByteBuffer.allocate(a - 3);
                                                pps = ByteBuffer.allocate(info.size - (a - 3));
                                                sps.put(csd, 0, a - 3).position(0);
                                                pps.put(csd, a - 3, info.size - (a - 3)).position(0);
                                                break;
                                            }
                                            MediaFormat newFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)resultWidth, (int)resultHeight);
                                            if (sps != null && pps != null) {
                                                newFormat.setByteBuffer("csd-0", sps);
                                                newFormat.setByteBuffer("csd-1", pps);
                                            }
                                            videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                        }
                                    }
                                    outputDone = (info.flags & 4) != 0;
                                    encoder.releaseOutputBuffer(encoderStatus, false);
                                }
                                if (encoderStatus != -1 || decoderDone) continue;
                                int decoderStatus = decoder.dequeueOutputBuffer(info, 2500L);
                                if (decoderStatus == -1) {
                                    decoderOutputAvailable = false;
                                    continue;
                                }
                                if (decoderStatus == -3) continue;
                                if (decoderStatus == -2) {
                                    MediaFormat newFormat = decoder.getOutputFormat();
                                    Log.e((String)"tmessages", (String)("newFormat = " + newFormat));
                                    continue;
                                }
                                if (decoderStatus < 0) {
                                    throw new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
                                }
                                if (Build.VERSION.SDK_INT >= 18) {
                                    doRender = info.size != 0;
                                } else {
                                    boolean bl = doRender = info.size != 0 || info.presentationTimeUs != 0L;
                                }
                                if (endTime > 0L && info.presentationTimeUs >= endTime) {
                                    inputDone = true;
                                    decoderDone = true;
                                    doRender = false;
                                    info.flags |= 4;
                                }
                                if (startTime > 0L && videoTime == -1L) {
                                    if (info.presentationTimeUs < startTime) {
                                        doRender = false;
                                        Log.e((String)"tmessages", (String)("drop frame startTime = " + startTime + " present time = " + info.presentationTimeUs));
                                    } else {
                                        videoTime = info.presentationTimeUs;
                                    }
                                }
                                decoder.releaseOutputBuffer(decoderStatus, doRender);
                                if (doRender) {
                                    boolean errorWait = false;
                                    try {
                                        outputSurface.awaitNewImage();
                                    }
                                    catch (Exception e) {
                                        errorWait = true;
                                        Log.e((String)"tmessages", (String)e.getMessage());
                                    }
                                    if (!errorWait) {
                                        if (Build.VERSION.SDK_INT >= 18) {
                                            outputSurface.drawImage(false);
                                            inputSurface.setPresentationTime(info.presentationTimeUs * 1000L);
                                            inputSurface.swapBuffers();
                                        } else {
                                            int inputBufIndex = encoder.dequeueInputBuffer(2500L);
                                            if (inputBufIndex >= 0) {
                                                outputSurface.drawImage(true);
                                                ByteBuffer rgbBuf = outputSurface.getFrame();
                                                ByteBuffer yuvBuf = encoderInputBuffers[inputBufIndex];
                                                yuvBuf.clear();
                                                MediaController.convertVideoFrame(rgbBuf, yuvBuf, colorFormat, resultWidth, resultHeight, padding, swapUV);
                                                encoder.queueInputBuffer(inputBufIndex, 0, bufferSize, info.presentationTimeUs, 0);
                                            } else {
                                                Log.e((String)"tmessages", (String)"input buffer not available");
                                            }
                                        }
                                    }
                                }
                                if ((info.flags & 4) == 0) continue;
                                decoderOutputAvailable = false;
                                Log.e((String)"tmessages", (String)"decoder stream end");
                                if (Build.VERSION.SDK_INT >= 18) {
                                    encoder.signalEndOfInputStream();
                                    continue;
                                }
                                int inputBufIndex = encoder.dequeueInputBuffer(2500L);
                                if (inputBufIndex < 0) continue;
                                encoder.queueInputBuffer(inputBufIndex, 0, 1, info.presentationTimeUs, 4);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"tmessages", (String)e.getMessage());
                        error = true;
                    }
                    extractor.unselectTrack(videoIndex);
                    if (outputSurface != null) {
                        outputSurface.release();
                    }
                    if (inputSurface != null) {
                        inputSurface.release();
                    }
                    if (decoder != null) {
                        decoder.stop();
                        decoder.release();
                    }
                    if (encoder != null) {
                        encoder.stop();
                        encoder.release();
                    }
                }
                if (!error) {
                    this.readAndWriteTrack(extractor, mediaMuxer, info, videoStartTime, endTime, cacheFile, true);
                }
            }
            catch (Exception e) {
                error = true;
                Log.e((String)"tmessages", (String)e.getMessage());
            }
            finally {
                if (extractor != null) {
                    extractor.release();
                }
                if (mediaMuxer != null) {
                    try {
                        mediaMuxer.finishMovie(false);
                    }
                    catch (Exception e) {
                        Log.e((String)"tmessages", (String)e.getMessage());
                    }
                }
                Log.e((String)"tmessages", (String)("time = " + (System.currentTimeMillis() - time)));
            }
            this.didWriteData(true, error);
            cachedFile = cacheFile;
            Log.e((String)"ViratPath", (String)(this.path + ""));
            Log.e((String)"ViratPath", (String)(cacheFile.getPath() + ""));
            if (sourcePath != null) {
                Log.e((String)"SourcePath", (String)sourcePath);
            }
            if (videoContentUri == null) return true;
            Log.e((String)"VideoUri", (String)videoContentUri.toString());
            return true;
        }
        this.didWriteData(true, true);
        return false;
    }

    public String getCompressedVideoPath(File destDirectory) throws FileNotFoundException {
        String extension = ".mp4";
        if (Build.VERSION.SDK_INT >= 29) {
            String fileName = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.US).format(new Date()) + ".mp4";
            File file = new File(mContext.getExternalFilesDir(Environment.DIRECTORY_MOVIES), fileName);
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (file == null || !file.mkdirs()) {
                Log.e((String)"Sili", (String)"Directory not created");
            }
            return file.getPath();
        }
        if (!destDirectory.exists()) {
            destDirectory.mkdirs();
        }
        return destDirectory.getAbsolutePath() + "/VIDEO_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + extension;
    }

    static {
        Instance = null;
    }

    public static class VideoConvertRunnable
    implements Runnable {
        private String videoPath;
        private File destDirectory;

        private VideoConvertRunnable(String videoPath, File dest) {
            this.videoPath = videoPath;
            this.destDirectory = dest;
        }

        public static void runConversion(final String videoPath, final File dest) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        VideoConvertRunnable wrapper = new VideoConvertRunnable(videoPath, dest);
                        Thread th = new Thread((Runnable)wrapper, "VideoConvertRunnable");
                        th.start();
                        th.join();
                    }
                    catch (Exception e) {
                        Log.e((String)"tmessages", (String)e.getMessage());
                    }
                }
            }).start();
        }

        @Override
        public void run() {
            MediaController.getInstance(mContext).convertVideo(this.videoPath, this.destDirectory);
        }
    }
}

