/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.ws.logging.internal.PackageProcessor;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TruncatableThrowable
extends Throwable {
    public static final String CAUSED_BY = "Caused by: ";
    private static final long serialVersionUID = -3401687914236012149L;
    public static final String INTERNAL_CLASSES_STRING = "[internal classes]";
    private static final StackTraceElement TRIMMED_STACK_TRACE_ELEMENT = new StackTraceElement("[internal classes]", "", null, 0);
    private static final String DUPLICATE_FRAMES_EYECATCHER = "DuplicateFramesEliminatedInternally";
    private static final Pattern NO_CLASS_DEF_FOUND_ERROR_CLASS_PATTERN = Pattern.compile("L?([^;]*);?");
    private static final Pattern CLASS_NOT_FOUND_EXCEPTION_CLASS_PATTERN = Pattern.compile("(?:" + ClassNotFoundException.class.getName() + ": )?(.*)");
    private final Throwable wrapped;
    private StackTraceElement[] stackTrace;
    private StackTraceElement[] noduplicatesStackTrace;
    private final StackTraceElement[] parentFrames;
    private TruncatableThrowable truncatedCause;
    private boolean intermediateCausesStripped = false;
    private final PackageProcessor packageHelper = PackageProcessor.getPackageProcessor();

    public TruncatableThrowable(Throwable wrapped) {
        this(wrapped, null);
    }

    private TruncatableThrowable(Throwable wrapped, StackTraceElement[] parentFrames) {
        this.wrapped = wrapped;
        this.parentFrames = parentFrames;
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        PrintWriter printWriter = new PrintWriter(stream);
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    @Override
    public void printStackTrace(PrintWriter p) {
        if (this.wrapped == null) {
            p.println("none");
        } else {
            StackTraceElement[] stackElements = this.getStackTraceEliminatingDuplicateFrames();
            p.println(this.wrapped);
            for (int i = 0; i < stackElements.length; ++i) {
                StackTraceElement stackTraceElement = stackElements[i];
                String toString = TruncatableThrowable.printStackTraceElement(stackTraceElement);
                p.println("\t" + toString);
            }
            TruncatableThrowable cause = this.getCause();
            if (cause != null) {
                if (cause.isIntermediateCausesStripped()) {
                    p.print("Caused by (repeated) ... : ");
                } else {
                    p.print(CAUSED_BY);
                }
                cause.printStackTrace(p);
            }
        }
    }

    private int countNonDuplicatedFrames(StackTraceElement[] frames, StackTraceElement[] stackElements) {
        int numberToInclude = stackElements.length;
        if (frames != null) {
            int j = frames.length - 1;
            for (numberToInclude = stackElements.length - 1; numberToInclude >= 0; --numberToInclude) {
                if (j < 0) continue;
                if (!stackElements[numberToInclude].equals(frames[j])) {
                    ++numberToInclude;
                    break;
                }
                --j;
            }
        }
        return numberToInclude;
    }

    @Override
    public TruncatableThrowable getCause() {
        Throwable wrappedCause;
        if (this.truncatedCause == null && (wrappedCause = this.wrapped.getCause()) != null) {
            boolean wrappedExceptionIsSimilarToUs;
            boolean isBottomOfNest;
            if (this.wrapped instanceof NoClassDefFoundError && wrappedCause instanceof ClassNotFoundException) {
                Matcher matcher;
                String message = this.wrapped.getMessage();
                String causeMessage = wrappedCause.getMessage();
                if (message != null && causeMessage != null && (matcher = NO_CLASS_DEF_FOUND_ERROR_CLASS_PATTERN.matcher(message)).matches()) {
                    String wrappedTargetClass = matcher.group(1);
                    Matcher causeMatcher = CLASS_NOT_FOUND_EXCEPTION_CLASS_PATTERN.matcher(causeMessage);
                    if (causeMatcher.matches()) {
                        String causeTargetClass = causeMatcher.group(1);
                        if (wrappedTargetClass.replace('/', '.').equals(causeTargetClass)) {
                            return null;
                        }
                    }
                }
            }
            this.truncatedCause = new TruncatableThrowable(wrappedCause, this.getStackTrace());
            boolean bl = isBottomOfNest = wrappedCause.getCause() == null;
            if (!isBottomOfNest && (wrappedExceptionIsSimilarToUs = wrappedCause.getClass().equals(this.getWrappedException().getClass()))) {
                this.intermediateCausesStripped = true;
                this.truncatedCause = this.truncatedCause.getCause();
            }
        }
        return this.truncatedCause;
    }

    private boolean isIntermediateCausesStripped() {
        this.getCause();
        return this.intermediateCausesStripped;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            this.stackTrace = this.getStackTrace(this.wrapped.getStackTrace());
        }
        return (StackTraceElement[])this.stackTrace.clone();
    }

    public StackTraceElement[] getStackTraceEliminatingDuplicateFrames() {
        if (this.parentFrames == null) {
            return this.getStackTrace();
        }
        if (this.noduplicatesStackTrace == null) {
            boolean duplicateFramesRemoved;
            ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
            StackTraceElement[] stackElements = this.getStackTrace();
            int numberToInclude = this.countNonDuplicatedFrames(this.parentFrames, stackElements);
            for (int i = 0; i < numberToInclude; ++i) {
                list.add(stackElements[i]);
            }
            boolean bl = duplicateFramesRemoved = numberToInclude < stackElements.length;
            if (duplicateFramesRemoved) {
                list.add(new StackTraceElement("... " + (stackElements.length - numberToInclude) + " more", DUPLICATE_FRAMES_EYECATCHER, null, 0));
            }
            this.noduplicatesStackTrace = list.toArray(new StackTraceElement[0]);
        }
        return (StackTraceElement[])this.noduplicatesStackTrace.clone();
    }

    private StackTraceElement[] getStackTrace(StackTraceElement[] stackElements) {
        ArrayList<StackTraceElement> trimmedStack = new ArrayList<StackTraceElement>();
        if (stackElements != null) {
            for (StackTraceElement element : stackElements) {
                boolean isInternal = this.isInternal(element);
                if (isInternal) {
                    if (trimmedStack.size() != 0 && trimmedStack.get(trimmedStack.size() - 1) == TRIMMED_STACK_TRACE_ELEMENT) continue;
                    trimmedStack.add(element);
                    trimmedStack.add(TRIMMED_STACK_TRACE_ELEMENT);
                    continue;
                }
                trimmedStack.add(element);
            }
            if (trimmedStack.contains(TRIMMED_STACK_TRACE_ELEMENT)) {
                boolean isCalledByIBMCode = true;
                ArrayList<Integer> maybeRemoves = new ArrayList<Integer>();
                for (int i = trimmedStack.size() - 1; i >= 0; --i) {
                    StackTraceElement element;
                    element = (StackTraceElement)trimmedStack.get(i);
                    if (element != TRIMMED_STACK_TRACE_ELEMENT && isCalledByIBMCode && this.isSpecOrThirdParty(element)) {
                        maybeRemoves.add(i);
                        continue;
                    }
                    if (isCalledByIBMCode && element == TRIMMED_STACK_TRACE_ELEMENT) {
                        Iterator i$ = maybeRemoves.iterator();
                        while (i$.hasNext()) {
                            int index = (Integer)i$.next();
                            trimmedStack.remove(index);
                        }
                        maybeRemoves.clear();
                        if (i >= trimmedStack.size() - 1) continue;
                        trimmedStack.remove(i);
                        if (i >= trimmedStack.size() - 1) continue;
                        trimmedStack.remove(i);
                        continue;
                    }
                    if (element == TRIMMED_STACK_TRACE_ELEMENT) {
                        isCalledByIBMCode = true;
                        continue;
                    }
                    if (this.isInternal(element) || this.isSpecOrThirdParty(element)) continue;
                    isCalledByIBMCode = false;
                    maybeRemoves.clear();
                }
            }
        }
        return trimmedStack.toArray(new StackTraceElement[0]);
    }

    private boolean isInternal(StackTraceElement element) {
        if (element == TRIMMED_STACK_TRACE_ELEMENT) {
            return true;
        }
        if (this.packageHelper != null) {
            String packageName = PackageProcessor.extractPackageFromStackTraceElement((StackTraceElement)element);
            return this.packageHelper.isIBMPackage(packageName);
        }
        return false;
    }

    private boolean isSpecOrThirdParty(StackTraceElement element) {
        if (element == TRIMMED_STACK_TRACE_ELEMENT) {
            return false;
        }
        if (this.packageHelper != null) {
            String packageName = PackageProcessor.extractPackageFromStackTraceElement((StackTraceElement)element);
            return this.packageHelper.isSpecOrThirdPartyOrBootDelegationPackage(packageName);
        }
        return false;
    }

    public Throwable getWrappedException() {
        return this.wrapped;
    }

    @Override
    public String getMessage() {
        return this.wrapped.getMessage();
    }

    public static String printStackTraceElement(StackTraceElement stackTraceElement) {
        String toString = stackTraceElement == null ? "at null" : (TRIMMED_STACK_TRACE_ELEMENT.equals(stackTraceElement) ? "at " + stackTraceElement.getClassName() : (DUPLICATE_FRAMES_EYECATCHER.equals(stackTraceElement.getMethodName()) ? stackTraceElement.getClassName() : "at " + stackTraceElement.toString()));
        return toString;
    }

    @Override
    public String toString() {
        return this.wrapped.toString();
    }
}

