/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class ThreadFactoryImpl
implements ThreadFactory {
    private static final TraceComponent tc = Tr.register(ThreadFactoryImpl.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    private static final boolean TRACE_ENABLED_AT_STARTUP = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
    private final AtomicInteger createdThreadCount = new AtomicInteger();
    private final String executorName;
    private final ThreadGroup threadGroup;
    private final ClassLoader contextClassLoader;
    static final long serialVersionUID = -3600085245630848128L;

    ThreadFactoryImpl(String executorName, final String threadGroupName) {
        this.executorName = executorName;
        this.threadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){
            static final long serialVersionUID = -4716703727269505907L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ThreadGroup run() {
                return new ThreadGroup(threadGroupName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ThreadFactoryImpl$1", 1.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
            }
        });
        this.contextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 6764142481618281051L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ThreadFactoryImpl$2", 2.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
            }
        });
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        int threadId = this.createdThreadCount.incrementAndGet();
        final String name = this.executorName + "-thread-" + threadId;
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){
            static final long serialVersionUID = 8436497916984357915L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Thread run() {
                Thread thread = TRACE_ENABLED_AT_STARTUP ? new LibertyThread(ThreadFactoryImpl.this.threadGroup, runnable, name) : new Thread(ThreadFactoryImpl.this.threadGroup, runnable, name);
                thread.setDaemon(true);
                thread.setPriority(5);
                thread.setContextClassLoader(ThreadFactoryImpl.this.contextClassLoader);
                return thread;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ThreadFactoryImpl$3", 3.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
            }
        });
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class LibertyThread
    extends Thread {
        static final long serialVersionUID = 7457178927700760494L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        LibertyThread(ThreadGroup tg, Runnable r, String name) {
            super(tg, r, name);
        }

        @Override
        @Trivial
        public void interrupt() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Throwable t = new Throwable("stack trace");
                Tr.debug((TraceComponent)tc, (String)("Thread.interrupt() called on " + this), (Object[])new Object[]{t});
            }
            super.interrupt();
        }

        @Override
        @Trivial
        public void setContextClassLoader(ClassLoader cl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Throwable t = new Throwable("stack trace");
                Tr.debug((TraceComponent)tc, (String)("Thread.setContextClassLoader( " + cl + " ) called on " + this), (Object[])new Object[]{t});
            }
            super.setContextClassLoader(cl);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.ThreadFactoryImpl$LibertyThread", LibertyThread.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }
}

