/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.VirtualThreadOps;
import com.ibm.ws.threading.internal.ExecutorServiceImpl;
import com.ibm.ws.threading.internal.PolicyExecutorImpl;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={PolicyExecutorProvider.class, ServerQuiesceListener.class})
public class PolicyExecutorProvider
implements ServerQuiesceListener {
    @Reference(target="(component.name=com.ibm.ws.threading)")
    private ExecutorService libertyThreadPool;
    private final ConcurrentHashMap<String, PolicyExecutorImpl> policyExecutors = new ConcurrentHashMap();
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile VirtualThreadOps virtualThreadOps;
    static final long serialVersionUID = 7532451481446949345L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PolicyExecutor create(Map<String, Object> props) {
        PolicyExecutorImpl executor = new PolicyExecutorImpl((ExecutorServiceImpl)this.libertyThreadPool, (String)props.get("config.displayId"), null, this.policyExecutors, this.virtualThreadOps);
        executor.updateConfig(props);
        return executor;
    }

    public PolicyExecutor create(String identifier) {
        return new PolicyExecutorImpl((ExecutorServiceImpl)this.libertyThreadPool, "PolicyExecutorProvider-" + identifier, null, this.policyExecutors, this.virtualThreadOps);
    }

    public PolicyExecutor create(String fullIdentifier, String owner) {
        return new PolicyExecutorImpl((ExecutorServiceImpl)this.libertyThreadPool, fullIdentifier, owner, this.policyExecutors, this.virtualThreadOps);
    }

    public void introspectPolicyExecutors(PrintWriter out) {
        for (PolicyExecutorImpl executor : this.policyExecutors.values()) {
            executor.introspect(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStopping() {
        ConcurrentHashMap<String, PolicyExecutorImpl> existingExecutors = new ConcurrentHashMap<String, PolicyExecutorImpl>();
        ConcurrentHashMap<String, PolicyExecutorImpl> concurrentHashMap = this.policyExecutors;
        synchronized (concurrentHashMap) {
            existingExecutors.putAll(this.policyExecutors);
        }
        for (PolicyExecutor pe : existingExecutors.values()) {
            pe.shutdown();
        }
    }

    public void shutdownNow(String owner) {
        for (PolicyExecutorImpl executor : this.policyExecutors.values()) {
            if (!owner.equals(executor.owner)) continue;
            executor.shutdownNow();
        }
    }

    public void shutdownNowByIdentifierPrefix(String prefix) {
        for (PolicyExecutorImpl executor : this.policyExecutors.values()) {
            if (!executor.getIdentifier().startsWith(prefix)) continue;
            executor.shutdownNow();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.PolicyExecutorProvider", PolicyExecutorProvider.class, null, null);
    }
}

