/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumper;
import com.ibm.ws.kernel.boot.jmx.service.VirtualMachineHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class HotSpotJavaDumperImpl
extends JavaDumper {
    private static final AtomicInteger nextSequenceNumber = new AtomicInteger(1);
    private final MBeanServer platformMBeanServer;
    private final ObjectName hotSpotDiagnosticName;
    private final ObjectName diagnosticCommandName;

    HotSpotJavaDumperImpl(MBeanServer platformMBeanServer, ObjectName diagName, ObjectName diagCommandName) {
        this.platformMBeanServer = platformMBeanServer;
        this.hotSpotDiagnosticName = diagName;
        this.diagnosticCommandName = diagCommandName;
    }

    @Override
    public File dump(JavaDumpAction action, File outputDir) {
        switch (action) {
            case HEAP: {
                return this.createHeapDump(outputDir);
            }
            case THREAD: {
                return this.createThreadDump(outputDir);
            }
        }
        return null;
    }

    private File createNewFile(File outputDir, String prefix, String extension) throws IOException {
        int sequenceNumber;
        String PID;
        String pid;
        File outputFile;
        String dateTime = new SimpleDateFormat("yyyyMMdd.HHmmss").format(new Date());
        while ((outputFile = new File(outputDir, String.format("%s.%s.%s%04d.%s", prefix, dateTime, pid = (PID = VirtualMachineHelper.getPID()) == null ? "" : PID + '.', sequenceNumber = nextSequenceNumber.getAndIncrement(), extension))).exists()) {
        }
        return outputFile;
    }

    private File createHeapDump(File outputDir) {
        File outputFile;
        if (this.hotSpotDiagnosticName == null) {
            return null;
        }
        try {
            outputFile = this.createNewFile(outputDir, "java", "hprof");
            this.platformMBeanServer.invoke(this.hotSpotDiagnosticName, "dumpHeap", new Object[]{outputFile.getAbsolutePath(), false}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return outputFile;
    }

    private File createThreadDump(File outputDir) {
        Method remoteDataDumpMethod;
        block14: {
            remoteDataDumpMethod = null;
            try {
                remoteDataDumpMethod = VirtualMachineHelper.getRemoteDumpMethod();
                if (remoteDataDumpMethod == null && this.diagnosticCommandName == null) {
                    return null;
                }
            }
            catch (RuntimeException e) {
                if (this.diagnosticCommandName != null) break block14;
                Throwable cause = e.getCause();
                throw cause instanceof RuntimeException ? (RuntimeException)cause : e;
            }
        }
        File outputFile = null;
        InputStream input = null;
        OutputStream output = null;
        boolean success = false;
        try {
            outputFile = this.createNewFile(outputDir, "javadump", "txt");
            if (remoteDataDumpMethod != null) {
                int read;
                input = this.remoteDataDump(remoteDataDumpMethod);
                input = new BufferedInputStream(input);
                output = new FileOutputStream(outputFile);
                output = new BufferedOutputStream(output);
                byte[] buf = new byte[8192];
                while ((read = input.read(buf)) != -1) {
                    output.write(buf, 0, read);
                }
            } else {
                String outputString;
                try {
                    outputString = (String)this.platformMBeanServer.invoke(this.diagnosticCommandName, "threadPrint", new Object[]{new String[]{"-l"}}, new String[]{String[].class.getName()});
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                output = new FileOutputStream(outputFile);
                OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
                writer.write(outputString);
                ((Writer)writer).close();
            }
            success = true;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                Utils.tryToClose(input);
                Utils.tryToClose(output);
                if (!success && outputFile != null && !outputFile.delete()) {
                    outputFile = null;
                }
                throw throwable;
            }
        }
        Utils.tryToClose(input);
        Utils.tryToClose(output);
        if (!success && outputFile != null && !outputFile.delete()) {
            outputFile = null;
        }
        return outputFile;
    }

    private InputStream remoteDataDump(Method remoteDataDumpMethod) throws IOException {
        try {
            Object[] dumpArgs = new Object[]{"-l"};
            return (InputStream)remoteDataDumpMethod.invoke(VirtualMachineHelper.getVirtualMachine(), new Object[]{dumpArgs});
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

