/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KernelUtils {
    private static final Map<String, TimeUnit> UNIT_DESCRIPTORS;
    private static final Pattern INTERVAL_STRING;
    private static File launchHome;
    private static URL launchURL;
    private static File libDir;

    @FFDCIgnore(value={Exception.class})
    public static String parseDuration(String duration, TimeUnit units) {
        try {
            return Long.toString(KernelUtils.evaluateDuration(duration, units));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @FFDCIgnore(value={NumberFormatException.class})
    public static Long evaluateDuration(String strVal, TimeUnit endUnit) {
        try {
            return Long.valueOf(strVal);
        }
        catch (NumberFormatException numberFormatException) {
            return KernelUtils.evaluateDuration(strVal, endUnit, UNIT_DESCRIPTORS);
        }
    }

    private static Long evaluateDuration(String strVal, TimeUnit endUnit, Map<String, TimeUnit> unitDescriptors) {
        Matcher m = INTERVAL_STRING.matcher(strVal);
        long retVal = 0L;
        boolean somethingParsed = false;
        while (m.find()) {
            somethingParsed = true;
            Long numberVal = Long.valueOf(m.group(1));
            String unitStr = m.group(2);
            if (unitStr == null) {
                throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
            }
            TimeUnit sourceUnit = unitDescriptors.get(unitStr.trim().toLowerCase());
            if (sourceUnit == null) {
                throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
            }
            retVal += endUnit.convert(numberVal, sourceUnit);
        }
        if (!somethingParsed) {
            throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
        }
        return retVal;
    }

    public static File getBootstrapJar() {
        if (launchHome == null) {
            if (launchURL == null) {
                launchURL = KernelUtils.getLocationFromClass(KernelUtils.class);
            }
            launchHome = FileUtils.getFile(launchURL);
        }
        return launchHome;
    }

    public static URL getLocationFromClass(Class<?> cls) {
        ProtectionDomain domain = cls.getProtectionDomain();
        CodeSource source = null;
        if (domain != null) {
            source = domain.getCodeSource();
        }
        if (domain == null || source == null) {
            throw new LaunchException("Can not automatically set the security manager. Please use a policy file.", MessageFormat.format(BootstrapConstants.messages.getString("error.secPermission"), null));
        }
        URL home = source.getLocation();
        if (!home.getProtocol().equals("file")) {
            throw new LaunchException("Launch location is not a local file (launch location=" + home + ")", MessageFormat.format(BootstrapConstants.messages.getString("error.unsupportedLaunch"), home));
        }
        return home;
    }

    public static URL getBootstrapJarURL() {
        if (launchURL == null) {
            KernelUtils.getBootstrapJar();
        }
        return launchURL;
    }

    public static File getBootstrapLibDir() {
        if (libDir == null) {
            libDir = KernelUtils.getBootstrapJar().getParentFile();
        }
        return libDir;
    }

    public static void setBootStrapLibDir(File libDir) {
        KernelUtils.libDir = libDir;
    }

    public static void cleanStart(File workareaFile) {
        KernelUtils.cleanDirectory(workareaFile, "workarea");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(InputStream is) throws IOException {
        Properties p = new Properties();
        try {
            if (is != null) {
                p.load(is);
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    String s = ((String)entry.getValue()).trim();
                    if (s.length() <= 1 || !s.startsWith("\"") || !s.endsWith("\"")) continue;
                    entry.setValue(s.substring(1, s.length() - 1));
                }
            }
        }
        finally {
            Utils.tryToClose(is);
        }
        return p;
    }

    public static String getServiceClass(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            String className = KernelUtils.getClassFromLine(line);
            if (className == null) continue;
            return className;
        }
        return null;
    }

    private static String getClassFromLine(String line) {
        if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
            return null;
        }
        String[] className = line.split("[\\s#]");
        if (className.length >= 1) {
            return className[0];
        }
        return null;
    }

    public static void cleanDirectory(File dir, String dirType) {
        boolean cleaned = true;
        if (dir.exists() && dir.isDirectory()) {
            cleaned = FileUtils.recursiveClean(dir);
        }
        if (!cleaned) {
            throw new IllegalStateException("The " + dirType + " could not be cleaned. " + dirType + "=" + dir);
        }
        boolean created = dir.mkdirs();
        if (!dir.exists() && !created) {
            throw new IllegalStateException("The " + dirType + "  could not be created. " + dirType + "=" + dir);
        }
    }

    static {
        HashMap<String, TimeUnit> units = new HashMap<String, TimeUnit>();
        units.put("d", TimeUnit.DAYS);
        units.put("dn\u016f", TimeUnit.DAYS);
        units.put("g", TimeUnit.DAYS);
        units.put("j", TimeUnit.DAYS);
        units.put("n", TimeUnit.DAYS);
        units.put("t", TimeUnit.DAYS);
        units.put("z", TimeUnit.DAYS);
        units.put("\u0434", TimeUnit.DAYS);
        units.put("\u5929", TimeUnit.DAYS);
        units.put("h", TimeUnit.HOURS);
        units.put("hod", TimeUnit.HOURS);
        units.put("\u00f3", TimeUnit.HOURS);
        units.put("\u0447", TimeUnit.HOURS);
        units.put("\u5c0f\u6642", TimeUnit.HOURS);
        units.put("m", TimeUnit.MINUTES);
        units.put("min", TimeUnit.MINUTES);
        units.put("\u043c", TimeUnit.MINUTES);
        units.put("\u5206", TimeUnit.MINUTES);
        units.put("e", TimeUnit.SECONDS);
        units.put("mp", TimeUnit.SECONDS);
        units.put("s", TimeUnit.SECONDS);
        units.put("\u0441", TimeUnit.SECONDS);
        units.put("\u79d2", TimeUnit.SECONDS);
        units.put("ms", TimeUnit.MILLISECONDS);
        units.put("\u043c\u0441", TimeUnit.MILLISECONDS);
        units.put("\u6beb\u79d2", TimeUnit.MILLISECONDS);
        UNIT_DESCRIPTORS = Collections.unmodifiableMap(units);
        INTERVAL_STRING = Pattern.compile("(\\d+)(\\D+)");
        launchHome = null;
        launchURL = null;
        libDir = null;
    }
}

