/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.crypto.ltpakeyutil.KeyEncryptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.ltpa.LTPAValidationKeysInfo;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyFileCreatorImpl;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPAKeyInfoManager {
    private static final TraceComponent tc = Tr.register(LTPAKeyInfoManager.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    private static final String SECRETKEY = "secretkey";
    private static final String PRIVATEKEY = "privatekey";
    private static final String PUBLICKEY = "publickey";
    private final List<String> importFileCache = new ArrayList<String>();
    private final Map<String, byte[]> keyCache = new Hashtable<String, byte[]>();
    private final Map<String, String> realmCache = new Hashtable<String, String>();
    private static List<LTPAValidationKeysInfo> ltpaValidationKeysInfos = new ArrayList<LTPAValidationKeysInfo>();
    static final long serialVersionUID = -5325421924941397720L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Properties loadPropertiesFile(WsResource res) throws IOException {
        Properties props = new Properties();
        InputStream is = res.get();
        try {
            props.load(is);
            if (is == null) return props;
        }
        catch (IOException iOException) {
            try {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.token.ltpa.LTPAKeyInfoManager", (String)"98", (Object)this, (Object[])new Object[]{res});
                if (!TraceComponent.isAnyTracingEnabled()) throw e;
                if (!tc.isEventEnabled()) throw e;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Error loading properties; " + e), (Object[])new Object[0]);
                throw e;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.security.token.ltpa.LTPAKeyInfoManager", (String)"107", (Object)this, (Object[])new Object[]{res});
                }
                throw throwable;
            }
        }
        try {
            is.close();
            return props;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.token.ltpa.LTPAKeyInfoManager", (String)"107", (Object)this, (Object[])new Object[]{res});
            return props;
        }
    }

    public final synchronized void prepareLTPAKeyInfo(WsLocationAdmin locService, String primaryKeyImportFile, @Sensitive byte[] primaryKeyPassword, @Sensitive List<Properties> validationKeys) throws Exception {
        if (!this.importFileCache.contains(primaryKeyImportFile)) {
            this.loadLtpaKeysFile(locService, primaryKeyImportFile, primaryKeyPassword, false, null);
        }
        if (validationKeys != null && !validationKeys.isEmpty()) {
            ltpaValidationKeysInfos.clear();
            Iterator<Properties> validationKeysIterator = validationKeys.iterator();
            while (validationKeysIterator.hasNext()) {
                String filename;
                Properties vKeys;
                OffsetDateTime validUntilDateOdt;
                block8: {
                    validUntilDateOdt = null;
                    vKeys = validationKeysIterator.next();
                    filename = (String)vKeys.get("fileName");
                    if (this.importFileCache.contains(vKeys.get("fileName"))) continue;
                    String validUntilDate = (String)vKeys.get("validUntilDate");
                    if (validUntilDate != null) {
                        try {
                            validUntilDateOdt = OffsetDateTime.parse(validUntilDate);
                            if (validUntilDateOdt != null && this.isValidUntilDateExpired(filename, validUntilDateOdt)) {
                            }
                            break block8;
                        }
                        catch (Exception exception) {
                            Object[] objectArray = new Object[4];
                            objectArray[0] = locService;
                            objectArray[1] = primaryKeyImportFile;
                            objectArray[2] = "<sensitive byte[]>";
                            objectArray[3] = "<sensitive java.util.List>";
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.ltpa.LTPAKeyInfoManager", (String)"143", (Object)this, (Object[])objectArray);
                            Tr.error((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_VALID_UNTIL_DATE_INVALID_FORMAT", (Object[])new Object[]{validUntilDate, filename});
                        }
                        continue;
                    }
                }
                byte[] password = this.getKeyPasswordBytes(vKeys);
                this.loadLtpaKeysFile(locService, filename, password, true, validUntilDateOdt);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("importFileCache: " + this.importFileCache.toString()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("keyCache: " + this.keyCache.toString()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("realmCache: " + this.realmCache.toString()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("number of ltpaValidationKeysInfos: " + ltpaValidationKeysInfos.size()), (Object[])new Object[0]);
        }
    }

    public boolean isValidUntilDateExpired(String filename, OffsetDateTime validUntilDateOdt) {
        OffsetDateTime currentTime = OffsetDateTime.now(validUntilDateOdt.getOffset());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current date: " + currentTime), (Object[])new Object[0]);
        }
        if (validUntilDateOdt.isBefore(currentTime)) {
            Tr.warning((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_VALID_UNTIL_DATE_IS_IN_THE_PAST", (Object[])new Object[]{validUntilDateOdt, filename});
            return true;
        }
        return false;
    }

    @Sensitive
    byte[] getKeyPasswordBytes(@Sensitive Properties vKeys) {
        String password = (String)vKeys.get("password");
        return PasswordUtil.passwordDecode((String)password).getBytes();
    }

    /*
     * WARNING - void declaration
     */
    private void loadLtpaKeysFile(WsLocationAdmin locService, String keyImportFile, byte[] keyPassword, boolean validationKey, OffsetDateTime validUntilDateOdt) throws IOException, Exception {
        byte[] publicKey;
        byte[] privateKey;
        byte[] secretKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Loading LTPA " + (validationKey ? "validation" : "primary") + "Keys file: " + keyImportFile), (Object[])new Object[0]);
        }
        Properties props = null;
        WsResource ltpaKeyFileResource = this.getLTPAKeyFileResource(locService, keyImportFile);
        if (ltpaKeyFileResource != null) {
            props = this.loadPropertiesFile(ltpaKeyFileResource);
        } else {
            if (validationKey) {
                Tr.error((TraceComponent)tc, (String)"LTPA_KEYS_FILE_DOES_NOT_EXIST", (Object[])new Object[]{keyImportFile});
                return;
            }
            long start = System.currentTimeMillis();
            Tr.info((TraceComponent)tc, (String)"LTPA_CREATE_KEYS_START", (Object[])new Object[0]);
            LTPAKeyFileCreatorImpl creator = new LTPAKeyFileCreatorImpl();
            props = creator.createLTPAKeysFile(locService, keyImportFile, keyPassword);
            Tr.audit((TraceComponent)tc, (String)"LTPA_CREATE_KEYS_COMPLETE", (Object[])new Object[]{TimestampUtils.getElapsedTime((long)start), keyImportFile});
        }
        if (props == null || props.isEmpty()) {
            return;
        }
        String realm = props.getProperty("com.ibm.websphere.ltpa.Realm");
        String secretKeyStr = props.getProperty("com.ibm.websphere.ltpa.3DESKey");
        String privateKeyStr = props.getProperty("com.ibm.websphere.ltpa.PrivateKey");
        String publicKeyStr = props.getProperty("com.ibm.websphere.ltpa.PublicKey");
        try {
            String formattedMessage;
            KeyEncryptor encryptor = new KeyEncryptor(keyPassword);
            if (secretKeyStr == null || secretKeyStr.length() == 0) {
                Tr.error((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.3DESKey"});
                String formattedMessage2 = Tr.formatMessage((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.3DESKey"});
                throw new IllegalArgumentException(formattedMessage2);
            }
            byte[] keyEncoded = Base64Coder.base64DecodeString((String)secretKeyStr);
            secretKey = encryptor.decrypt(keyEncoded);
            if (privateKeyStr == null || privateKeyStr.length() == 0) {
                Tr.error((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.PrivateKey"});
                formattedMessage = Tr.formatMessage((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.PrivateKey"});
                throw new IllegalArgumentException(formattedMessage);
            }
            keyEncoded = Base64Coder.base64DecodeString((String)privateKeyStr);
            privateKey = encryptor.decrypt(keyEncoded);
            if (publicKeyStr == null || publicKeyStr.length() == 0) {
                Tr.error((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.PublicKey"});
                formattedMessage = Tr.formatMessage((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.PublicKey"});
                throw new IllegalArgumentException(formattedMessage);
            }
            publicKey = keyEncoded = Base64Coder.base64DecodeString((String)publicKeyStr);
        }
        catch (Exception encryptor) {
            void e;
            FFDCFilter.processException((Throwable)encryptor, (String)"com.ibm.ws.security.token.ltpa.LTPAKeyInfoManager", (String)"267", (Object)this, (Object[])new Object[]{locService, keyImportFile, keyPassword, validationKey, validUntilDateOdt});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Error loading key; " + e), (Object[])new Object[0]);
            }
            throw e;
        }
        if (secretKey != null) {
            this.keyCache.put(keyImportFile + SECRETKEY, secretKey);
        }
        if (privateKey != null) {
            this.keyCache.put(keyImportFile + PRIVATEKEY, privateKey);
        }
        if (publicKey != null) {
            this.keyCache.put(keyImportFile + PUBLICKEY, publicKey);
        }
        if (realm != null) {
            this.realmCache.put(keyImportFile, realm);
        }
        this.importFileCache.add(keyImportFile);
        if (validationKey) {
            ltpaValidationKeysInfos.add(new LTPAValidationKeysInfo(keyImportFile, secretKey, privateKey, publicKey, validUntilDateOdt));
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("ValidationKeys: " + keyImportFile + " validUntilDate: " + validUntilDateOdt), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("LTPAValidationKeysInfo size: " + ltpaValidationKeysInfos.size()), (Object[])new Object[0]);
            }
        }
    }

    final WsResource getLTPAKeyFileResource(WsLocationAdmin locService, String ltpaKeyFile) {
        WsResource ltpaFile = locService.resolveResource(ltpaKeyFile);
        if (ltpaFile != null && ltpaFile.exists()) {
            return ltpaFile;
        }
        return null;
    }

    @Sensitive
    public final byte[] getSecretKey(String keyImportFile) {
        return this.keyCache.get(keyImportFile + SECRETKEY);
    }

    @Sensitive
    public final byte[] getPrivateKey(String keyImportFile) {
        return this.keyCache.get(keyImportFile + PRIVATEKEY);
    }

    public final byte[] getPublicKey(String keyImportFile) {
        return this.keyCache.get(keyImportFile + PUBLICKEY);
    }

    final String getRealm(String keyImportFile) {
        return this.realmCache.get(keyImportFile);
    }

    public final List<LTPAValidationKeysInfo> getValidationLTPAKeys() {
        return ltpaValidationKeysInfos;
    }
}

