/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.RLSControllerImpl;
import com.ibm.ws.recoverylog.spi.RLSInvalidSuspendTokenException;
import com.ibm.ws.recoverylog.spi.RLSSuspendToken;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class RLSSuspendTokenManager
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(RLSSuspendTokenManager.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static RLSSuspendTokenManager _instance = new RLSSuspendTokenManager();
    private final HashMap<RLSSuspendToken, Alarm> _tokenMap;
    static final long serialVersionUID = 8461558562218718454L;

    @ManualTrace
    private RLSSuspendTokenManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RLSSuspendTokenManager", (Object[])new Object[0]);
        }
        this._tokenMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RLSSuspendTokenManager", (Object)this);
        }
    }

    @ManualTrace
    static RLSSuspendTokenManager getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstance", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInstance", (Object)_instance);
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    RLSSuspendToken registerSuspend(int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerSuspend", (Object[])new Object[]{timeout});
        }
        RLSSuspendToken token = Configuration.getRecoveryLogComponent().createRLSSuspendToken(null);
        Alarm alarm = null;
        if (timeout > 0) {
            alarm = Configuration.getAlarmManager().scheduleAlarm((long)timeout * 1000L, (AlarmListener)this, (Object)token);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Alarm has been created for this suspend call", (Object[])new Object[]{alarm});
            }
        }
        HashMap<RLSSuspendToken, Alarm> hashMap = this._tokenMap;
        synchronized (hashMap) {
            this._tokenMap.put(token, alarm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerSuspend", (Object)token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alarm", (Object[])new Object[]{object});
        }
        HashMap<RLSSuspendToken, Alarm> hashMap = this._tokenMap;
        synchronized (hashMap) {
            if (this._tokenMap.containsKey(object)) {
                this._tokenMap.remove(object);
                Tr.info((TraceComponent)tc, (String)"CWRLS0022_RLS_SUSPEND_TIMEOUT", (Object[])new Object[]{object});
            }
        }
        RLSControllerImpl.notifyTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    void registerResume(RLSSuspendToken token) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerResume", (Object[])new Object[]{token});
        }
        if (token != null && this._tokenMap.containsKey(token)) {
            HashMap<RLSSuspendToken, Alarm> hashMap = this._tokenMap;
            synchronized (hashMap) {
                Alarm alarm = this._tokenMap.remove(token);
                if (alarm != null) {
                    alarm.cancel();
                }
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Throw RLSInvalidSuspendTokenException - suspend token is not recognised", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerResume", (Object)"RLSInvalidSuspendTokenException");
            }
            throw new RLSInvalidSuspendTokenException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerResume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    boolean isResumable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isResumable", (Object[])new Object[0]);
        }
        boolean isResumable = true;
        HashMap<RLSSuspendToken, Alarm> hashMap = this._tokenMap;
        synchronized (hashMap) {
            if (!this._tokenMap.isEmpty()) {
                isResumable = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isResumable", (Object)isResumable);
        }
        return isResumable;
    }
}

