/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collective.singleton.ServiceEndpointIdentityImpl;
import com.ibm.ws.collective.singleton.internal.HostSingletonElector;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ElectorPort {
    private static final TraceComponent tc = Tr.register(ElectorPort.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
    private ServerSocketChannel channel;
    private ServerSocket serverSocket;
    private SocketChannel channelToLeader;
    private final int port;
    private final ServiceEndpointIdentity id;
    private final HostSingletonElector elector;
    private Selector selector;
    private final Map<SocketChannel, ServiceEndpointIdentity> memberMap = new HashMap<SocketChannel, ServiceEndpointIdentity>();
    private final String MESSAGE_VERSION_KEY = "version";
    private final String MESSAGE_VERSION = "1";
    private final String MESSAGE_TYPE_KEY = "type";
    private final String IDENTITY_MESSAGE = "ID";
    private final String IDENTITY = "Identity";
    ByteBuffer buffer = ByteBuffer.allocate(65536);
    static final long serialVersionUID = -6091929348849416497L;

    protected ElectorPort(int port, ServiceEndpointIdentity id, HostSingletonElector elector) {
        this.port = port;
        this.id = id;
        this.elector = elector;
    }

    protected void openForMonitoring() throws IOException {
        this.setupChannelAndSocket();
        this.bind();
        this.setupSelector();
    }

    protected void stop() {
        if (this.serverSocket != null) {
            this.close(this.serverSocket);
            this.serverSocket = null;
        }
        if (this.channel != null) {
            this.close(this.channel);
            this.channel = null;
        }
        if (this.channelToLeader != null) {
            this.close(this.channelToLeader);
            this.channelToLeader = null;
        }
    }

    @FFDCIgnore(value={IOException.class})
    private void close(Closeable closeable) {
        block2: {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (!tc.isEventEnabled()) break block2;
                Tr.event((TraceComponent)tc, (String)"Exception closing", (Object[])new Object[]{closeable, e});
            }
        }
    }

    @FFDCIgnore(value={IOException.class})
    private void close(ServerSocket ss) {
        block2: {
            try {
                ss.close();
            }
            catch (IOException e) {
                if (!tc.isEventEnabled()) break block2;
                Tr.event((TraceComponent)tc, (String)"Exception closing serverSocket", (Object[])new Object[]{e});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setupChannelAndSocket() throws IOException {
        try {
            this.channel = ServerSocketChannel.open();
            this.channel.configureBlocking(false);
            this.serverSocket = this.channel.socket();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.collective.singleton.internal.ElectorPort", (String)"124", (Object)this, (Object[])new Object[0]);
            throw e;
        }
    }

    private void bind() throws IOException {
        InetSocketAddress address = new InetSocketAddress(this.getLoopback(), this.port);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Binding to address: " + address), (Object[])new Object[0]);
        }
        this.serverSocket.bind(address);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Bind was successful", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setupSelector() throws IOException {
        try {
            this.selector = Selector.open();
            this.channel.register(this.selector, 16);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.collective.singleton.internal.ElectorPort", (String)"148", (Object)this, (Object[])new Object[0]);
            throw e;
        }
    }

    protected void monitorMembers() throws IOException {
        while (true) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Entering select", (Object[])new Object[0]);
            }
            int channels = this.selector.select();
            if (Thread.currentThread().isInterrupted()) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"monitorMembers is exiting after being interrupted", (Object[])new Object[0]);
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Number of ready channels: " + channels), (Object[])new Object[0]);
            }
            if (channels <= 0) continue;
            Set<SelectionKey> keys = this.selector.selectedKeys();
            for (SelectionKey key : keys) {
                if (key.isAcceptable()) {
                    this.handleConnection();
                    continue;
                }
                if (!key.isReadable()) continue;
                this.handleInputFromFollower(key);
            }
            keys.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleConnection() {
        block3: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Handling new connection", (Object[])new Object[0]);
            }
            try {
                Socket socket = this.accept();
                SocketChannel newChannel = socket.getChannel();
                newChannel.configureBlocking(false);
                newChannel.register(this.selector, 1);
            }
            catch (IOException socket) {
                void e;
                FFDCFilter.processException((Throwable)socket, (String)"com.ibm.ws.collective.singleton.internal.ElectorPort", (String)"196", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Exception in handleConnection: ", (Object[])new Object[]{e});
            }
        }
    }

    private Socket accept() throws IOException {
        return AccessController.doPrivileged(new PrivilegedAction<Socket>(){
            static final long serialVersionUID = 6506875949129016179L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={IOException.class})
            public Socket run() {
                try {
                    return ElectorPort.this.serverSocket.accept();
                }
                catch (IOException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"IOException caught while trying to accept from host election port.", (Object[])new Object[]{e});
                    }
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.singleton.internal.ElectorPort$1", 1.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
            }
        });
    }

    @FFDCIgnore(value={IOException.class})
    private void handleInputFromFollower(SelectionKey key) {
        SocketChannel sc = null;
        try {
            sc = (SocketChannel)key.channel();
            Properties message = this.processChannelInput(sc);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Incoming message: " + message), (Object[])new Object[0]);
            }
            if (message != null) {
                if (this.memberMap.containsKey(sc)) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)(this.memberMap.get(sc) + " says: " + message), (Object[])new Object[0]);
                    }
                } else if (this.isIdentityMessage(message)) {
                    ServiceEndpointIdentityImpl id = this.getIdentityFromMessage(message);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"storing in memberMap", (Object[])new Object[]{sc, id});
                    }
                    this.memberMap.put(sc, id);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Now monitoring " + this.memberMap.size() + " local members."), (Object[])new Object[0]);
                    }
                    this.elector.addCandidate(id);
                    this.sendIdentity(sc);
                } else if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unknown message from " + sc), (Object[])new Object[]{message});
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Closing connection after null message received.", (Object[])new Object[0]);
                }
                this.closeMemberConnection(key, sc);
            }
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Closing socket channel after getting IOException.", (Object[])new Object[]{e});
            }
            this.closeMemberConnection(key, sc);
        }
    }

    private ServiceEndpointIdentityImpl getIdentityFromMessage(Properties message) {
        ServiceEndpointIdentityImpl identity = new ServiceEndpointIdentityImpl();
        identity.fromCanonicalForm(message.getProperty("Identity"));
        return identity;
    }

    @FFDCIgnore(value={IOException.class})
    private void closeMemberConnection(SelectionKey key, SocketChannel sc) {
        block4: {
            ServiceEndpointIdentity id = this.memberMap.get(sc);
            this.elector.removeCandidate(id);
            key.cancel();
            try {
                sc.close();
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Ignoring exception closing socket channel: ", (Object[])new Object[]{e});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"removing from memberMap", (Object[])new Object[]{sc, this.memberMap.get(sc)});
        }
        this.memberMap.remove(sc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Now monitoring " + this.memberMap.size() + " local members."), (Object[])new Object[0]);
        }
    }

    private Properties processChannelInput(SocketChannel sc) throws IOException {
        this.buffer.clear();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Reading from SocketChannel...", (Object[])new Object[0]);
        }
        int bytesRead = sc.read(this.buffer);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Read " + bytesRead + " bytes"), (Object[])new Object[0]);
        }
        if (bytesRead <= 0) {
            return null;
        }
        this.buffer.flip();
        String outputString = new String(this.buffer.array(), 0, this.buffer.limit());
        StringReader sr = new StringReader(outputString);
        Properties p = new Properties();
        p.load(sr);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Loaded incoming properties: " + p), (Object[])new Object[0]);
        }
        return p;
    }

    protected void connectToLeader() throws IOException {
        this.channelToLeader = this.openLeaderConnection();
        this.sendIdentity(this.channelToLeader);
        this.handleInputFromLeader(this.channelToLeader);
    }

    @FFDCIgnore(value={IOException.class})
    private void handleInputFromLeader(SocketChannel channel) throws IOException {
        block10: {
            try {
                while (true) {
                    Properties message = this.processChannelInput(channel);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Received message on election port: " + message), (Object[])new Object[0]);
                    }
                    if (message == null) break;
                    if (this.isIdentityMessage(message)) {
                        this.elector.setLeader(this.getIdentityFromMessage(message));
                        continue;
                    }
                    if (!tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Unknown message from " + channel), (Object[])new Object[]{message});
                }
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"Closing leader connection after null message received.", (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                block12: {
                    this.elector.setLeader(null);
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)"Ignoring exception closing socket channel: ", (Object[])new Object[]{e});
                    }
                }
                throw throwable;
            }
        }
        this.elector.setLeader(null);
        try {
            channel.close();
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring exception closing socket channel: ", (Object[])new Object[]{e});
            }
        }
    }

    @FFDCIgnore(value={InterruptedException.class})
    private SocketChannel openLeaderConnection() throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        channel.connect(new InetSocketAddress(this.getLoopback(), this.port));
        while (!channel.finishConnect()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Still connecting", (Object[])new Object[0]);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        channel.configureBlocking(true);
        return channel;
    }

    private InetAddress getLoopback() {
        InetAddress address = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){
            static final long serialVersionUID = 2098712669767146671L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={IOException.class})
            public InetAddress run() {
                InetAddress myAddress;
                block2: {
                    myAddress = null;
                    try {
                        myAddress = InetAddress.getByName(null);
                    }
                    catch (IOException e) {
                        if (!tc.isDebugEnabled()) break block2;
                        Tr.debug((TraceComponent)tc, (String)"IOException caught while trying to open host leader election socket.", (Object[])new Object[]{e});
                    }
                }
                return myAddress;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.singleton.internal.ElectorPort$2", 2.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
            }
        });
        return address;
    }

    @FFDCIgnore(value={IOException.class})
    private void sendIdentity(SocketChannel sc) {
        block2: {
            Properties message = new Properties();
            message = this.getIdentityMessage();
            try {
                this.sendMessage(sc, message);
            }
            catch (IOException e) {
                if (!tc.isEventEnabled()) break block2;
                Tr.event((TraceComponent)tc, (String)"Unable to send identity message", (Object[])new Object[]{e});
            }
        }
    }

    @FFDCIgnore(value={IOException.class})
    private void sendMessage(SocketChannel sc, Properties message) throws IOException {
        try {
            StringWriter sw = new StringWriter();
            message.store(sw, null);
            String s = sw.toString();
            ByteBuffer buf = ByteBuffer.allocateDirect(s.length());
            buf.put(s.getBytes());
            buf.flip();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("About to write " + s.length() + " bytes..."), (Object[])new Object[0]);
            }
            int numBytesWritten = sc.write(buf);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Wrote " + numBytesWritten + " bytes"), (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            if (!e.getMessage().contains("Connection reset by peer")) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".sendMessage"), (String)"422", (Object)this);
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Connection reset by peer when sending message", (Object[])new Object[0]);
            }
            throw e;
        }
    }

    private Properties getIdentityMessage() {
        Properties message = new Properties();
        message.setProperty("version", "1");
        message.setProperty("type", "ID");
        try {
            message.setProperty("Identity", this.id.toCanonicalForm());
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.collective.singleton.internal.ElectorPort", (String)"476", (Object)this, (Object[])new Object[0]);
            message = null;
        }
        return message;
    }

    private boolean isIdentityMessage(Properties message) {
        return message.getProperty("type").equals("ID");
    }
}

