/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CaptureCache<T> {
    private static final TraceComponent tc = Tr.register(CaptureCache.class, (String)"app.manager", (String)"com.ibm.ws.app.manager.module.internal.resources.Messages");
    private final String tag;
    private final Object cacheLock;
    private final Map<String, KeyData> keys;
    private static Function<String, KeyData> keySource = missingKey -> new KeyData(new String((String)missingKey));
    private final Map<String, CaptureSupplier<T>> storage;
    static final long serialVersionUID = -5930234636300530486L;

    @Trivial
    protected static void debug(String tag, String methodName, String text) {
        String debugText = "[" + tag + "]." + methodName + ": " + text;
        Tr.debug((TraceComponent)tc, (String)debugText, (Object[])new Object[0]);
    }

    @Trivial
    protected static void warning(String tag, String methodName, String text) {
        String warningText = "[" + tag + "]." + methodName + ": " + text;
        Tr.warning((TraceComponent)tc, (String)warningText, (Object[])new Object[0]);
    }

    public CaptureCache(String tag) {
        this.tag = tag;
        this.cacheLock = new Object();
        this.keys = new HashMap<String, KeyData>();
        this.storage = new IdentityHashMap<String, CaptureSupplier<T>>();
    }

    @Trivial
    public String getTag() {
        return this.tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyData getKey(String key) {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.keys.get(key);
        }
    }

    private KeyData acquire(String key) {
        KeyData keyData = this.keys.computeIfAbsent(key, keySource);
        keyData.increment();
        return keyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(String key) {
        CaptureSupplier<T> supplier;
        int newCount;
        boolean isDebugEnabled = tc.isDebugEnabled();
        Object object = this.cacheLock;
        synchronized (object) {
            KeyData keyData = this.keys.get(key);
            if (keyData == null) {
                Object uniqueKey = null;
                newCount = -1;
                supplier = null;
            } else {
                String uniqueKey = keyData.getKey();
                newCount = keyData.decrement();
                if (newCount <= 0) {
                    this.keys.remove(key);
                    supplier = this.storage.remove(uniqueKey);
                } else {
                    supplier = isDebugEnabled ? this.storage.get(uniqueKey) : null;
                }
            }
        }
        if (isDebugEnabled || newCount < 0) {
            String baseText = "[ " + key + " ] [ " + newCount + " ]: [ " + supplier + " ]";
            if (isDebugEnabled) {
                CaptureCache.debug(this.getTag(), "release", baseText);
            }
            if (newCount < 0) {
                CaptureCache.warning(this.getTag(), "release", "Unexpected: " + baseText);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.keys.clear();
            this.storage.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.storage.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CaptureSupplier.SupplierSnapShot<T>> snapshot() {
        Object object = this.cacheLock;
        synchronized (object) {
            HashMap snapshot = new HashMap(this.storage.size());
            BiConsumer<String, CaptureSupplier> snapper = (key, captureSupplier) -> snapshot.put((String)key, captureSupplier.snapshot());
            this.storage.forEach(snapper);
            return snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaptureSupplier<T> capture(String key, BaseCaptureSupplier<T> baseSupplier) {
        CaptureSupplier captureSupplier;
        Function<String, CaptureSupplier> supplierSource = uniqueKey -> new CaptureSupplier((String)uniqueKey, baseSupplier);
        boolean isDebugEnabled = tc.isDebugEnabled();
        int count = 0;
        Object object = this.cacheLock;
        synchronized (object) {
            KeyData keyData = this.acquire(key);
            count = isDebugEnabled ? keyData.count : 0;
            captureSupplier = this.storage.computeIfAbsent(keyData.getKey(), supplierSource);
        }
        if (isDebugEnabled) {
            CaptureCache.debug(this.getTag(), "capture", "[ " + key + " ] [ " + count + " ] [ " + captureSupplier + " ]");
        }
        return captureSupplier;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class KeyData {
        private final String key;
        private int count;
        static final long serialVersionUID = -1012566432310187225L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public KeyData(String key) {
            if (key == null) {
                throw new IllegalArgumentException("Disallowed null key");
            }
            this.key = key;
            this.count = 0;
        }

        public String getKey() {
            return this.key;
        }

        public int getCount() {
            return this.count;
        }

        protected int increment() {
            return ++this.count;
        }

        protected int decrement() {
            return --this.count;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(KeyData.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.CaptureCache$KeyData");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class CaptureSupplier<T> {
        public static final String INNER_CLASS_NAME;
        private final String tag;
        private final BaseCaptureSupplier<T> baseSupplier;
        private T captured;
        static final long serialVersionUID = -2758130428491739003L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CaptureSupplier(String tag, BaseCaptureSupplier<T> baseSupplier) {
            this.tag = tag;
            this.baseSupplier = baseSupplier;
            this.captured = null;
        }

        @Trivial
        public String getTag() {
            return this.tag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SupplierSnapShot<T> snapshot() {
            CaptureSupplier captureSupplier = this;
            synchronized (captureSupplier) {
                return new SupplierSnapShot<T>(this.baseSupplier, this.captured);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            T priorProduct;
            CaptureSupplier captureSupplier = this;
            synchronized (captureSupplier) {
                priorProduct = this.captured;
                this.captured = this.baseSupplier.get(priorProduct);
            }
            if (tc.isDebugEnabled()) {
                if (this.captured == priorProduct) {
                    CaptureCache.debug("get", this.getTag(), "[ " + priorProduct + " ]");
                } else {
                    CaptureCache.debug("get", this.getTag(), "[ " + priorProduct + " ] [ " + this.captured + " ]");
                }
            }
            return this.captured;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CaptureSupplier.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.CaptureCache$CaptureSupplier");
            INNER_CLASS_NAME = CaptureSupplier.class.getSimpleName();
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        @TraceOptions
        public static class SupplierSnapShot<T> {
            public final BaseCaptureSupplier<T> baseSupplier;
            public final T captured;
            static final long serialVersionUID = 4102312835219164682L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            protected SupplierSnapShot(BaseCaptureSupplier<T> baseSupplier, T captured) {
                this.baseSupplier = baseSupplier;
                this.captured = captured;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(SupplierSnapShot.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.CaptureCache$CaptureSupplier$SupplierSnapShot");
            }
        }
    }

    @FunctionalInterface
    public static interface BaseCaptureSupplier<T> {
        public T get(T var1);
    }
}

