/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.app.deploy.extended;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManifestClassPathHelper {
    static final TraceComponent tc = Tr.register(ManifestClassPathHelper.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    static final long serialVersionUID = -6800937263204614303L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processMFClasspath(Entry jarEntry, Container jarContainer, List<ContainerInfo> containers, Collection<String> resolved, boolean addRoot) throws UnableToAdaptException {
        String mfClassPath;
        block19: {
            Entry manifestEntry;
            mfClassPath = null;
            if (jarEntry != null && jarContainer != null && (manifestEntry = jarContainer.getEntry("/META-INF/MANIFEST.MF")) != null) {
                InputStream is = null;
                try {
                    is = (InputStream)manifestEntry.adapt(InputStream.class);
                    Manifest manifest = new Manifest(is);
                    if (manifest != null) {
                        mfClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                    }
                    if (is == null) break block19;
                }
                catch (IOException manifest) {
                    try {
                        void e;
                        FFDCFilter.processException((Throwable)manifest, (String)"com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper", (String)"49", null, (Object[])new Object[]{jarEntry, jarContainer, containers, resolved, addRoot});
                        throw new UnableToAdaptException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper", (String)"55", null, (Object[])new Object[]{jarEntry, jarContainer, containers, resolved, addRoot});
                        }
                        throw throwable;
                    }
                }
                try {
                    is.close();
                }
                catch (IOException manifest) {
                    FFDCFilter.processException((Throwable)manifest, (String)"com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper", (String)"55", null, (Object[])new Object[]{jarEntry, jarContainer, containers, resolved, addRoot});
                }
            }
        }
        if (mfClassPath == null) return;
        StringTokenizer tokenizer = new StringTokenizer(mfClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            if (path.equals(".")) {
                if (!addRoot) continue;
                final Container rootContainer = jarEntry.getRoot();
                containers.add(new ContainerInfo(){
                    static final long serialVersionUID = 521639578977887459L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.MANIFEST_CLASSPATH;
                    }

                    @Override
                    public String getName() {
                        return "/";
                    }

                    @Override
                    public Container getContainer() {
                        return rootContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper$1", 1.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
                    }
                });
                continue;
            }
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException uRISyntaxException) {
                FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper", (String)"91", null, (Object[])new Object[]{jarEntry, jarContainer, containers, resolved, addRoot});
                Tr.warning((TraceComponent)tc, (String)"WARN_INVALID_MANIFEST_CLASSPATH_DEFINITION", (Object[])new Object[]{path, jarEntry.getResource()});
                continue;
            }
            if (pathUri.isAbsolute()) {
                Tr.warning((TraceComponent)tc, (String)"WARN_INVALID_MANIFEST_CLASSPATH_DEFINITION", (Object[])new Object[]{path, jarEntry.getResource()});
                continue;
            }
            try {
                Entry classPathEntry = ManifestClassPathHelper.findClassPathEntry(jarEntry, pathUri);
                if (classPathEntry == null) {
                    Tr.warning((TraceComponent)tc, (String)"WARN_MANIFEST_CLASSPATH_NOT_FOUND", (Object[])new Object[]{path, jarEntry.getResource()});
                    continue;
                }
                final String classPathName = ManifestClassPathUtils.createEntryIdentity(classPathEntry);
                final Container classPathContainer = (Container)classPathEntry.adapt(Container.class);
                if (classPathContainer != null) {
                    containers.add(new ContainerInfo(){
                        static final long serialVersionUID = -8396390604089491975L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public ContainerInfo.Type getType() {
                            return ContainerInfo.Type.MANIFEST_CLASSPATH;
                        }

                        @Override
                        public String getName() {
                            return classPathName;
                        }

                        @Override
                        public Container getContainer() {
                            return classPathContainer;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper$2", 2.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
                        }
                    });
                }
                if (!classPathEntry.getName().endsWith(".jar")) continue;
                ManifestClassPathHelper.addCompleteJarEntryUrls(containers, classPathEntry, classPathContainer, resolved);
            }
            catch (URISyntaxException classPathEntry) {
                void e;
                FFDCFilter.processException((Throwable)classPathEntry, (String)"com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper", (String)"135", null, (Object[])new Object[]{jarEntry, jarContainer, containers, resolved, addRoot});
                throw new UnableToAdaptException((Throwable)e);
            }
        }
    }

    public static void addCompleteJarEntryUrls(List<ContainerInfo> containers, Entry jarEntry, Container jarContainer, Collection<String> resolved) throws UnableToAdaptException {
        String entryIdentity = ManifestClassPathUtils.createEntryIdentity(jarEntry);
        if (!entryIdentity.isEmpty() && !resolved.contains(entryIdentity)) {
            resolved.add(entryIdentity);
            ManifestClassPathHelper.processMFClasspath(jarEntry, jarContainer, containers, resolved, false);
        }
    }

    private static Entry findClassPathEntry(Entry jarEntry, URI pathUri) throws URISyntaxException, UnableToAdaptException {
        URI relativeJarUri = new URI("/").relativize(new URI(jarEntry.getPath()));
        URI targetUri = null;
        targetUri = relativeJarUri.resolve(pathUri);
        if (targetUri.toString().startsWith("..")) {
            Entry rootEntry = (Entry)jarEntry.getRoot().adapt(Entry.class);
            if (rootEntry == null || rootEntry.getPath().isEmpty()) {
                return null;
            }
            return ManifestClassPathHelper.findClassPathEntry(rootEntry, new URI("..").relativize(targetUri));
        }
        return jarEntry.getRoot().getEntry(targetUri.toString());
    }
}

