/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.reader.tasks;

import com.ibm.ws.security.audit.reader.AuditUtilityReturnCodes;
import com.ibm.ws.security.audit.reader.tasks.AuditLogReader;
import com.ibm.ws.security.audit.reader.tasks.BaseCommandTask;
import com.ibm.ws.security.audit.reader.utils.ConsoleWrapper;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuditReaderTask
extends BaseCommandTask {
    private static Logger theLogger = Logger.getLogger(AuditReaderTask.class.getName());
    private static final String ARG_AUDIT_FILE_LOCATION = "--auditFileLocation";
    private static final String ARG_OUTPUT_FILE_LOCATION = "--outputFileLocation";
    private static final String ARG_ENCRYPTED = "--encrypted";
    private static final String ARG_SIGNED = "--signed";
    private static final String ARG_ENCRYPTION_KEYSTORE_PASSWORD = "--encKeyStorePassword";
    private static final String ARG_SIGNING_KEYSTORE_PASSWORD = "--signingKeyStorePassword";
    private static final String ARG_ENCRYPTION_KEYSTORE_LOCATION = "--encKeyStoreLocation";
    private static final String ARG_SIGNING_KEYSTORE_LOCATION = "--signingKeyStoreLocation";
    private static final String ARG_ENCRYPTION_KEYSTORE_TYPE = "--encKeyStoreType";
    private static final String ARG_SIGNING_KEYSTORE_TYPE = "--signingKeyStoreType";
    private static final String DEBUG = "--debug";
    private static final List<String> ARG_TABLE = Arrays.asList("--auditFileLocation", "--outputFileLocation", "--encrypted", "--encKeyStoreLocation", "--encKeyStorePassword", "--encKeyStoreType", "--signed", "--signingKeyStoreLocation", "--signingKeyStorePassword", "--signingKeyStoreType", "--debug");
    private boolean isDebug = false;

    public AuditReaderTask(String scriptName) {
        super(scriptName);
    }

    @Override
    public String getTaskName() {
        return "auditReader";
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("auditreader.option-key.", "auditreader.option-desc.") + NL;
        String auditFileLocation = "";
        String outputLocation = "";
        String encPassword = "";
        String signingPassword = "";
        String encrypted = "";
        String signed = "";
        String encKeyStoreType = "";
        String signingKeyStoreType = "";
        String encKeyStoreLocation = "";
        String signingKeyStoreLocation = "";
        return this.getTaskHelp("auditreader.desc", "auditreader.usage.options", null, null, null, null, null, footer, this.scriptName, auditFileLocation, outputLocation, encrypted, encKeyStoreLocation, encPassword, encKeyStoreType, signed, signingKeyStoreLocation, signingPassword, signingKeyStoreType);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("auditreader.desc", true, new Object[0]);
    }

    private String auditReader(PrintStream stderr, Map<String, String> props) throws Exception {
        return AuditLogReader.getReport(props.get("auditFileLocation"), props.get("outputFileLocation"), props.get("encrypted"), props.get("encKeyStoreLocation"), props.get("encKeyStorePassword"), props.get("encKeyStoreType"), props.get("signed"), props.get("signingKeyStoreLocation"), props.get("signingKeyStorePassword"), props.get("signingKeyStoreType"), this.isDebug);
    }

    @Override
    public AuditUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        String loc;
        String afl;
        File f;
        Map<String, String> argMap = this.parseArgumentList(args);
        Map<String, String> props = this.convertToProperties(argMap);
        if (props.isEmpty()) {
            throw new IllegalArgumentException(this.getMessage("insufficientArgs", new Object[0]));
        }
        if (this.isDebug) {
            Handler[] handlers = Logger.getLogger("").getHandlers();
            for (int index = 0; index < handlers.length; ++index) {
                handlers[index].setLevel(Level.FINE);
            }
            theLogger.setLevel(Level.FINE);
        }
        if (this.isDebug) {
            theLogger.fine("Arguments passed in: " + argMap.toString());
        }
        if (argMap.containsKey(ARG_ENCRYPTED) && !argMap.get(ARG_ENCRYPTED).equalsIgnoreCase("true") && !argMap.get(ARG_ENCRYPTED).equalsIgnoreCase("false")) {
            if (this.isDebug) {
                theLogger.fine("Invalid value, " + argMap.get(ARG_ENCRYPTED) + ", specified for the --encrypted argument.   Value must be either true or false.");
            }
            throw new IllegalArgumentException(this.getMessage("invalidValue", argMap.get(ARG_ENCRYPTED), ARG_ENCRYPTED));
        }
        if (argMap.containsKey(ARG_SIGNED) && !argMap.get(ARG_SIGNED).equalsIgnoreCase("true") && !argMap.get(ARG_SIGNED).equalsIgnoreCase("false")) {
            if (this.isDebug) {
                theLogger.fine("Invalid value, " + argMap.get(ARG_SIGNED) + ", specified for the --signed argument.   Value must be either true or false.");
            }
            throw new IllegalArgumentException(this.getMessage("invalidValue", argMap.get(ARG_SIGNED), ARG_SIGNED));
        }
        if (argMap.containsKey(ARG_ENCRYPTED) && argMap.get(ARG_ENCRYPTED).equalsIgnoreCase("true") && argMap.containsKey(ARG_ENCRYPTION_KEYSTORE_TYPE) && (argMap.get(ARG_ENCRYPTION_KEYSTORE_TYPE).equalsIgnoreCase("PKCS11") || argMap.get(ARG_ENCRYPTION_KEYSTORE_TYPE).equals("CMS"))) {
            if (this.isDebug) {
                theLogger.fine("The keystore type, " + argMap.get(ARG_ENCRYPTION_KEYSTORE_TYPE) + ", specified for --encKeyStoreType is not supported. Only JKS, JCEKS and PKCS12 are supported.");
            }
            throw new IllegalArgumentException(this.getMessage("security.audit.UnsupportedKeyStoreType", argMap.get(ARG_ENCRYPTION_KEYSTORE_TYPE), ARG_ENCRYPTION_KEYSTORE_TYPE));
        }
        if (argMap.containsKey(ARG_SIGNED) && argMap.get(ARG_SIGNED).equalsIgnoreCase("true") && argMap.containsKey(ARG_SIGNING_KEYSTORE_TYPE) && (argMap.get(ARG_SIGNING_KEYSTORE_TYPE).equalsIgnoreCase("PKCS11") || argMap.get(ARG_SIGNING_KEYSTORE_TYPE).equals("CMS"))) {
            if (this.isDebug) {
                theLogger.fine("The keystore type, " + argMap.get(ARG_SIGNING_KEYSTORE_TYPE) + ", specified for --signingKeyStoreType is not supported. Only JKS, JCEKS and PKCS12 are supported.");
            }
            throw new IllegalArgumentException(this.getMessage("security.audit.UnsupportedKeyStoreType", argMap.get(ARG_SIGNING_KEYSTORE_TYPE), ARG_SIGNING_KEYSTORE_TYPE));
        }
        if (!argMap.containsKey(ARG_AUDIT_FILE_LOCATION)) {
            if (this.isDebug) {
                theLogger.fine("Missing --auditFileLocation argument");
            }
            throw new IllegalArgumentException(this.getMessage("missingArg", ARG_AUDIT_FILE_LOCATION));
        }
        if (argMap.containsKey(ARG_AUDIT_FILE_LOCATION) && !(f = new File(afl = argMap.get(ARG_AUDIT_FILE_LOCATION))).exists()) {
            if (this.isDebug) {
                theLogger.fine("Specified location for the audit log does not exist");
            }
            throw new IllegalArgumentException(this.getMessage("security.audit.FileNotFound", afl));
        }
        if (!argMap.containsKey(ARG_OUTPUT_FILE_LOCATION)) {
            if (this.isDebug) {
                theLogger.fine("Missing --outputFileLocation argument");
            }
            throw new IllegalArgumentException(this.getMessage("missingArg", ARG_OUTPUT_FILE_LOCATION));
        }
        if (argMap.get(ARG_AUDIT_FILE_LOCATION).equals(argMap.get(ARG_OUTPUT_FILE_LOCATION))) {
            if (this.isDebug) {
                theLogger.fine("The input audit file location, " + argMap.get(ARG_AUDIT_FILE_LOCATION) + ", cannot be the same as the output audit file location, " + argMap.get(ARG_OUTPUT_FILE_LOCATION) + ".");
            }
            throw new IllegalArgumentException(this.getMessage("invalidFileLocations", argMap.get(ARG_AUDIT_FILE_LOCATION), argMap.get(ARG_OUTPUT_FILE_LOCATION)));
        }
        if (argMap.containsKey(ARG_OUTPUT_FILE_LOCATION)) {
            afl = argMap.get(ARG_OUTPUT_FILE_LOCATION);
            f = new File(afl);
            if (f.isDirectory()) {
                if (this.isDebug) {
                    theLogger.fine("Specified location for the output audit log does not exist.  It is specified but is a directory.");
                }
                throw new IllegalArgumentException(this.getMessage("security.audit.FileNotFound", afl));
            }
            if (this.isDebug) {
                theLogger.fine("Specified location for the output audit log exists and is not a directory.");
            }
            if (afl.endsWith("/") || afl.endsWith("\\")) {
                if (this.isDebug) {
                    theLogger.fine("Specified location for the output audit log does not exist.  It is specified but is a non existant directory.");
                }
                throw new IllegalArgumentException(this.getMessage("security.audit.FileNotFound", afl));
            }
            if (f.createNewFile() && !f.canWrite()) {
                if (this.isDebug) {
                    theLogger.fine("Specified location for the output audit log is a non-writable file.  Ensure that the location for the output file is writable");
                }
                throw new IllegalArgumentException(this.getMessage("audit.NonWriteableOuputFile", afl));
            }
            boolean fd = false;
            if (f.exists() && f.canWrite()) {
                fd = f.delete();
            }
        }
        if (argMap.containsKey(ARG_ENCRYPTED) && argMap.get(ARG_ENCRYPTED).equalsIgnoreCase("true") && !argMap.containsKey(ARG_ENCRYPTION_KEYSTORE_PASSWORD)) {
            if (this.isDebug) {
                theLogger.fine("The --encrypted argument is true, but nothing was specified for --encKeyStorePassword.");
            }
            throw new IllegalArgumentException(this.getMessage("missingArg", ARG_ENCRYPTION_KEYSTORE_PASSWORD));
        }
        if (argMap.containsKey(ARG_ENCRYPTED) && argMap.get(ARG_ENCRYPTED).equalsIgnoreCase("true") && !argMap.containsKey(ARG_ENCRYPTION_KEYSTORE_TYPE)) {
            if (this.isDebug) {
                theLogger.fine("The --encrypted argument is true, but nothing was specified for --encKeyStoreType.");
            }
            throw new IllegalArgumentException(this.getMessage("missingArg", ARG_ENCRYPTION_KEYSTORE_TYPE));
        }
        if (argMap.containsKey(ARG_ENCRYPTED) && argMap.get(ARG_ENCRYPTED).equalsIgnoreCase("true") && argMap.containsKey(ARG_ENCRYPTION_KEYSTORE_LOCATION)) {
            loc = argMap.get(ARG_ENCRYPTION_KEYSTORE_LOCATION);
            f = new File(loc);
            if (!f.exists()) {
                if (this.isDebug) {
                    theLogger.fine("Specified location for the encryption keystore does not exist");
                }
                throw new IllegalArgumentException(this.getMessage("security.audit.FileNotFound", loc));
            }
            if (loc.endsWith(".CMS") || loc.endsWith(".cms") || loc.endsWith(".pkce11") || loc.endsWith(".PKCE11")) {
                if (this.isDebug) {
                    theLogger.fine("The keystore type, " + argMap.get(ARG_ENCRYPTION_KEYSTORE_TYPE) + ", specified for --encKeyStoreType is not supported. Only JKS, JCEKS and PKCS12 are supported.");
                }
                throw new IllegalArgumentException(this.getMessage("security.audit.UnsupportedKeyStoreType", argMap.get(ARG_ENCRYPTION_KEYSTORE_TYPE), ARG_ENCRYPTION_KEYSTORE_TYPE));
            }
        }
        if (argMap.containsKey(ARG_SIGNED) && argMap.get(ARG_SIGNED).equalsIgnoreCase("true") && !argMap.containsKey(ARG_SIGNING_KEYSTORE_PASSWORD)) {
            if (this.isDebug) {
                theLogger.fine("The --signed argument is true, but nothing was specified for --signingKeyStorePassword.");
            }
            throw new IllegalArgumentException(this.getMessage("missingArg", ARG_SIGNING_KEYSTORE_PASSWORD));
        }
        if (argMap.containsKey(ARG_SIGNED) && argMap.get(ARG_SIGNED).equalsIgnoreCase("true") && !argMap.containsKey(ARG_SIGNING_KEYSTORE_TYPE)) {
            if (this.isDebug) {
                theLogger.fine("The --signed argument is true, but nothing was specified for --signingKeyStoreType.");
            }
            throw new IllegalArgumentException(this.getMessage("missingArg", ARG_SIGNING_KEYSTORE_TYPE));
        }
        if (argMap.containsKey(ARG_SIGNED) && argMap.get(ARG_SIGNED).equalsIgnoreCase("true") && argMap.containsKey(ARG_SIGNING_KEYSTORE_LOCATION)) {
            loc = argMap.get(ARG_SIGNING_KEYSTORE_LOCATION);
            f = new File(loc);
            if (!f.exists()) {
                if (this.isDebug) {
                    theLogger.fine("Specified location for the signing keystore does not exist");
                }
                throw new IllegalArgumentException(this.getMessage("security.audit.FileNotFound", loc));
            }
            if (loc.endsWith(".CMS") || loc.endsWith(".cms") || loc.endsWith(".pkce11") || loc.endsWith(".PKCE11")) {
                if (this.isDebug) {
                    theLogger.fine("The keystore type, " + argMap.get(ARG_SIGNING_KEYSTORE_TYPE) + ", specified for --signingKeyStoreType is not supported. Only JKS, JCEKS and PKCS12 are supported.");
                }
                throw new IllegalArgumentException(this.getMessage("security.audit.UnsupportedKeyStoreType", argMap.get(ARG_SIGNING_KEYSTORE_TYPE), ARG_SIGNING_KEYSTORE_TYPE));
            }
        }
        if ((argMap.containsKey(ARG_ENCRYPTION_KEYSTORE_PASSWORD) || argMap.containsKey(ARG_ENCRYPTION_KEYSTORE_TYPE) || argMap.containsKey(ARG_ENCRYPTION_KEYSTORE_LOCATION)) && !argMap.containsKey(ARG_ENCRYPTED)) {
            if (this.isDebug) {
                theLogger.fine("The --encKeyStoreLocation, --encKeyStoreType, and --encKeyStorePassword were specified, but nothing was specified for the --encrypted argument.");
            }
            throw new IllegalArgumentException(this.getMessage("missingArg", ARG_ENCRYPTED));
        }
        if ((argMap.containsKey(ARG_SIGNING_KEYSTORE_PASSWORD) || argMap.containsKey(ARG_SIGNING_KEYSTORE_TYPE) || argMap.containsKey(ARG_SIGNING_KEYSTORE_LOCATION)) && !argMap.containsKey(ARG_SIGNED)) {
            if (this.isDebug) {
                theLogger.fine("The --signingKeyStoreLocation, --signingKeyStoreType, and --signingKeyStorePassword were specified, but nothing was specified for the --signed argument.");
            }
            throw new IllegalArgumentException(this.getMessage("missingArg", ARG_SIGNED));
        }
        this.auditReader(stderr, props);
        return AuditUtilityReturnCodes.OK;
    }

    private Map<String, String> parseArgumentList(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        String arg = null;
        for (int i = 1; i < args.length; ++i) {
            String value;
            arg = args[i];
            if (arg.startsWith("--")) {
                int index = arg.indexOf(61);
                if (index == -1) {
                    if (!this.isKnownArgument(arg)) {
                        throw new IllegalArgumentException(this.getMessage("invalidArg", arg));
                    }
                    throw new IllegalArgumentException(this.getMessage("missingValue", arg));
                }
                value = null;
                if (index + 1 < arg.length()) {
                    value = arg.substring(index + 1);
                }
                if (!this.isKnownArgument(arg = arg.substring(0, index))) {
                    throw new IllegalArgumentException(this.getMessage("invalidArg", arg));
                }
                if (value == null) {
                    throw new IllegalArgumentException(this.getMessage("missingValue", arg));
                }
            } else {
                throw new IllegalArgumentException(this.getMessage("invalidArg", arg));
            }
            result.put(arg, value);
        }
        return result;
    }

    @Override
    boolean isKnownArgument(String arg) {
        boolean value = false;
        if (arg != null) {
            value = ARG_TABLE.contains(arg);
        }
        return value;
    }

    @Override
    void checkRequiredArguments(String[] args) {
    }

    protected Map<String, String> convertToProperties(Map<String, String> argMap) {
        HashMap<String, String> props = new HashMap<String, String>();
        String value = argMap.get(ARG_AUDIT_FILE_LOCATION);
        if (value != null) {
            props.put("auditFileLocation", value);
        }
        if ((value = argMap.get(ARG_OUTPUT_FILE_LOCATION)) != null) {
            props.put("outputFileLocation", value);
        }
        if ((value = argMap.get(ARG_ENCRYPTED)) != null) {
            props.put("encrypted", value);
        }
        if ((value = argMap.get(ARG_SIGNED)) != null) {
            props.put("signed", value);
        }
        if ((value = argMap.get(ARG_ENCRYPTION_KEYSTORE_LOCATION)) != null) {
            props.put("encKeyStoreLocation", value);
        }
        if ((value = argMap.get(ARG_ENCRYPTION_KEYSTORE_PASSWORD)) != null) {
            props.put("encKeyStorePassword", value);
        }
        if ((value = argMap.get(ARG_SIGNING_KEYSTORE_LOCATION)) != null) {
            props.put("signingKeyStoreLocation", value);
        }
        if ((value = argMap.get(ARG_SIGNING_KEYSTORE_PASSWORD)) != null) {
            props.put("signingKeyStorePassword", value);
        }
        if ((value = argMap.get(ARG_ENCRYPTION_KEYSTORE_TYPE)) != null) {
            props.put("encKeyStoreType", value);
        }
        if ((value = argMap.get(ARG_SIGNING_KEYSTORE_TYPE)) != null) {
            props.put("signingKeyStoreType", value);
        }
        if ((value = argMap.get(DEBUG)) != null) {
            props.put("debug", value);
            this.isDebug = value.equals("true");
        } else {
            props.put("debug", "false");
            this.isDebug = false;
        }
        return props;
    }
}

