/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.java2sec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class FilePathUtil {
    private static BitSet encodingRequired;
    static final long serialVersionUID = 9018156443896037106L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    static String encodeFilePath(String s) {
        int strLen = 0;
        if (s == null || (strLen = s.length()) == 0) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.length() + 32);
        for (int i = 0; i < strLen; ++i) {
            char c = s.charAt(i);
            if (c == File.separatorChar) {
                buf.append('/');
                continue;
            }
            if (c < '\u0080') {
                if (encodingRequired.get(c)) {
                    FilePathUtil.escape(buf, c);
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c > '\u07ff') {
                FilePathUtil.escape(buf, (char)(0xE0 | c >> 12 & 0xF));
                FilePathUtil.escape(buf, (char)(0x80 | c >> 6 & 0x3F));
                FilePathUtil.escape(buf, (char)(0x80 | c & 0x3F));
                continue;
            }
            FilePathUtil.escape(buf, (char)(0xC0 | c >> 6 & 0x1F));
            FilePathUtil.escape(buf, (char)(0x80 | c & 0x3F));
        }
        return buf.toString();
    }

    static String decodeFilePath(String s) throws DecodeException {
        int strLen = 0;
        if (s == null || (strLen = s.length()) == 0) {
            return s;
        }
        StringBuffer buf = new StringBuffer(strLen + 32);
        int i = 0;
        block4: while (i < strLen) {
            char c = s.charAt(i);
            if (c != '%') {
                ++i;
                buf.append(c);
                continue;
            }
            c = FilePathUtil.unescpae(s.charAt(i + 1), s.charAt(i + 2));
            i += 3;
            if ((c & 0x80) != 0) {
                switch (c >> 4) {
                    case 12: 
                    case 13: {
                        char c1 = s.charAt(i);
                        if (c1 != '%') {
                            throw new DecodeException("Expect '%', but found '" + c1 + "'");
                        }
                        c1 = FilePathUtil.unescpae(s.charAt(i + 1), s.charAt(i + 2));
                        i += 3;
                        buf.append((char)((c & 0x1F) << 6 | c1 & 0x3F));
                        continue block4;
                    }
                    case 14: {
                        char c1 = s.charAt(i);
                        if (c1 != '%') {
                            throw new DecodeException("Expect '%', but found '" + c1 + "'");
                        }
                        c1 = FilePathUtil.unescpae(s.charAt(i + 1), s.charAt(i + 2));
                        char c2 = s.charAt(i += 3);
                        if (c2 != '%') {
                            throw new DecodeException("Expect '%', but found '" + c1 + "'");
                        }
                        c2 = FilePathUtil.unescpae(s.charAt(i + 1), s.charAt(i + 2));
                        i += 3;
                        buf.append((char)((c & 0xF) << 12 | (c1 & 0x3F) << 6 | c2 & 0x3F));
                        continue block4;
                    }
                }
                throw new DecodeException("Unknown encoding sequence \"" + new String(new char[]{'%', s.charAt(i + 1), s.charAt(i + 2)}) + "\"");
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static URL filePathToURL(File f) throws MalformedURLException {
        String s = FilePathUtil.encodeFilePath(f.getAbsolutePath());
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        if (!s.endsWith("/") && f.isDirectory()) {
            s = s + "/";
        }
        return new URL("file", "", s);
    }

    static URL filePathToURL(File f, String dirChar) throws MalformedURLException {
        String s = FilePathUtil.encodeFilePath(f.getAbsolutePath());
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        if (!s.endsWith("/") && f.isDirectory()) {
            s = s + "/";
        }
        if (f.isDirectory()) {
            s = s + dirChar;
        }
        return new URL("file", "", s);
    }

    private static void escape(StringBuffer buf, char c) {
        buf.append('%');
        buf.append(Character.forDigit(c >> 4 & 0xF, 16));
        buf.append(Character.forDigit(c & 0xF, 16));
    }

    private static char unescpae(char c1, char c2) throws DecodeException {
        int i1 = Character.digit(c1, 16);
        int i2 = Character.digit(c2, 16);
        if (i1 == -1 || i2 == -1) {
            throw new DecodeException("Can not unescape \"" + new String(new char[]{'%', c1, c2}) + "\"");
        }
        return (char)(i1 << 4 | i2);
    }

    private FilePathUtil() {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.java2sec.FilePathUtil", FilePathUtil.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
        encodingRequired = new BitSet(256);
        encodingRequired.set(61);
        encodingRequired.set(59);
        encodingRequired.set(63);
        encodingRequired.set(47);
        encodingRequired.set(35);
        encodingRequired.set(32);
        encodingRequired.set(60);
        encodingRequired.set(62);
        encodingRequired.set(37);
        encodingRequired.set(34);
        encodingRequired.set(123);
        encodingRequired.set(125);
        encodingRequired.set(124);
        encodingRequired.set(39);
        encodingRequired.set(94);
        encodingRequired.set(91);
        encodingRequired.set(93);
        encodingRequired.set(96);
        encodingRequired.set(127);
        for (int i = 0; i < 32; ++i) {
            encodingRequired.set(i);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class DecodeException
    extends Exception {
        private static final long serialVersionUID = 8237803124662929625L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DecodeException(String msg) {
            super(msg);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.java2sec.FilePathUtil$DecodeException", DecodeException.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
        }
    }
}

