/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.NoClassNotFoundLoader;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ParentLastClassLoader
extends AppClassLoader {
    static final List<AppClassLoader.SearchLocation> PARENT_LAST_SEARCH_ORDER;
    static final long serialVersionUID = -8661346590548013548L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ParentLastClassLoader(ClassLoader parent, ClassLoaderConfiguration config, List<Container> urls, DeclaredApiAccess access, ClassRedefiner redefiner, ClassGenerator generator, GlobalClassloadingConfiguration globalConfig, List<ClassFileTransformer> systemTransformers) {
        super(parent, config, urls, access, redefiner, generator, globalConfig, systemTransformers);
    }

    @Override
    Iterable<AppClassLoader.SearchLocation> getSearchOrder() {
        return PARENT_LAST_SEARCH_ORDER;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    @Trivial
    public URL getResource(String resName) {
        URL result = this.findResource(resName);
        return result == null ? this.parent.getResource(resName) : result;
    }

    @Override
    @Trivial
    public Enumeration<URL> getResources(String resName) throws IOException {
        return super.findResources(resName).add(this.parent.getResources(resName));
    }

    @Override
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findOrDelegateLoadClass(String className, boolean onlySearchSelf, boolean returnNull) throws ClassNotFoundException {
        ClassNotFoundException findClassException = null;
        Class<?> rc = this.findLoadedClass(className);
        if (rc != null) {
            return rc;
        }
        try {
            rc = this.findClass(className, returnNull);
            if (rc != null) {
                return rc;
            }
        }
        catch (ClassNotFoundException cnfe) {
            findClassException = cnfe;
        }
        Class<?> generatedClass = this.generateClass(className);
        if (generatedClass != null) {
            return generatedClass;
        }
        if (onlySearchSelf) {
            if (returnNull) {
                return null;
            }
            throw findClassException;
        }
        if (this.parent instanceof NoClassNotFoundLoader) {
            rc = ((NoClassNotFoundLoader)((Object)this.parent)).loadClassNoException(className);
            if (rc != null || returnNull) {
                return rc;
            }
            throw findClassException;
        }
        if (returnNull) {
            try {
                return this.parent.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return this.parent.loadClass(className);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ParentLastClassLoader", ParentLastClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        ClassLoader.registerAsParallelCapable();
        PARENT_LAST_SEARCH_ORDER = Util.freeze(Util.list(AppClassLoader.SearchLocation.SELF, AppClassLoader.SearchLocation.DELEGATES, AppClassLoader.SearchLocation.PARENT));
    }
}

