/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.PFX;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class genPFX {
    public static void main(String[] argv) {
        String certFile = null;
        String keyFile = null;
        String shroudedKeyFile = null;
        String outfile = null;
        String alg = null;
        String friendlyName = null;
        char[] passwd = null;
        try {
            PKCSDerObject key;
            byte[] encoding;
            for (int i2 = 0; i2 < argv.length; ++i2) {
                String arg = argv[i2];
                if (arg.equals("-c")) {
                    if (certFile != null) {
                        System.out.println("ERROR: Certificate has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    certFile = argv[++i2];
                    continue;
                }
                if (arg.equals("-s")) {
                    if (keyFile != null || shroudedKeyFile != null) {
                        System.out.println("ERROR: Key has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    shroudedKeyFile = argv[++i2];
                    continue;
                }
                if (arg.equals("-k")) {
                    if (keyFile != null || shroudedKeyFile != null) {
                        System.out.println("ERROR: Key has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    keyFile = argv[++i2];
                    continue;
                }
                if (arg.equals("-p")) {
                    if (alg != null) {
                        System.out.println("ERROR: Algorithm has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    alg = argv[++i2];
                    continue;
                }
                if (arg.equals("-m")) {
                    if (passwd != null) {
                        System.out.println("ERROR: Password has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    passwd = argv[++i2].toCharArray();
                    continue;
                }
                if (arg.equals("-f")) {
                    if (friendlyName != null) {
                        System.out.println("ERROR: Friendly name has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    friendlyName = argv[++i2];
                    continue;
                }
                if (!arg.equals("-o")) continue;
                if (outfile != null) {
                    System.out.println("ERROR: Output file has already been specified.");
                    genPFX.usage();
                    System.exit(1);
                }
                outfile = argv[++i2] + ".p12";
            }
            if (passwd == null) {
                System.out.println("ERROR: Password must be specified.");
                genPFX.usage();
                System.exit(1);
            }
            if (certFile == null) {
                System.out.println("ERROR: Certificate must be specified.");
                genPFX.usage();
                System.exit(1);
            }
            if (friendlyName == null) {
                System.out.println("ERROR: Friendly name must be specified.");
                genPFX.usage();
                System.exit(1);
            }
            if (outfile == null) {
                System.out.println("ERROR: Output file must be specified.");
                genPFX.usage();
                System.exit(1);
            }
            if (alg == null) {
                alg = "40BitRC2";
            }
            System.out.println("Creating PFX from input files.");
            System.out.println("Using friendly name " + friendlyName);
            PFX pfx = new PFX();
            System.out.println("Processing certificate from " + certFile);
            FileInputStream fis = new FileInputStream(certFile);
            X509CertImpl cert = new X509CertImpl(fis);
            byte[] inputBytes = ((Certificate)cert).getPublicKey().getEncoded();
            fis.read(inputBytes);
            fis.close();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(inputBytes);
            byte[] keyId = md.digest();
            pfx.addCertificate(cert, friendlyName, keyId);
            HexDumpEncoder hd = new HexDumpEncoder();
            System.out.println("key id:");
            System.out.println(hd.encodeBuffer(keyId));
            if (keyFile != null) {
                System.out.println("Processing private key from " + keyFile);
                fis = new FileInputStream(keyFile);
                encoding = new byte[fis.available()];
                fis.read(encoding);
                key = new PrivateKeyInfo(encoding);
                pfx.addPrivateKey((PrivateKey)((Object)key), friendlyName, keyId);
                fis.close();
            }
            if (shroudedKeyFile != null) {
                System.out.println("Processing shrouded key from " + shroudedKeyFile);
                fis = new FileInputStream(shroudedKeyFile);
                encoding = new byte[fis.available()];
                fis.read(encoding);
                key = new EncryptedPrivateKeyInfo(encoding);
                pfx.addShroudedKey((EncryptedPrivateKeyInfo)key, friendlyName, keyId);
                fis.close();
            }
            System.out.println("Protecting data with algorithm PBEWithSHAAnd" + alg);
            pfx.protect(alg, passwd);
            System.out.println("Writing PFX to file " + outfile);
            pfx.write(outfile, false);
        }
        catch (Exception e2) {
            System.out.println("ERROR: " + e2.toString());
            e2.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: genPFX -m mac_pwd -f friendly_name -c certfile");
        System.out.println("              [[-k keyfile] | [-s shrouded_keyfile]]");
        System.out.println("              [-p alg] -o outfile");
        System.out.println("       where mac_pwd is a password used for data integrity and privacy");
        System.out.println("             friendly_name is an alias attached to the personal data");
        System.out.println("             certfile contains an X.509 certificate");
        System.out.println("             keyfile or shrouded_keyfile contains a private key");
        System.out.println("                 - only one of them may be specified");
        System.out.println("             alg is the encryption algorithm for data protection");
        System.out.println("                 - the default is 40BitRC2");
        System.out.println("             outfile is the file the DER-encoded PFX will be written to");
        System.out.println("                 (with a .p12 extension)");
    }
}

