/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.PKIStatusInfo;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public final class CertStatus
extends CMPDerObject {
    private byte[] certHash;
    private BigInteger certReqId;
    private PKIStatusInfo statusInfo;

    public CertStatus(byte[] byArray) throws IOException {
        super(byArray);
    }

    public CertStatus(byte[] byArray, BigInteger bigInteger, PKIStatusInfo pKIStatusInfo) {
        this.certHash = (byte[])byArray.clone();
        this.certReqId = bigInteger;
        this.statusInfo = pKIStatusInfo;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CertStatus(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("CertStatus parsing error, not a SEQUENCE");
        }
        this.certHash = null;
        this.statusInfo = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("CertStatus parsing error, missing data");
        }
        this.certHash = derValue.getData().getOctetString();
        if (derValue.getData().available() == 0) {
            throw new IOException("CertStatus parsing error, missing data");
        }
        this.certReqId = derValue.getData().getInteger();
        if (derValue.getData().available() == 0) {
            return;
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.statusInfo = new PKIStatusInfo(derValue2.toByteArray());
        if (derValue.getData().available() != 0) {
            throw new IOException("CertStatus parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.certHash == null) {
            throw new IOException("CertStatus encoding error, cert hash not specified");
        }
        derOutputStream.putOctetString(this.certHash);
        derOutputStream.putInteger(this.certReqId);
        if (this.statusInfo != null) {
            this.statusInfo.encode(derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(CertStatus certStatus) {
        DerValue derValue;
        DerValue derValue2;
        if (certStatus == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certStatus.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertStatus) {
            return this.equals((CertStatus)object);
        }
        return false;
    }

    public byte[] getCertHash() {
        return (byte[])this.certHash.clone();
    }

    public BigInteger getCertReqId() {
        return this.certReqId;
    }

    public PKIStatusInfo getStatusInfo() throws IOException {
        if (this.statusInfo == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.statusInfo.encode(derOutputStream);
            return new PKIStatusInfo(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public String toString() {
        String string = "CertStatus:\r\n";
        string = String.valueOf(string) + "\r\n\tCert hash: " + new String(this.certHash);
        string = String.valueOf(string) + "\r\n\tCert Req Id: " + this.certReqId.toString();
        if (this.statusInfo != null) {
            string = String.valueOf(string) + "\r\n\tStatus info " + this.statusInfo.toString();
        }
        return string;
    }
}

