/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.ejbext;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.ejb.EJBJar;
import com.ibm.ws.javaee.dd.ejbext.EJBJarExt;
import com.ibm.ws.javaee.dd.ejbext.EnterpriseBean;
import com.ibm.ws.javaee.ddmodel.CrossComponentReferenceType;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.StringType;
import com.ibm.ws.javaee.ddmodel.ejbext.EnterpriseBeanType;
import com.ibm.ws.javaee.ddmodel.ejbext.MessageDrivenType;
import com.ibm.ws.javaee.ddmodel.ejbext.SessionType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBJarExtType
extends DDParser.ElementContentParsable
implements EJBJarExt,
DDParser.RootParsable {
    private static final TraceComponent tc = Tr.register(EJBJarExtType.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    private final String deploymentDescriptorPath;
    private DDParser.ComponentIDMap idMap;
    protected final boolean xmi;
    private CrossComponentReferenceType xmiRef;
    DDParser.ParsableListImplements<EnterpriseBeanType, EnterpriseBean> enterpriseBeans;
    StringType version;
    static final long serialVersionUID = 683112195583237805L;

    public EJBJarExtType(String ddPath) {
        this(ddPath, false);
    }

    public EJBJarExtType(String ddPath, boolean xmi) {
        this.xmi = xmi;
        this.deploymentDescriptorPath = ddPath;
    }

    public List<EnterpriseBean> getEnterpriseBeans() {
        if (this.enterpriseBeans != null) {
            return this.enterpriseBeans.getList();
        }
        return Collections.emptyList();
    }

    public String getVersion() {
        return this.xmi ? "XMI" : (this.version != null ? this.version.getValue() : null);
    }

    public String getDeploymentDescriptorPath() {
        return this.deploymentDescriptorPath;
    }

    public Object getComponentForId(String id) {
        return this.idMap.getComponentForId(id);
    }

    public String getIdForComponent(Object ddComponent) {
        return this.idMap.getIdForComponent(ddComponent);
    }

    @Override
    public void finish(DDParser parser) throws DDParser.ParseException {
        if (this.version == null) {
            this.version = parser.parseToken(parser.getDottedVersionText());
        }
        this.idMap = parser.idMap;
        HashMap<String, EnterpriseBean> beans = new HashMap<String, EnterpriseBean>(this.getEnterpriseBeans().size());
        for (EnterpriseBean bean : this.getEnterpriseBeans()) {
            EnterpriseBean existing = beans.put(bean.getName(), bean);
            if (existing == null) continue;
            throw new DDParser.ParseException(Tr.formatMessage((TraceComponent)tc, (String)"found.duplicate.ejbname", (Object[])new Object[]{parser.getDeploymentDescriptorPath(), existing.getName()}));
        }
    }

    @Override
    public boolean isIdAllowed() {
        return true;
    }

    @Override
    public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
        if (nsURI == null && !this.xmi && "version".equals(localName)) {
            this.version = parser.parseStringAttributeValue(index);
            return true;
        }
        return this.xmi && "http://www.omg.org/XMI".equals(nsURI) && "version".equals(localName);
    }

    @Override
    public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
        if (this.xmi && "ejbJar".equals(localName)) {
            this.xmiRef = new CrossComponentReferenceType("ejbJar", EJBJar.class);
            parser.parse(this.xmiRef);
            return true;
        }
        if (!this.xmi && "session".equals(localName)) {
            SessionType enterpriseBeans = new SessionType();
            parser.parse(enterpriseBeans);
            this.addEnterpriseBean(enterpriseBeans);
            return true;
        }
        if (!this.xmi && "message-driven".equals(localName)) {
            MessageDrivenType enterpriseBeans = new MessageDrivenType();
            parser.parse(enterpriseBeans);
            this.addEnterpriseBean(enterpriseBeans);
            return true;
        }
        if (this.xmi && "ejbExtensions".equals(localName)) {
            EnterpriseBeanType enterpriseBeans;
            String xmiType = parser.getAttributeValue("http://www.omg.org/XMI", "type");
            if (xmiType == null) {
                throw new DDParser.ParseException(parser.requiredAttributeMissing("xmi:type"));
            }
            if (xmiType.endsWith(":SessionExtension") && "ejbext.xmi".equals(parser.getNamespaceURI(xmiType.substring(0, xmiType.length() - ":SessionExtension".length())))) {
                enterpriseBeans = new SessionType(true);
            } else if (xmiType.endsWith(":MessageDrivenExtension") && "ejbext.xmi".equals(parser.getNamespaceURI(xmiType.substring(0, xmiType.length() - ":MessageDrivenExtension".length())))) {
                enterpriseBeans = new MessageDrivenType(true);
            } else {
                return false;
            }
            parser.parse(enterpriseBeans);
            this.addEnterpriseBean(enterpriseBeans);
            return true;
        }
        return false;
    }

    void addEnterpriseBean(EnterpriseBeanType enterpriseBeans) {
        if (this.enterpriseBeans == null) {
            this.enterpriseBeans = new DDParser.ParsableListImplements();
        }
        this.enterpriseBeans.add(enterpriseBeans);
    }

    @Override
    public void describe(DDParser.Diagnostics diag) {
        diag.describeIfSet("ejbJar", this.xmiRef);
        diag.describeIfSet("version", this.version);
        diag.describeIfSet(this.xmi ? "ejbExtensions" : "enterpriseBeans", this.enterpriseBeans);
    }

    @Override
    public void describe(StringBuilder sb) {
        DDParser.Diagnostics diag = new DDParser.Diagnostics(this.idMap, sb);
        diag.describe(this.toTracingSafeString(), this);
    }
}

