/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.util;

import com.ibm.ws.ejbcontainer.util.FieldClassValue;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class FieldClassValueFactory {
    private static FieldClassValueFactory factory = FieldClassValueFactory.createFactory();

    private static FieldClassValueFactory createFactory() {
        try {
            Class.forName("java.lang.ClassValue");
            return new Impl();
        }
        catch (ClassNotFoundException e) {
            return new ReflectionImpl();
        }
    }

    public static FieldClassValue create(String fieldName) {
        return factory.createImpl(fieldName);
    }

    static Field getDeclaredField(final Class<?> klass, final String fieldName) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Field field;
                try {
                    field = klass.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
                field.setAccessible(true);
                return field;
            }
        });
    }

    FieldClassValueFactory() {
    }

    abstract FieldClassValue createImpl(String var1);

    private static class Impl
    extends FieldClassValueFactory {
        private Impl() {
        }

        @Override
        FieldClassValue createImpl(String fieldName) {
            return new FieldClassValueImpl(fieldName);
        }

        private static class FieldClassValueImpl
        extends ClassValue<Field>
        implements FieldClassValue {
            private final String fieldName;

            FieldClassValueImpl(String fieldName) {
                this.fieldName = fieldName;
            }

            @Override
            protected Field computeValue(Class<?> klass) {
                return FieldClassValueFactory.getDeclaredField(klass, this.fieldName);
            }
        }
    }

    private static class ReflectionImpl
    extends FieldClassValueFactory {
        private ReflectionImpl() {
        }

        @Override
        FieldClassValue createImpl(String fieldName) {
            return new ReflectionFieldClassValueImpl(fieldName);
        }

        private static class ReflectionFieldClassValueImpl
        implements FieldClassValue {
            private final String fieldName;

            ReflectionFieldClassValueImpl(String fieldName) {
                this.fieldName = fieldName;
            }

            @Override
            public Field get(Class<?> klass) {
                return FieldClassValueFactory.getDeclaredField(klass, this.fieldName);
            }
        }
    }
}

