/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.opentracing.OpentracingTracerManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.library.LibraryChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"library=unbound"})
public class AppStateListener
implements ApplicationStateListener,
LibraryChangeListener {
    private static final String LIBRARY = "library";
    private volatile ConcurrentServiceReferenceSet<Library> librarySet = new ConcurrentServiceReferenceSet("library");
    static final long serialVersionUID = -2477070292299231650L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.librarySet.activate(context);
        for (ServiceReference ref : this.librarySet.references()) {
            this.registerLibraryListener(context.getBundleContext(), (String)ref.getProperty("id"));
        }
    }

    protected void deactivate(ComponentContext context) {
        this.librarySet.deactivate(context);
    }

    @Reference(service=Library.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setLibrary(ServiceReference<Library> ref) {
        this.librarySet.addReference(ref);
    }

    protected void unsetLibrary(ServiceReference<Library> ref) {
        this.librarySet.removeReference(ref);
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getName();
        OpentracingTracerManager.removeTracer(appName);
    }

    private void registerLibraryListener(BundleContext ctx, String id) {
        Hashtable<String, String> listenerProps = new Hashtable<String, String>(1);
        ((Dictionary)listenerProps).put(LIBRARY, id);
        ctx.registerService(LibraryChangeListener.class, (Object)this, listenerProps);
    }

    public void libraryNotification() {
        OpentracingTracerManager.clearTracers();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.opentracing.AppStateListener", AppStateListener.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
    }
}

