/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.Supplier;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.Iterables;
import org.jboss.weld.util.collections.Multimap;
import org.jboss.weld.util.collections.Multimaps;

abstract class AbstractMultimap<K, V, C extends Collection<V>>
implements Multimap<K, V>,
Serializable {
    private static final long serialVersionUID = -8363450390652782067L;
    protected final Supplier<C> supplier;
    private final Map<K, C> map;
    private final ConcurrentMap<K, C> concurrentMap;

    protected AbstractMultimap(Supplier<Map<K, C>> mapSupplier, Supplier<ConcurrentMap<K, C>> concurrentMapSupplier, Supplier<C> collectionSupplier, Multimap<K, V> multimap) {
        if (mapSupplier == null && concurrentMapSupplier == null || mapSupplier != null && concurrentMapSupplier != null) {
            throw new IllegalArgumentException("AbstractMultimap has to have only one map supplier provided");
        }
        Preconditions.checkArgumentNotNull(collectionSupplier, "collectionSupplier");
        this.supplier = collectionSupplier;
        this.concurrentMap = concurrentMapSupplier != null ? concurrentMapSupplier.get() : null;
        Map<K, C> map = this.map = mapSupplier != null ? mapSupplier.get() : null;
        if (multimap != null) {
            for (Map.Entry<K, Collection<V>> entry : multimap.entrySet()) {
                Collection values = (Collection)this.supplier.get();
                values.addAll(entry.getValue());
                this.putAll(entry.getKey(), values);
            }
        }
    }

    private Map<K, C> getMap() {
        return this.concurrentMap != null ? this.concurrentMap : this.map;
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public C get(K key) {
        Collection value;
        if (this.concurrentMap != null) {
            Collection previousValue;
            value = (Collection)this.concurrentMap.get(key);
            if (value == null && (value = (Collection)this.supplier.get()) != null && (previousValue = this.concurrentMap.putIfAbsent(key, value)) != null) {
                value = previousValue;
            }
        } else {
            Collection previousValue;
            value = (Collection)this.map.get(key);
            if (value == null && (value = (Collection)this.supplier.get()) != null && (previousValue = this.map.put(key, value)) != null) {
                value = previousValue;
            }
        }
        return (C)value;
    }

    @Override
    public boolean put(K key, V value) {
        return this.get(key).add(value);
    }

    @Override
    public boolean putAll(K key, Collection<? extends V> values) {
        return this.get(key).addAll(values);
    }

    public C replaceValues(K key, Iterable<? extends V> values) {
        Collection replacement = (Collection)this.supplier.get();
        Iterables.addAll(replacement, values);
        return (C)this.getMap().put(key, replacement);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return ImmutableSet.copyOf(this.getMap().keySet());
    }

    @Override
    public List<V> values() {
        return ImmutableList.copyOf(Iterables.concat(this.getMap().values()));
    }

    @Override
    public Set<V> uniqueValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Collection values : this.getMap().values()) {
            builder.addAll(values);
        }
        return builder.build();
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<K, C> entry : this.getMap().entrySet()) {
            builder.add(new MultimapEntry(entry.getKey(), Multimaps.unmodifiableValueCollection((Collection)entry.getValue())));
        }
        return builder.build();
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    public String toString() {
        return this.getMap().toString();
    }

    static class MultimapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public MultimapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.key, e.getKey()) && Objects.equals(this.value, e.getValue());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

