/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.FacesInitializerFactory;
import org.apache.myfaces.webapp.ManagedBeanDestroyerListener;
import org.apache.myfaces.webapp.StartupListener;

public class StartupServletContextListener
implements ServletContextListener,
HttpSessionAttributeListener,
HttpSessionListener,
ServletRequestListener,
ServletRequestAttributeListener,
ServletContextAttributeListener {
    static final String FACES_INIT_DONE = "org.apache.myfaces.webapp.StartupServletContextListener.FACES_INIT_DONE";
    static final String FACES_INIT_PLUGINS = "org.apache.myfaces.FACES_INIT_PLUGINS";
    private static final byte FACES_INIT_PHASE_PREINIT = 0;
    private static final byte FACES_INIT_PHASE_POSTINIT = 1;
    private static final byte FACES_INIT_PHASE_PREDESTROY = 2;
    private static final byte FACES_INIT_PHASE_POSTDESTROY = 3;
    private static final Logger log = Logger.getLogger(StartupServletContextListener.class.getName());
    private FacesInitializer _facesInitializer;
    private ServletContext _servletContext;
    private ManagedBeanDestroyerListener _detroyerListener = new ManagedBeanDestroyerListener();

    public void contextInitialized(ServletContextEvent event) {
        if (this._servletContext != null) {
            throw new IllegalStateException("context is already initialized");
        }
        this._servletContext = event.getServletContext();
        Boolean b = (Boolean)this._servletContext.getAttribute(FACES_INIT_DONE);
        if (b == null || !b.booleanValue()) {
            if (this._facesInitializer == null) {
                this._facesInitializer = FacesInitializerFactory.getFacesInitializer(this._servletContext);
            }
            FacesContext facesContext = this._facesInitializer.initStartupFacesContext(this._servletContext);
            this._publishManagedBeanDestroyerListener(facesContext);
            this.dispatchInitializationEvent(event, 0);
            this._facesInitializer.initFaces(this._servletContext);
            this.dispatchInitializationEvent(event, 1);
            this._servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
            this._detroyerListener.contextInitialized(event);
            this._facesInitializer.destroyStartupFacesContext(facesContext);
        } else {
            log.info("MyFaces already initialized");
        }
    }

    private void _publishManagedBeanDestroyerListener(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        applicationMap.put("org.apache.myfaces.ManagedBeanDestroyerListener", this._detroyerListener);
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this._facesInitializer != null && this._servletContext != null) {
            FacesContext facesContext = this._facesInitializer.initShutdownFacesContext(this._servletContext);
            this.dispatchInitializationEvent(event, 2);
            this._detroyerListener.contextDestroyed(event);
            this._facesInitializer.destroyFaces(this._servletContext);
            LifecycleProviderFactory.getLifecycleProviderFactory().release();
            if (facesContext != null) {
                this._facesInitializer.destroyShutdownFacesContext(facesContext);
            }
            FactoryFinder.releaseFactories();
            this.dispatchInitializationEvent(event, 3);
        }
        this._servletContext = null;
    }

    public void setFacesInitializer(FacesInitializer facesInitializer) {
        if (this._facesInitializer != null && this._facesInitializer != facesInitializer && this._servletContext != null) {
            this._facesInitializer.destroyFaces(this._servletContext);
        }
        this._facesInitializer = facesInitializer;
        if (this._servletContext != null) {
            facesInitializer.initFaces(this._servletContext);
        }
    }

    private boolean loadFacesInitPluginsJDK6() {
        Object pluginEntries = null;
        try {
            Class<?> serviceLoader = ClassUtils.getContextClassLoader().loadClass("java.util.ServiceLoader");
            Method m = serviceLoader.getDeclaredMethod("load", Class.class, ClassLoader.class);
            Object loader = m.invoke(serviceLoader, StartupListener.class, ClassUtils.getContextClassLoader());
            m = loader.getClass().getDeclaredMethod("iterator", new Class[0]);
            Iterator it = (Iterator)m.invoke(loader, new Object[0]);
            LinkedList<StartupListener> listeners = new LinkedList<StartupListener>();
            if (!it.hasNext()) {
                return false;
            }
            while (it.hasNext()) {
                listeners.add((StartupListener)it.next());
            }
            this._servletContext.setAttribute(FACES_INIT_PLUGINS, listeners);
            return true;
        }
        catch (ClassNotFoundException serviceLoader) {
        }
        catch (NoSuchMethodException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }

    private void loadFacesInitPluginsJDK5() {
        String plugins = this._servletContext.getInitParameter(FACES_INIT_PLUGINS);
        if (plugins == null) {
            return;
        }
        log.info("MyFaces Plugins found");
        String[] pluginEntries = plugins.split(",");
        ArrayList<StartupListener> listeners = new ArrayList<StartupListener>(pluginEntries.length);
        for (String pluginEntry : pluginEntries) {
            try {
                Class<?> pluginClass = null;
                pluginClass = ClassUtils.getContextClassLoader().loadClass(pluginEntry);
                if (pluginClass == null) {
                    pluginClass = this.getClass().getClassLoader().loadClass(pluginEntry);
                }
                listeners.add((StartupListener)pluginClass.newInstance());
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (InstantiationException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this._servletContext.setAttribute(FACES_INIT_PLUGINS, listeners);
    }

    private void dispatchInitializationEvent(ServletContextEvent event, int operation) {
        List pluginEntries;
        if (operation == 0 && !this.loadFacesInitPluginsJDK6()) {
            this.loadFacesInitPluginsJDK5();
        }
        if ((pluginEntries = (List)this._servletContext.getAttribute(FACES_INIT_PLUGINS)) == null) {
            return;
        }
        block5: for (StartupListener initializer : pluginEntries) {
            log.info("Processing plugin");
            switch (operation) {
                case 0: {
                    initializer.preInit(event);
                    continue block5;
                }
                case 1: {
                    initializer.postInit(event);
                    continue block5;
                }
                case 2: {
                    initializer.preDestroy(event);
                    continue block5;
                }
            }
            initializer.postDestroy(event);
        }
        log.info("Processing MyFaces plugins done");
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        this._detroyerListener.attributeAdded(event);
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this._detroyerListener.attributeRemoved(event);
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this._detroyerListener.attributeReplaced(event);
    }

    public void sessionCreated(HttpSessionEvent event) {
        this._detroyerListener.sessionCreated(event);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this._detroyerListener.sessionDestroyed(event);
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        this._detroyerListener.attributeAdded(event);
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        this._detroyerListener.attributeRemoved(event);
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        this._detroyerListener.attributeReplaced(event);
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
        this._detroyerListener.attributeAdded(event);
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        this._detroyerListener.attributeRemoved(event);
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        this._detroyerListener.attributeReplaced(event);
    }

    public void requestInitialized(ServletRequestEvent event) {
        this._detroyerListener.requestInitialized(event);
    }

    public void requestDestroyed(ServletRequestEvent event) {
        this._detroyerListener.requestDestroyed(event);
    }
}

