/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryException;
import com.ibm.ws.bluemix.utility.credentials.BluemixProperties;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import java.io.IOException;
import java.util.List;

public abstract class BaseLoginAction
extends BaseAction {
    protected ReturnCode setOrganization(BluemixClient client, String orgName) throws IOException, CloudFoundryException {
        if (orgName == null) {
            List<String> orgs = client.getOrganizations();
            if (orgs.isEmpty()) {
                this.stderr.println(NLS.getOption("login.organization.notfound", new Object[0]));
                return ReturnCode.CF_ERROR;
            }
            orgName = this.selectOption(orgs, "login.organization");
            if (orgName == null || orgName.trim().isEmpty()) {
                this.stdout.println(NLS.getOption("login.organization.notset", new Object[0]));
                return ReturnCode.USER_ABORT;
            }
        }
        client.setOrganization(orgName);
        this.stdout.println(NLS.getOption("login.organization.selected", orgName));
        BluemixProperties.save(client.getTargetInfo());
        return ReturnCode.OK;
    }

    protected ReturnCode setSpace(BluemixClient client, String spaceName) throws IOException, CloudFoundryException {
        if (spaceName == null) {
            List<String> spaces = client.getSpaces();
            if (spaces.isEmpty()) {
                String orgName = client.getTargetInfo().getOrganizationName();
                this.stderr.println(NLS.getOption("login.space.notfound", orgName));
                return ReturnCode.CF_ERROR;
            }
            spaceName = this.selectOption(spaces, "login.space");
            if (spaceName == null || spaceName.trim().isEmpty()) {
                this.stdout.println(NLS.getOption("login.space.notset", new Object[0]));
                return ReturnCode.USER_ABORT;
            }
        }
        client.setSpace(spaceName);
        this.stdout.println(NLS.getOption("login.space.selected", spaceName));
        BluemixProperties.save(client.getTargetInfo());
        return ReturnCode.OK;
    }

    private String selectOption(List<String> options, String baseKey) {
        if (options.size() == 1) {
            String selection = options.get(0);
            return selection;
        }
        this.stdout.println(NLS.getOption(baseKey + ".choice", new Object[0]));
        for (int i = 1; i <= options.size(); ++i) {
            this.stdout.println(i + " - " + options.get(i - 1));
        }
        String selection = this.stdin.readText(NLS.getOption(baseKey, new Object[0]));
        if (selection != null) {
            try {
                int selected = Integer.parseInt(selection);
                if (0 < selected && options.size() >= selected) {
                    selection = options.get(selected - 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return selection;
    }
}

