/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.annocache.classsource.ClassSource_ClassLoader;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_Streamer;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassSourceImpl_ClassLoader
extends ClassSourceImpl
implements ClassSource_ClassLoader {
    public static final String CLASS_NAME;
    protected volatile ClassLoader classLoader;
    protected final Future<ClassLoader> classLoaderThunk;
    static final long serialVersionUID = 4103688129337620201L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClassSourceImpl_ClassLoader(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, ClassLoader classLoader) {
        super(factory, internMap, NO_ENTRY_PREFIX, name, String.valueOf(classLoader));
        String methodName = "<init>";
        this.classLoader = classLoader;
        this.classLoaderThunk = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, this.hashText);
        }
    }

    public ClassSourceImpl_ClassLoader(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, Future<ClassLoader> classLoaderThunk) {
        super(factory, internMap, NO_ENTRY_PREFIX, name, String.valueOf(classLoaderThunk));
        String methodName = "<init>";
        this.classLoader = null;
        this.classLoaderThunk = classLoaderThunk;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, this.hashText);
        }
    }

    @Override
    protected String computeStamp() {
        return "** UNRECORDED **";
    }

    @Override
    @Trivial
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER/RETURN", this.getHashText());
        }
    }

    @Override
    @Trivial
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER/RETURN", this.getHashText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    public ClassLoader getClassLoader() {
        String methodName = "getClassLoader";
        if (this.classLoader == null) {
            ClassSourceImpl_ClassLoader classSourceImpl_ClassLoader = this;
            synchronized (classSourceImpl_ClassLoader) {
                if (this.classLoader == null) {
                    try {
                        this.classLoader = this.classLoaderThunk.get();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_ClassLoader", (String)"149", (Object)this, (Object[])new Object[0]);
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resolved [ {1} ]", new Object[]{this.getHashText(), this.classLoader});
                    }
                }
            }
        }
        return this.classLoader;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        String methodName = "openResourceStream";
        ClassLoader useClassLoader = this.getClassLoader();
        URL url = useClassLoader.getResource(resourceName);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_ClassLoader", (String)"179", (Object)this, (Object[])new Object[]{className, resourceName});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open resource [ " + resourceName + " ] for class [ " + className + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        String methodName = "closeResourceStream";
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_ClassLoader", (String)"201", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_CLOSE2_EXCEPTION", new Object[]{this.getHashText(), resourceName, className});
        }
    }

    @Override
    public void process(ClassSource_Streamer streamer) throws ClassSource_Exception {
        throw new UnsupportedOperationException("ClassLoader; no class streaming");
    }

    @Override
    public int processFromScratch(ClassSource_Streamer streamer) throws ClassSource_Exception {
        throw new UnsupportedOperationException("ClasLloader; no class streaming");
    }

    @Override
    protected boolean processUsingJandex(ClassSource_Streamer streamer) {
        throw new UnsupportedOperationException("ClassLoader; no class streaming");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    public void processSpecific(ClassSource_Streamer streamer, Set<String> i_classNames) throws ClassSource_Exception {
        String methodName = "processSpecific";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTRY [ {1} ]", new Object[]{this.getHashText(), i_classNames.size()});
        }
        long scanStart = System.nanoTime();
        for (String i_className : i_classNames) {
            String resourceName = this.getResourceNameFromClassName(i_className);
            try {
                this.scan(streamer, i_className, resourceName);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_ClassLoader", (String)"244", (Object)this, (Object[])new Object[]{streamer, i_classNames});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_SCAN_EXCEPTION", (Throwable)e);
            }
        }
        long scanTime = System.nanoTime() - scanStart;
        this.setProcessTime(scanTime);
        this.setProcessCount(i_classNames.size());
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void scan(ClassSource_Streamer streamer, String i_className, String resourceName) throws ClassSource_Exception {
        BufferedInputStream inputStream;
        String methodName = "scan";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Scan [ {1} ] as [ {2} ]", new Object[]{this.getHashText(), i_className, resourceName});
        }
        if ((inputStream = this.openClassResourceStream(i_className, resourceName)) == null) {
            return;
        }
        inputStream = new BufferedInputStream(inputStream, 8192);
        try {
            streamer.process(i_className, inputStream);
        }
        finally {
            this.closeResourceStream(i_className, resourceName, inputStream);
        }
    }

    @Override
    @Trivial
    public void log(Logger useLogger) {
        String methodName = "log";
        if (useLogger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Class Source [ {0} ]", this.getHashText());
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent tc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        }
    }

    @Override
    public void setParentSource(ClassSource classSource) {
    }

    @Override
    public void scanClasses(com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer, Set<String> i_seedClassNamesSet, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean scanSpecificSeedClass(String specificClassName, com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean scanReferencedClass(String referencedClassNam, com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String inconvertResourceName(String externalResourceName) {
        return null;
    }

    @Override
    public String outconvertResourceName(String internalResourceName) {
        return null;
    }

    @Override
    public InputStream openClassStream(String className) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        return null;
    }

    @Override
    public void closeClassStream(String className, InputStream inputStream) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
    }

    @Override
    public ClassSource_ScanCounts getScanResults() {
        return null;
    }

    @Override
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        return 0;
    }

    @Override
    public int getResourceExclusionCount() {
        return 0;
    }

    @Override
    public int getClassExclusionCount() {
        return 0;
    }

    @Override
    public int getClassInclusionCount() {
        return 0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_ClassLoader", ClassSourceImpl_ClassLoader.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = ClassSourceImpl_ClassLoader.class.getSimpleName();
    }
}

