/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateCreator;
import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.security.filemonitor.FileBasedActionable;
import com.ibm.ws.security.filemonitor.SecurityFileMonitor;
import com.ibm.ws.ssl.KeyringMonitor;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.internal.KeyringBasedActionable;
import com.ibm.ws.ssl.internal.KeyringMonitorImpl;
import com.ibm.ws.ssl.internal.KeystoreConfig;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.propertytypes.SatisfyingConditionTarget;

@Component(service={ManagedServiceFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.pid=com.ibm.ws.ssl.keystore"})
@SatisfyingConditionTarget(value="(osgi.condition.id=io.openliberty.process.running)")
public class KeystoreConfigurationFactory
implements ManagedServiceFactory,
FileBasedActionable,
KeyringBasedActionable {
    private static final TraceComponent tc = Tr.register(KeystoreConfigurationFactory.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private final AtomicServiceReference<WsLocationAdmin> locSvc = new AtomicServiceReference("LocMgr");
    private final ConcurrentHashMap<String, KeystoreConfig> keyConfigs = new ConcurrentHashMap();
    private ServiceRegistration<FileMonitor> keyStoreFileMonitorRegistration;
    private ServiceRegistration<KeyringMonitor> keyringMonitorRegistration;
    private SecurityFileMonitor keyStoreFileMonitor;
    private KeyringMonitorImpl KeyringMonitor;
    private BundleContext bContext = null;
    private volatile ComponentContext cc = null;

    @FFDCIgnore(value={IllegalArgumentException.class})
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (FrameworkState.isStopping()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("updated keystore " + pid), (Object[])new Object[]{properties});
        }
        String id = (String)properties.get("id");
        KeystoreConfig svc = null;
        KeystoreConfig old = this.keyConfigs.get(pid);
        if (old == null) {
            svc = new KeystoreConfig(pid, id, this.locSvc);
            old = this.keyConfigs.putIfAbsent(pid, svc);
        }
        if (old != null) {
            svc = old;
        }
        try {
            if (svc.updateKeystoreConfig(properties)) {
                svc.updateRegistration(this.bContext);
                String trigger = svc.getKeyStore().getTrigger();
                Boolean fileBased = svc.getKeyStore().getFileBased();
                if (!trigger.equalsIgnoreCase("disabled")) {
                    if (fileBased.booleanValue()) {
                        this.createFileMonitor(svc.getKeyStore().getName(), svc.getKeyStore().getLocation(), trigger, svc.getKeyStore().getPollingRate());
                    } else if (svc.getKeyStore().getLocation().startsWith("safkeyring")) {
                        this.createKeyringMonitor(svc.getKeyStore().getName(), trigger, svc.getKeyStore().getLocation());
                    }
                }
            } else {
                svc.unregister();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void deleted(String pid) {
        KeystoreConfig old = this.keyConfigs.get(pid);
        if (old != null) {
            KeyStoreManager.getInstance().clearKeyStoreFromMap(pid);
            KeyStoreManager.getInstance().clearKeyStoreFromMap(this.keyConfigs.get(pid).getId());
            old.unregister();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("deleted keystore " + pid), (Object[])new Object[0]);
            }
        }
    }

    public String getName() {
        return "Keystore configuration";
    }

    protected void activate(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{ctx.getProperties()});
        }
        this.cc = ctx;
        this.locSvc.activate(ctx);
        this.bContext = ctx.getBundleContext();
    }

    protected void deactivate(ComponentContext ctx, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("deactivate, reason=" + reason), (Object[])new Object[0]);
        }
        this.locSvc.deactivate(ctx);
        this.unsetFileMonitorRegistration();
        this.unsetKeyringMonitorRegistration();
    }

    @Reference(service=WsLocationAdmin.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLocMgr(ServiceReference<WsLocationAdmin> locSvc) {
        this.locSvc.setReference(locSvc);
    }

    protected void unsetLocMgr(ServiceReference<WsLocationAdmin> ref) {
    }

    public void performFileBasedAction(Collection<File> modifiedFiles) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"performFileBasedAction", (Object[])new Object[]{modifiedFiles});
            }
            try {
                for (File modifiedKeystoreFile : modifiedFiles) {
                    String keyStorePath = modifiedKeystoreFile.getCanonicalPath();
                    KeyStoreManager.getInstance().findKeyStoreInMapAndClear(keyStorePath);
                    AbstractJSSEProvider.removeEntryFromSSLContextMap(keyStorePath);
                    SSLConfigManager.getInstance().resetDefaultSSLContextIfNeeded(keyStorePath);
                }
                Tr.audit((TraceComponent)tc, (String)"ssl.keystore.modified.CWPKI0811I", (Object[])modifiedFiles.toArray());
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Exception while trying to reload keystore file, exception is: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performFileBasedAction");
        }
    }

    @Override
    public void performKeyStoreAction(Collection<String> modifiedKeyStores) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performSAFKeyRingAction", (Object[])new Object[]{modifiedKeyStores});
        }
        for (String modifiedKeyStore : modifiedKeyStores) {
            try {
                String modifiedKeyStoreName = WSKeyStore.processKeyringURL(modifiedKeyStore);
                KeyStoreManager.getInstance().findKeyStoreInMapAndClear(modifiedKeyStoreName);
                AbstractJSSEProvider.removeEntryFromSSLContextMap(modifiedKeyStoreName);
                SSLConfigManager.getInstance().resetDefaultSSLContextIfNeeded(modifiedKeyStoreName);
                Tr.audit((TraceComponent)tc, (String)"ssl.keystore.modified.CWPKI0811I", (Object[])modifiedKeyStores.toArray());
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Exception while trying to reload keystore file, exception is: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performSAFKeyRingAction");
        }
    }

    @Override
    public BundleContext getBundleContext() {
        if (this.cc != null) {
            return this.cc.getBundleContext();
        }
        return null;
    }

    protected void unsetFileMonitorRegistration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"unsetFileMonitorRegistration", (Object[])new Object[0]);
        }
        if (this.keyStoreFileMonitorRegistration != null) {
            this.keyStoreFileMonitorRegistration.unregister();
            this.keyStoreFileMonitorRegistration = null;
        }
    }

    protected void setFileMonitorRegistration(ServiceRegistration<FileMonitor> keyStoreFileMonitorRegistration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"setFileMonitorRegistration", (Object[])new Object[0]);
        }
        this.keyStoreFileMonitorRegistration = keyStoreFileMonitorRegistration;
    }

    private void createFileMonitor(String ID, String keyStoreLocation, String trigger, long interval) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFileMonitor", (Object[])new Object[]{ID, keyStoreLocation, trigger, interval});
        }
        try {
            this.keyStoreFileMonitor = new SecurityFileMonitor((FileBasedActionable)this);
            this.setFileMonitorRegistration((ServiceRegistration<FileMonitor>)this.keyStoreFileMonitor.monitorFiles(ID, Arrays.asList(keyStoreLocation), interval, trigger));
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating the keystore file monitor.", (Object[])new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createFileMonitor", (Object)this, (Object[])new Object[]{ID, keyStoreLocation, interval});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFileMonitor");
        }
    }

    protected void unsetKeyringMonitorRegistration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"unsetKeyringMonitorRegistration", (Object[])new Object[0]);
        }
        if (this.keyringMonitorRegistration != null) {
            this.keyringMonitorRegistration.unregister();
            this.keyringMonitorRegistration = null;
        }
    }

    protected void setKeyringMonitorRegistration(ServiceRegistration<KeyringMonitor> keyringMonitorRegistration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"setKeyringMonitorRegistration", (Object[])new Object[0]);
        }
        this.keyringMonitorRegistration = keyringMonitorRegistration;
    }

    private void createKeyringMonitor(String ID, String trigger, String keyStoreLocation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createKeyringMonitor", (Object[])new Object[]{ID, trigger});
        }
        try {
            this.KeyringMonitor = new KeyringMonitorImpl(this);
            this.setKeyringMonitorRegistration(this.KeyringMonitor.monitorKeyRings(ID, trigger, keyStoreLocation));
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating the keyring monitor.", (Object[])new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createKeyringMonitor", (Object)this, (Object[])new Object[]{ID, keyStoreLocation});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createKeyringMonitor");
        }
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setCertificateCreator(DefaultSSLCertificateCreator creator) {
        String methodName = "setCertificateCreator(DefaultSSLCertificateCreator)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCertificateCreator(DefaultSSLCertificateCreator)", (Object[])new Object[]{creator});
        }
        DefaultSSLCertificateFactory.setDefaultSSLCertificateCreator((DefaultSSLCertificateCreator)creator);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCertificateCreator(DefaultSSLCertificateCreator)");
        }
    }

    public void unsetCertificateCreator(DefaultSSLCertificateCreator creator) {
        String methodName = "unsetCertificateCreator(DefaultSSLCertificateCreator)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetCertificateCreator(DefaultSSLCertificateCreator)", (Object[])new Object[]{creator});
        }
        DefaultSSLCertificateFactory.setDefaultSSLCertificateCreator(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetCertificateCreator(DefaultSSLCertificateCreator)");
        }
    }

    public void performFileBasedAction(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
    }
}

