/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcePublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        try {
            PublicKey publicKey = this.keyConverter.getPublicKey(pGPPublicKey);
            if (pGPPublicKey.getAlgorithm() == 18) {
                PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
                ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, new JcaKeyFingerprintCalculator()));
                String string = RFC6637Utils.getKeyEncryptionOID(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm()).getId();
                if (eCDHPublicBCPGKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                    KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("X25519");
                    keyPairGenerator.initialize(255, this.random);
                    KeyPair keyPair = keyPairGenerator.generateKeyPair();
                    KeyAgreement keyAgreement = this.helper.createKeyAgreement(RFC6637Utils.getXDHAlgorithm(publicKeyPacket));
                    keyAgreement.init((Key)keyPair.getPrivate(), (AlgorithmParameterSpec)userKeyingMaterialSpec);
                    keyAgreement.doPhase(publicKey, true);
                    SecretKey secretKey = keyAgreement.generateSecret(string);
                    SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(keyPair.getPublic().getEncoded());
                    byte[] byArray2 = Arrays.prepend(subjectPublicKeyInfo.getPublicKeyData().getBytes(), (byte)64);
                    return this.encryptSessionInfo(eCDHPublicBCPGKey, byArray, secretKey, byArray2);
                }
                AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters("EC");
                algorithmParameters.init(new X962Parameters(eCDHPublicBCPGKey.getCurveOID()).getEncoded());
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("EC");
                keyPairGenerator.initialize(algorithmParameters.getParameterSpec(AlgorithmParameterSpec.class), this.random);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                KeyAgreement keyAgreement = this.helper.createKeyAgreement(RFC6637Utils.getAgreementAlgorithm(publicKeyPacket));
                keyAgreement.init((Key)keyPair.getPrivate(), (AlgorithmParameterSpec)userKeyingMaterialSpec);
                keyAgreement.doPhase(publicKey, true);
                SecretKey secretKey = keyAgreement.generateSecret(string);
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(keyPair.getPublic().getEncoded());
                byte[] byArray3 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
                if (null == byArray3 || byArray3.length < 1 || byArray3[0] != 4) {
                    X9ECParameters x9ECParameters = JcaJcePGPUtil.getX9Parameters(eCDHPublicBCPGKey.getCurveOID());
                    byArray3 = x9ECParameters.getCurve().decodePoint(byArray3).getEncoded(false);
                }
                return this.encryptSessionInfo(eCDHPublicBCPGKey, byArray, secretKey, byArray3);
            }
            Cipher cipher = this.helper.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            cipher.init(1, (Key)publicKey, this.random);
            return cipher.doFinal(byArray);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (IOException iOException) {
            throw new PGPException("unable to encode MPI: " + iOException.getMessage(), iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("unable to set up ephemeral keys: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private byte[] encryptSessionInfo(ECDHPublicBCPGKey eCDHPublicBCPGKey, byte[] byArray, Key key, byte[] byArray2) throws GeneralSecurityException, IOException, PGPException {
        byte[] byArray3 = PGPPad.padSessionData(byArray, this.sessionKeyObfuscation);
        Cipher cipher = this.helper.createKeyWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
        cipher.init(3, key, this.random);
        byte[] byArray4 = cipher.wrap(new SecretKeySpec(byArray3, PGPUtil.getSymmetricCipherName(byArray[0])));
        byte[] byArray5 = new MPInteger(new BigInteger(1, byArray2)).getEncoded();
        byte[] byArray6 = new byte[byArray5.length + 1 + byArray4.length];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        byArray6[byArray5.length] = (byte)byArray4.length;
        System.arraycopy(byArray4, 0, byArray6, byArray5.length + 1, byArray4.length);
        return byArray6;
    }
}

