/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.utility.IMaintenanceModeMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class GetMaintenanceTask
extends BaseCommandTask {
    private static final String className = GetMaintenanceTask.class.getName();
    private static final String ARG_SERVER = "--server";
    private static final String ARG_USR_DIR = "--usrDir";
    private static final String ARG_HOSTNAME = "--hostName";
    private final IMaintenanceModeMBeanConnection maintenanceMode;

    public GetMaintenanceTask(String scriptName, IMaintenanceModeMBeanConnection mbeanconn) {
        super(scriptName, null);
        this.maintenanceMode = mbeanconn;
        this.reqArgs.add(ARG_HOSTNAME);
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.add(ARG_USR_DIR);
        this.knownArgs.add(ARG_SERVER);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "getMaintenanceMode";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("getMaintenanceMode.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("getMaintenance.option-key.", "getMaintenance.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept");
        return this.getTaskHelp("getMaintenanceMode.desc", "getMaintenanceMode.usage.options", "connection.option-key", "connection.option-desc", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("getMaintenanceMode.desc", new Object[0]);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        Trlog.debug(methodName, methodName, "Validating command arguments...");
        this.validateArgumentList(args, false, false);
        Trlog.debug(methodName, methodName, "Parsing command arguments...");
        String controllerHost = this.getControllerHost(args);
        int port = Integer.parseInt(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String pwd = this.getControllerPassword(args);
        String hostName = this.getArgumentValue(ARG_HOSTNAME, args, null);
        String serverName = this.getArgumentValue(ARG_SERVER, args, null);
        String usrDir = this.getArgumentValue(ARG_USR_DIR, args, null);
        this.handleAutoAcceptArgument(args);
        if (serverName != null && usrDir == null || usrDir != null && serverName == null) {
            String missingArg = usrDir == null ? ARG_USR_DIR : ARG_SERVER;
            this.abort(this.getMessage("missingArg", missingArg), methodName);
        }
        Trlog.debug(className, methodName, "Controller info: ", new Object[]{"controllerHost: " + controllerHost, "controllerPort: " + port, "username: " + user, "password: " + pwd.replaceAll(".", "*")});
        Trlog.debug(className, methodName, "Target info: ", new Object[]{"targetHost: " + hostName, "server: " + serverName, "userDir: " + usrDir});
        this.getMaintenanceMode(controllerHost, port, user, pwd, hostName, usrDir, serverName);
        Trlog.exit(className, methodName);
    }

    private void getMaintenanceMode(String host, int port, String user, String pwd, String hostName, String usrDir, String serverName) throws TaskErrorException {
        String target;
        String methodName = "getMaintenanceMode";
        Trlog.enter(className, methodName, "serverName = " + serverName);
        if (serverName == null) {
            target = hostName;
        } else {
            usrDir = RepositoryPathUtility.normalizePath((String)usrDir);
            target = RepositoryPathUtility.buildServerTuple((String)hostName, (String)usrDir, (String)serverName);
        }
        Trlog.debug(className, methodName, "Displaying maintenance mode on target = " + target);
        try {
            ArrayList<String> targets = new ArrayList<String>(1);
            targets.add(target);
            List<Map<String, String>> results = serverName == null ? this.maintenanceMode.getHostMaintenanceMode(host, port, user, pwd, targets) : this.maintenanceMode.getServerMaintenanceMode(host, port, user, pwd, targets);
            Map<String, String> result = results.get(0);
            if (serverName == null) {
                Trlog.debug(className, methodName, "process host result");
                this.processResult(hostName, result.get(hostName));
            }
            Trlog.debug(className, methodName, "process server results");
            for (Map.Entry<String, String> entry : result.entrySet()) {
                String key = entry.getKey();
                if (key.equals(hostName)) continue;
                int lastTupleComponent = Math.max(0, key.lastIndexOf(44));
                String name = key.substring(lastTupleComponent + 1);
                this.processResult(name, entry.getValue());
            }
        }
        catch (UnknownHostException e) {
            this.abort(this.getMessage("common.hostError", host), methodName);
        }
        catch (RuntimeMBeanException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()), methodName);
        }
        catch (ConnectException e) {
            if (e.getMessage() != null && e.getMessage().contains(this.maintenanceMode.getMaintModeConnectExceptionMsg())) {
                this.abort(this.getMessage("getMaintenanceMode.connectionError", hostName), methodName);
            } else {
                this.abort(this.getMessage("common.portError", String.valueOf(port)), methodName);
            }
        }
        catch (IOException e) {
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()), methodName);
        }
        catch (KeyManagementException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("getMaintenanceMode.error", target), methodName);
        }
        catch (InstanceNotFoundException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("getMaintenanceMode.error", target), methodName);
        }
        catch (NoSuchAlgorithmException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("getMaintenanceMode.error", target), methodName);
        }
        catch (ReflectionException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("getMaintenanceMode.error", target), methodName);
        }
        catch (MBeanException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("getMaintenanceMode.error", target), methodName);
        }
    }

    private void processResult(String name, String status) throws TaskErrorException {
        String methodName = "processResult";
        if (status.equals("inMaintenanceMode")) {
            Trlog.debug(className, methodName, "Maintenance mode is set for " + name);
            this.stdout.println(this.getMessage("getMaintenanceMode.inMM", name));
        } else if (status.equals("notInMaintenanceMode")) {
            Trlog.debug(className, methodName, "Maintenance mode is not set for " + name);
            this.stdout.println(this.getMessage("getMaintenanceMode.notInMM", name));
        } else if (status.equals("alternateServerStarting")) {
            Trlog.debug(className, methodName, "Alternate server is starting for " + name);
            this.stdout.println(this.getMessage("getMaintenanceMode.alt", name));
        } else {
            Trlog.debug(className, methodName, "Encountered an error while getting maintenance mode for " + name + ".  An unexpected server status of " + status + " has been reported.");
            this.abort(this.getMessage("getMaintenanceMode.error", name), methodName);
        }
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File cleanupRoot) throws TaskErrorException {
        throw new TaskErrorException(message);
    }
}

