/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.javaee.dd.common.PersistenceUnitRef;
import com.ibm.ws.jpa.management.AbstractJPAInjectionBinding;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;

public class JPAPUnitInjectionBinding
extends AbstractJPAInjectionBinding<PersistenceUnit> {
    private static final TraceComponent tc = Tr.register(JPAPUnitInjectionBinding.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private boolean ivPuFromXML;

    public JPAPUnitInjectionBinding(PersistenceUnitRef pUnitRef, ComponentNameSpaceConfiguration nameSpaceConfig) throws InjectionException {
        super(JPAPUnitInjectionBinding.newPersistenceUnit(pUnitRef.getName(), pUnitRef.getPersistenceUnitName()), pUnitRef.getName(), pUnitRef.getPersistenceUnitName(), nameSpaceConfig);
        String pUnitName = pUnitRef.getPersistenceUnitName();
        this.setInjectionClassType(EntityManagerFactory.class);
        if (pUnitName != null && pUnitName.length() > 0) {
            this.ivPuFromXML = true;
        }
    }

    public JPAPUnitInjectionBinding(PersistenceUnit pUnit, ComponentNameSpaceConfiguration nameSpaceConfig) throws InjectionException {
        super(pUnit, pUnit.name(), pUnit.unitName(), nameSpaceConfig);
        this.setInjectionClassType(EntityManagerFactory.class);
    }

    public void merge(PersistenceUnitRef pUnitRef) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge : " + pUnitRef), (Object[])new Object[0]);
        }
        PersistenceUnit thisPu = (PersistenceUnit)this.getAnnotation();
        String thisUnitName = thisPu.unitName();
        String mergedUnitName = pUnitRef.getPersistenceUnitName();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new=" + this.getJndiName() + ":" + mergedUnitName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("cur=" + this.getJndiName() + ":" + thisUnitName), (Object[])new Object[0]);
        }
        if (thisUnitName == null || thisUnitName.equals("")) {
            if (mergedUnitName != null) {
                this.setAnnotation((Annotation)JPAPUnitInjectionBinding.newPersistenceUnit(this.getJndiName(), mergedUnitName));
                this.ivPuId.setPuName(mergedUnitName);
                this.ivPuFromXML = true;
            }
        } else if (mergedUnitName != null && !mergedUnitName.equals("") && !thisUnitName.equals(mergedUnitName)) {
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWWJP0041E", (Object[])new Object[]{this.ivJ2eeName.getModule(), this.ivJ2eeName.getApplication(), "persistence-unit-name", "persistence-unit-ref", "persistence-unit-ref-name", this.getJndiName(), thisUnitName, mergedUnitName});
            String exMsg = "CWWJP0041E: The " + this.ivJ2eeName.getModule() + " module of the " + this.ivJ2eeName.getApplication() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting persistence-unit-name element values exist for multiple persistence-unit-ref elements with the same persistence-unit-ref-name element value : " + this.getJndiName() + ". The conflicting persistence-unit-name element values are " + thisUnitName + " and " + mergedUnitName + ".";
            throw new InjectionConfigurationException(exMsg);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("merge : " + (Object)((Object)this)));
        }
    }

    public void merge(PersistenceUnit annotation, Class<?> instanceClass, Member member) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge : " + annotation + ", " + instanceClass + ", " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if (!this.ivPuFromXML) {
            PersistenceUnit thisPu = (PersistenceUnit)this.getAnnotation();
            String thisUnitName = thisPu.unitName();
            String mergedUnitName = annotation.unitName();
            if (mergedUnitName != null && mergedUnitName.length() > 0) {
                if (!(this.isComplete() || thisUnitName != null && thisUnitName.length() != 0)) {
                    this.setAnnotation((Annotation)JPAPUnitInjectionBinding.newPersistenceUnit(thisPu.name(), mergedUnitName));
                } else if (!mergedUnitName.equals(thisUnitName)) {
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWWJP0042E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "unitName", "@PersistenceUnit", "name", this.getJndiName(), thisUnitName, mergedUnitName});
                    String exMsg = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in source code annotations. Conflicting unitName attribute values exist for multiple @PersistenceUnit annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting unitName attribute values are " + thisUnitName + " and " + mergedUnitName + ".";
                    throw new InjectionConfigurationException(exMsg);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("merge : " + (Object)((Object)this)));
        }
    }

    public void mergeSaved(InjectionBinding<PersistenceUnit> injectionBinding) throws InjectionException {
        JPAPUnitInjectionBinding pUnitBinding = (JPAPUnitInjectionBinding)injectionBinding;
        PersistenceUnit pUnitBindingAnn = (PersistenceUnit)pUnitBinding.getAnnotation();
        PersistenceUnit ann = (PersistenceUnit)this.getAnnotation();
        this.mergeSavedValue(ann.unitName(), pUnitBindingAnn.unitName(), "persistence-unit-name");
    }

    private static PersistenceUnit newPersistenceUnit(final String fJndiName, final String fUnitName) {
        return new PersistenceUnit(){

            public String name() {
                return fJndiName;
            }

            public Class<? extends Annotation> annotationType() {
                return PersistenceUnit.class;
            }

            public String unitName() {
                return fUnitName;
            }

            public String toString() {
                return "JPA.PersistenceUnit(name=" + fJndiName + ", unitName=" + fUnitName + ")";
            }
        };
    }
}

