/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundChannel;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channelfw.OutboundProtocol;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.base.OutboundProtocolLink;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.io.IOException;

public class HttpOutboundLink
extends OutboundProtocolLink
implements OutboundProtocol {
    private static final TraceComponent tc = Tr.register(HttpOutboundLink.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private HttpOutboundServiceContextImpl myInterface = null;
    private HttpOutboundChannel myChannel = null;
    private boolean bAllowReconnect = true;
    private boolean bEnableReconnect = true;
    private HttpAddress targetAddress = null;
    private boolean bIsActive = false;
    private boolean reconnecting = false;
    private IOException reconnectException = null;
    private boolean earlyReconnectDestroy = false;

    public HttpOutboundLink(HttpOutboundChannel c, VirtualConnection vc) {
        this.init(vc, c);
    }

    public void init(VirtualConnection inVC, HttpOutboundChannel channel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Init on link: " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
        }
        super.init(inVC);
        this.myChannel = channel;
        this.bIsActive = true;
        this.setEnableReconnect(this.myChannel.getHttpConfig().allowsRetries());
        this.setAllowReconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying this outbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()), (Object[])new Object[0]);
        }
        if (!this.reconnecting) {
            HttpOutboundLink httpOutboundLink = this;
            synchronized (httpOutboundLink) {
                if (!this.bIsActive) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Ignoring destroy on an inactive object", (Object[])new Object[0]);
                    }
                    return;
                }
                this.bIsActive = false;
            }
            super.destroy(e);
            if (null != this.myInterface) {
                this.myInterface.destroy();
                this.myInterface = null;
            }
            this.targetAddress = null;
            this.myChannel = null;
        } else {
            this.earlyReconnectDestroy = true;
            IOException ioe = this.reconnectException;
            this.reconnectException = null;
            this.reconnecting = false;
            this.myInterface.callErrorCallback(this.getVirtualConnection(), ioe);
        }
    }

    private HttpOutboundServiceContextImpl getInterface(VirtualConnection inVC) {
        if (null == this.myInterface) {
            this.myInterface = new HttpOutboundServiceContextImpl((TCPConnectionContext)this.getDeviceLink().getChannelAccessor(), this, inVC, this.myChannel.getHttpConfig());
        }
        return this.myInterface;
    }

    public Object getChannelAccessor() {
        return this.getInterface(this.getVirtualConnection());
    }

    public String getProtocol() {
        return "HTTP";
    }

    protected void postConnectProcessing(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Finished connecting to target: " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
        }
        this.getInterface(inVC);
    }

    public void ready(VirtualConnection inVC) {
        if (!this.reconnecting) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Outbound ready for " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
            }
            super.ready(inVC);
        } else {
            this.reconnecting = false;
            this.reconnectException = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Outbound reconnect finished for " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
            }
            this.myInterface.nowReconnectedAsync();
        }
    }

    protected void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clearing the outbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()), (Object[])new Object[0]);
        }
        this.setEnableReconnect(this.myChannel.getHttpConfig().allowsRetries());
        this.setAllowReconnect(true);
        this.reconnecting = false;
        this.reconnectException = null;
        this.earlyReconnectDestroy = false;
    }

    public void close(VirtualConnection inVC, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closing this outbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()), (Object[])new Object[0]);
        }
        this.setAllowReconnect(false);
        if (!this.earlyReconnectDestroy) {
            super.close(inVC, e);
        } else {
            this.destroy(e);
        }
    }

    public void connect(Object address) throws Exception {
        this.targetAddress = (HttpAddress)address;
        if (null != this.myInterface && this.isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Clearing existing OSC on connect", (Object[])new Object[0]);
            }
            this.myInterface.clear();
        }
        super.connect(address);
    }

    public void connectAsynch(Object address) {
        this.targetAddress = (HttpAddress)address;
        if (null != this.myInterface && this.isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Clearing existing OSC on connectAsynch", (Object[])new Object[0]);
            }
            this.myInterface.clear();
        }
        super.connectAsynch(address);
    }

    protected void reConnectSync(IOException originalExcep) throws IOException {
        this.setAllowReconnect(false);
        try {
            this.connect(this.getTargetAddress());
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Sync reconnect failed, throwing original exception", (Object[])new Object[0]);
            }
            throw originalExcep;
        }
    }

    protected void reConnectAsync(IOException originalExcep) {
        this.setAllowReconnect(false);
        this.reconnecting = true;
        this.reconnectException = originalExcep;
        this.connectAsynch(this.getTargetAddress());
    }

    protected boolean isReconnectAllowed() {
        return this.bAllowReconnect;
    }

    private boolean isReconnectEnabled() {
        return this.bEnableReconnect;
    }

    private void setEnableReconnect(boolean flag) {
        this.bEnableReconnect = flag;
    }

    protected void setAllowReconnect(boolean flag) {
        this.bAllowReconnect = flag & this.isReconnectEnabled();
    }

    protected boolean disallowRewrites() {
        this.setEnableReconnect(false);
        this.setAllowReconnect(false);
        return !this.isReconnectAllowed();
    }

    protected final boolean allowRewrites() {
        this.setAllowReconnect(true);
        return this.isReconnectAllowed();
    }

    public HttpAddress getTargetAddress() {
        return this.targetAddress;
    }

    public HttpObjectFactory getObjectFactory() {
        return null == this.myChannel ? null : this.myChannel.getObjectFactory();
    }

    public boolean isConnected() {
        if (!this.myInterface.isIncomingMessageFullyRead()) {
            return true;
        }
        try {
            if (null == this.myInterface.getTSC().getReadInterface().getBuffer()) {
                this.myInterface.getTSC().getReadInterface().setJITAllocateSize(this.myInterface.getHttpConfig().getIncomingHdrBufferSize());
            }
            this.myInterface.getTSC().getReadInterface().read(0L, 0);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

