/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache.keyproviders;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.CacheContext;
import com.ibm.ws.security.authentication.cache.CacheKeyProvider;
import com.ibm.ws.security.authentication.jaas.modules.CertificateLoginModule;
import java.security.cert.X509Certificate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class X509CertCacheKeyProvider
implements CacheKeyProvider {
    private static final TraceComponent tc = Tr.register(X509CertCacheKeyProvider.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    static final long serialVersionUID = -8754184317078745110L;

    public Object provideKey(CacheContext cacheContext) {
        X509Certificate[] cert_chain;
        Boolean isCollectiveCert = CertificateLoginModule.collectiveCertificate.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("collectiveCertificate=" + isCollectiveCert), (Object[])new Object[0]);
        }
        if (!(isCollectiveCert != null && isCollectiveCert.booleanValue() || (cert_chain = cacheContext.getCertChain()) == null)) {
            int certHash = cert_chain[0].hashCode();
            return certHash;
        }
        return null;
    }
}

