/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.monitor;

import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.request.timing.monitor.RequestTimingStats;
import com.ibm.ws.request.timing.stats.RequestTiming;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Monitor(group={"RequestTiming"})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"service.vendor = IBM"})
public class RequestTimingMonitor {
    private RequestTiming requestTimingobject = null;
    @PublishedMetric
    public MeterCollection<RequestTimingStats> servletCountByName = new MeterCollection("Servlet", (Object)this);
    private static final Map<String, String[]> requestTypeMap;
    static final long serialVersionUID = -2399423780859101892L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate() {
    }

    @Deactivate
    protected void deactivate() {
        this.clearStatsCollection();
    }

    @Reference(service=RequestTiming.class, policyOption=ReferencePolicyOption.GREEDY)
    protected void setrequestTiming(RequestTiming requestTiming) {
        this.requestTimingobject = requestTiming;
        this.initRequestTimingStats();
    }

    protected void unsetrequestTiming(RequestTiming requestTiming) {
        this.requestTimingobject = null;
    }

    public synchronized RequestTimingStats initRequestTimingStats() {
        String key = "Servlet";
        RequestTimingStats nStats = (RequestTimingStats)this.servletCountByName.get(key);
        if (nStats == null) {
            nStats = new RequestTimingStats(this.requestTimingobject, requestTypeMap.get(key));
            this.servletCountByName.put(key, (Object)nStats);
        }
        return nStats;
    }

    public synchronized void clearStatsCollection() {
        String key = "Servlet";
        this.servletCountByName.remove(key);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.request.timing.monitor.RequestTimingMonitor", RequestTimingMonitor.class, (String)"requestTiming", null);
        requestTypeMap = new HashMap<String, String[]>();
        requestTypeMap.put("Servlet", new String[]{"websphere.servlet.service", "websphere.http.wrapHandlerAndExecute"});
    }
}

