/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.utils;

import com.ibm.ws.bluemix.utility.utils.HttpRequest;
import com.ibm.ws.bluemix.utility.utils.IOUtils;
import com.ibm.ws.bluemix.utility.utils.LibertyProperties;
import com.ibm.ws.bluemix.utility.utils.SSLUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequestBuilder {
    public static final String DEFAULT_USER_AGENT = HttpRequestBuilder.getDefaultUserAgent();
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String FORM_URLENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 90000;
    private URL url;
    private final Map<String, String> headers = new HashMap<String, String>();
    private String requestMethod;
    private String messageBody;
    private int connectionTimeout = 30000;
    private int readTimeout = 90000;
    private SSLSocketFactory sslSocketFactory;

    public HttpRequestBuilder setURL(String url) throws IOException {
        this.url = new URL(url);
        return this;
    }

    public HttpRequestBuilder setURL(URL url) {
        this.url = url;
        return this;
    }

    public HttpRequestBuilder setHeader(String header, String value) {
        this.headers.put(header, value);
        return this;
    }

    public HttpRequestBuilder setAcceptLanguageHeader() {
        return this.setAcceptLanguageHeader(Locale.getDefault());
    }

    public HttpRequestBuilder setAcceptLanguageHeader(Locale locale) {
        String language = locale.getLanguage();
        if (language != null && !language.isEmpty()) {
            String country = locale.getCountry();
            String value = country != null && !country.isEmpty() ? language + "-" + country : language;
            this.headers.put("Accept-Language", value);
        }
        return this;
    }

    public HttpRequestBuilder setUserAgent() {
        return this.setUserAgent(DEFAULT_USER_AGENT);
    }

    public HttpRequestBuilder setUserAgent(String userAgent) {
        this.headers.put("User-Agent", userAgent);
        return this;
    }

    public HttpRequestBuilder setRequestMethod(String method) {
        this.requestMethod = method;
        return this;
    }

    public HttpRequestBuilder setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    public HttpRequestBuilder setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
        return this;
    }

    public HttpRequestBuilder setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public HttpRequestBuilder setSSLSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest build() throws IOException {
        HttpURLConnection request = (HttpURLConnection)this.url.openConnection();
        request.setConnectTimeout(this.connectionTimeout);
        request.setReadTimeout(this.readTimeout);
        this.configureSSL(request);
        if (this.requestMethod != null) {
            request.setRequestMethod(this.requestMethod);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.messageBody != null) {
            request.setDoOutput(true);
            DataOutputStream messageBodyWriter = null;
            try {
                messageBodyWriter = new DataOutputStream(request.getOutputStream());
                messageBodyWriter.writeBytes(this.messageBody);
            }
            catch (Throwable throwable) {
                IOUtils.close(messageBodyWriter);
                throw throwable;
            }
            IOUtils.close(messageBodyWriter);
        }
        return new HttpRequest(request);
    }

    private void configureSSL(HttpURLConnection request) throws IOException {
        if (request instanceof HttpsURLConnection) {
            if (this.sslSocketFactory == null) {
                try {
                    ((HttpsURLConnection)request).setSSLSocketFactory(SSLUtils.createDefaultSSLSocketFactory());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                ((HttpsURLConnection)request).setSSLSocketFactory(this.sslSocketFactory);
            }
        }
    }

    private static String getDefaultUserAgent() {
        return "bluemixUtility/" + LibertyProperties.getVersion();
    }
}

