/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.internal.URLHandler;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ReferrerURLCookieHandler
extends URLHandler {
    private static final TraceComponent tc = Tr.register(ReferrerURLCookieHandler.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    public static final String REFERRER_URL_COOKIENAME = "WASReqURL";
    public static final String CUSTOM_RELOGIN_URL_COOKIENAME = "WASReLoginURL";
    static final long serialVersionUID = 1023233786668552858L;

    public ReferrerURLCookieHandler(WebAppSecurityConfig webAppSecConfig) {
        super(webAppSecConfig);
    }

    @Sensitive
    public String getReferrerURLFromCookies(HttpServletRequest req, String cookieName) {
        Cookie[] cookies = req.getCookies();
        String referrerURL = CookieHelper.getCookieValue(cookies, cookieName);
        if (referrerURL != null) {
            StringBuffer URL2 = req.getRequestURL();
            referrerURL = this.decodeURL(referrerURL);
            referrerURL = this.restoreHostNameToURL(referrerURL, URL2.toString());
        }
        return referrerURL;
    }

    public Cookie createReferrerURLCookie(String cookieName, @Sensitive String url, HttpServletRequest req) {
        if (!this.webAppSecConfig.getPreserveFullyQualifiedReferrerUrl()) {
            url = this.removeHostNameFromURL(url);
        }
        return this.createCookie(cookieName, url, req);
    }

    public Cookie createCookie(String cookieName, @Sensitive String value, HttpServletRequest req) {
        value = this.encodeURL(value);
        return this.createCookie(cookieName, value, true, req);
    }

    public Cookie createCookie(String cookieName, @Sensitive String value, boolean enableHttpOnly, HttpServletRequest req) {
        String sameSite;
        Cookie c = new Cookie(cookieName, value);
        if (cookieName.equals(REFERRER_URL_COOKIENAME) || cookieName.startsWith("WASOidcStateKey")) {
            c.setPath(this.getPathName(req));
        } else {
            c.setPath("/");
        }
        c.setMaxAge(-1);
        if (enableHttpOnly && this.webAppSecConfig.getHttpOnlyCookies()) {
            c.setHttpOnly(true);
        }
        if (this.webAppSecConfig.getSSORequiresSSL()) {
            c.setSecure(true);
        }
        if ((sameSite = this.webAppSecConfig.getSameSiteCookie()) != null && !sameSite.equals("Disabled")) {
            WebContainerRequestState requestState = WebContainerRequestState.getInstance((boolean)true);
            requestState.setCookieAttributes(cookieName, "SameSite=" + sameSite);
            if (sameSite.equals("None")) {
                c.setSecure(true);
            }
        }
        return c;
    }

    public void invalidateReferrerURLCookies(HttpServletRequest req, HttpServletResponse res, String[] cookieNames) {
        for (String cookieName : cookieNames) {
            this.invalidateReferrerURLCookie(req, res, cookieName);
        }
    }

    public void invalidateReferrerURLCookie(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        this.invalidateCookie(req, res, cookieName, true);
    }

    public void invalidateCookie(HttpServletRequest req, HttpServletResponse res, String cookieName, boolean enableHttpOnly) {
        Cookie c = new Cookie(cookieName, "");
        if (cookieName.equals(REFERRER_URL_COOKIENAME)) {
            c.setPath(this.getPathName(req));
        } else {
            c.setPath("/");
        }
        c.setMaxAge(0);
        if (enableHttpOnly && this.webAppSecConfig.getHttpOnlyCookies()) {
            c.setHttpOnly(true);
        }
        if (this.webAppSecConfig.getSSORequiresSSL()) {
            c.setSecure(true);
        }
        res.addCookie(c);
    }

    public void clearReferrerURLCookie(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        String url = CookieHelper.getCookieValue(req.getCookies(), cookieName);
        if (url != null && url.length() > 0) {
            this.invalidateReferrerURLCookie(req, res, cookieName);
        }
    }

    public AuthenticationResult shouldRedirectToReferrerURL(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        AuthenticationResult result = null;
        boolean restore = false;
        if (!restore) {
            return result;
        }
        String WasReqURLValue = this.getReferrerURLFromCookies(req, cookieName);
        if (WasReqURLValue != null && WasReqURLValue.trim().length() > 0) {
            StringBuffer reqURL = req.getRequestURL();
            if (req.getQueryString() != null) {
                reqURL.append("?");
                reqURL.append(req.getQueryString());
            }
            String currentURL = reqURL.toString();
            String currentURI = this.getServletURI(req);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("\nCurrentURL: " + currentURL + "\nCurrentURI: " + currentURI + "\nWasReqURL: " + WasReqURLValue), (Object[])new Object[0]);
            }
            if (currentURL != null && currentURI != null && WasReqURLValue.toLowerCase().indexOf(currentURI.toLowerCase()) > 0 && !WasReqURLValue.equalsIgnoreCase(currentURL)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Redirect the request to the original URL: " + WasReqURLValue), (Object[])new Object[0]);
                }
                result = new AuthenticationResult(AuthResult.REDIRECT, WasReqURLValue);
                this.invalidateReferrerURLCookie(req, res, cookieName);
            }
        }
        return result;
    }

    public String getPathName(HttpServletRequest req) {
        String pathName = "/";
        if (this.webAppSecConfig.isIncludePathInWASReqURL() && ((pathName = req.getContextPath()) == null || pathName.isEmpty())) {
            pathName = "/";
        }
        return pathName;
    }

    public void setReferrerURLCookie(HttpServletRequest req, AuthenticationResult authResult, String url) {
        if (url.contains("/favicon.ico") && CookieHelper.getCookieValue(req.getCookies(), REFERRER_URL_COOKIENAME) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Will not update the WASReqURL cookie", (Object[])new Object[0]);
            }
        } else {
            if (!this.webAppSecConfig.getPreserveFullyQualifiedReferrerUrl()) {
                url = this.removeHostNameFromURL(url);
            }
            url = this.encodeURL(url);
            authResult.setCookie(this.createReferrerUrlCookie(req, url));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"set WASReqURL cookie into AuthenticationResult.", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"setReferrerURLCookie", (Object[])new Object[]{"Referrer URL cookie set " + url});
            }
        }
    }

    private Cookie createReferrerUrlCookie(HttpServletRequest req, final String url) {
        Cookie referrerUrlCookie = System.getSecurityManager() == null ? new Cookie(REFERRER_URL_COOKIENAME, url) : AccessController.doPrivileged(new PrivilegedAction<Cookie>(){
            static final long serialVersionUID = -1296098855369353441L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Cookie run() {
                return new Cookie(ReferrerURLCookieHandler.REFERRER_URL_COOKIENAME, url);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler$1", 1.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
            }
        });
        referrerUrlCookie.setPath(this.getPathName(req));
        referrerUrlCookie.setMaxAge(-1);
        referrerUrlCookie.setSecure(this.webAppSecConfig.getSSORequiresSSL());
        return referrerUrlCookie;
    }

    public static void isReferrerHostValid(final String currentReqURL, final String storedReq, final List<String> domainList) throws RuntimeException {
        Boolean isValid = false;
        isValid = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 4000094468416852126L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean run() {
                Boolean _isValid = false;
                URL referrerURL = null;
                URL currentURL = null;
                try {
                    referrerURL = new URL(storedReq);
                    currentURL = new URL(currentReqURL);
                    if (referrerURL != null && currentURL != null) {
                        String referrerHost = referrerURL.getHost();
                        String currentReqHost = currentURL.getHost();
                        if (referrerHost != null && currentReqHost != null && (referrerHost.equalsIgnoreCase(currentReqHost) || ReferrerURLCookieHandler.isReferrerHostMatchDomainNameList(referrerHost, domainList))) {
                            _isValid = true;
                        }
                    }
                }
                catch (MalformedURLException referrerHost) {
                    void me;
                    FFDCFilter.processException((Throwable)referrerHost, (String)"com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler$2", (String)"301", (Object)this, (Object[])new Object[0]);
                    if (referrerURL == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("WASReqURL:" + storedReq + " is a MalformedURL."), (Object[])new Object[0]);
                        }
                        RuntimeException e = new RuntimeException("WASReqURL:'" + storedReq + "' is not a valid URL.", (Throwable)me);
                        throw e;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("currentURL:" + currentReqURL + " is a MalformedURL."), (Object[])new Object[0]);
                    }
                    RuntimeException e = new RuntimeException("The request URL:'" + currentReqURL + "' is not a valid URL.", (Throwable)me);
                    throw e;
                }
                return _isValid;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler$2", 2.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
            }
        });
        if (!isValid.booleanValue()) {
            RuntimeException e = new RuntimeException("WASReqURL:'" + storedReq + "' hostname does not match current request hostname: '" + currentReqURL + "'");
            throw e;
        }
    }

    static boolean isReferrerHostMatchDomainNameList(String referrerHost, List<String> _wasReqURLRedirectDomainNames) {
        boolean acceptURL = false;
        if (_wasReqURLRedirectDomainNames != null && !_wasReqURLRedirectDomainNames.isEmpty()) {
            for (String domain : _wasReqURLRedirectDomainNames) {
                if (!referrerHost.endsWith(domain)) continue;
                acceptURL = true;
                break;
            }
        }
        return acceptURL;
    }
}

