/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.security.jwt.Builder;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.InvalidBuilderException;
import com.ibm.websphere.security.jwt.InvalidClaimException;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.security.jwt.JwtException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.websphere.security.jwt.KeyException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.KeyAlgorithmChecker;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.ClaimsImpl;
import com.ibm.ws.security.jwt.internal.TokenImpl;
import com.ibm.ws.security.jwt.utils.IssuerUtils;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jose4j.lang.JoseException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={Builder.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"}, name="builder")
public class BuilderImpl
implements Builder {
    private static final TraceComponent tc = Tr.register(BuilderImpl.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private Claims claims;
    private static boolean active = false;
    private String alg;
    private String sharedKey;
    private Key privateKey;
    private String configId;
    private String keyManagementAlg;
    private Key keyManagementKey;
    private String contentEncryptionAlg;
    private static final String DEFAULT_ID = "defaultJWT";
    private static final String KEY_JWT_SERVICE = "jwtConfig";
    private static final String CFG_KEY_ID = "id";
    public static final String DEFAULT_KEY_MANAGEMENT_ALGORITHM = "RSA-OAEP";
    public static final String DEFAULT_CONTENT_ENCRYPTION_ALGORITHM = "A256GCM";
    private final Object initlock = new Object(){
        static final long serialVersionUID = -1480829133143250052L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.internal.BuilderImpl$1", 1.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
        }
    };
    private static ConcurrentServiceReferenceMap<String, JwtConfig> jwtServiceMapRef = new ConcurrentServiceReferenceMap("jwtConfig");
    private final String KEY_VMM_SERVICE = "vmmService";
    private final AtomicServiceReference<VMMService> vmmServiceRef = new AtomicServiceReference("vmmService");
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    private final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    static final long serialVersionUID = 3180293001691593869L;

    public BuilderImpl() {
    }

    public BuilderImpl(String builderConfigId) throws InvalidBuilderException {
        this.claims = new ClaimsImpl();
        this.configId = builderConfigId;
        JwtConfig jwtConfig = this.getConfig(builderConfigId);
        this.setClaimsUsingTheConfig(jwtConfig);
    }

    private JwtConfig getConfig(String configId) throws InvalidBuilderException {
        JwtConfig jwtConfig = this.getTheServiceConfig(configId);
        if (jwtConfig == null) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_BUILDER_INVALID", (Object[])new Object[]{configId});
            throw new InvalidBuilderException(err);
        }
        return jwtConfig;
    }

    private void setClaimsUsingTheConfig(JwtConfig jwtConfig) throws InvalidBuilderException {
        List<String> amrAttr;
        String scope;
        List<String> aud;
        String issuer = IssuerUtils.getIssuerUrl(jwtConfig);
        if (issuer != null) {
            this.claims.put("iss", issuer);
        }
        this.claims.put("token_type", "Bearer");
        long exp = -2L;
        this.claims.put("exp", exp);
        long iat = -2L;
        this.claims.put("iat", iat);
        boolean isJti = jwtConfig.getJti();
        if (isJti) {
            String jti = JwtUtils.getRandom(16);
            this.claims.put("jti", jti);
        }
        if ((aud = jwtConfig.getAudiences()) != null) {
            this.claims.put("aud", aud);
        }
        if ((scope = jwtConfig.getScope()) != null) {
            this.claims.put("scope", scope);
        }
        if (jwtConfig.getSignatureAlgorithm() != null) {
            this.alg = jwtConfig.getSignatureAlgorithm();
        }
        if (jwtConfig.getSharedKey() != null) {
            this.sharedKey = jwtConfig.getSharedKey();
        }
        if ((amrAttr = jwtConfig.getAMRAttributes()) != null) {
            try {
                this.checkAmrAttrInSubject(amrAttr);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.BuilderImpl", (String)"189", (Object)this, (Object[])new Object[]{jwtConfig});
            }
        }
    }

    private JwtConfig getTheServiceConfig(String builderConfigId) {
        return (JwtConfig)jwtServiceMapRef.getService((Object)builderConfigId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JwtConfig.class, name="jwtConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setJwtConfig(ServiceReference<JwtConfig> ref) {
        Object object = this.initlock;
        synchronized (object) {
            jwtServiceMapRef.putReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetJwtConfig(ServiceReference<JwtConfig> ref) {
        Object object = this.initlock;
        synchronized (object) {
            jwtServiceMapRef.removeReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
        }
    }

    @Reference(service=VMMService.class, name="vmmService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setVmmService(ServiceReference<VMMService> ref) {
        this.vmmServiceRef.setReference(ref);
    }

    protected void unsetVmmService(ServiceReference<VMMService> ref) {
        this.vmmServiceRef.unsetReference(ref);
    }

    @Reference(service=KeyStoreService.class, name="keyStoreService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.unsetReference(ref);
    }

    @Reference(service=SSLSupport.class, name="sslSupport", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        jwtServiceMapRef.activate(cc);
        this.vmmServiceRef.activate(cc);
        this.keyStoreServiceRef.activate(cc);
        this.sslSupportRef.activate(cc);
        JwtUtils.setVMMService(this.vmmServiceRef);
        JwtUtils.setKeyStoreService(this.keyStoreServiceRef);
        JwtUtils.setSSLSupportService(this.sslSupportRef);
        active = true;
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
        jwtServiceMapRef.deactivate(cc);
        this.vmmServiceRef.deactivate(cc);
        this.keyStoreServiceRef.deactivate(cc);
        this.sslSupportRef.deactivate(cc);
        JwtUtils.setVMMService(null);
        JwtUtils.setKeyStoreService(null);
        JwtUtils.setSSLSupportService(null);
        active = false;
    }

    @Override
    public Builder create() throws InvalidBuilderException {
        if (!active) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_BUILDER_NOT_ACTIVE", (Object[])new Object[]{DEFAULT_ID});
            throw new InvalidBuilderException(err);
        }
        return this.create(DEFAULT_ID);
    }

    @Override
    public synchronized Builder create(String builderConfigId) throws InvalidBuilderException {
        if (builderConfigId == null || builderConfigId.isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_BUILDER_INVALID", (Object[])new Object[]{builderConfigId});
            throw new InvalidBuilderException(err);
        }
        if (!active) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_BUILDER_NOT_ACTIVE", (Object[])new Object[]{builderConfigId});
            throw new InvalidBuilderException(err);
        }
        return new BuilderImpl(builderConfigId);
    }

    @Override
    public Builder issuer(String issuerUrl) throws InvalidClaimException {
        if (issuerUrl == null || issuerUrl.isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{"iss", issuerUrl});
            throw new InvalidClaimException(err);
        }
        this.claims.put("iss", issuerUrl);
        return this;
    }

    @Override
    public Builder audience(List<String> newaudiences) throws InvalidClaimException {
        ArrayList<String> audiences;
        if (newaudiences != null && !newaudiences.isEmpty()) {
            audiences = new ArrayList<String>();
            for (String aud : newaudiences) {
                if (aud == null || aud.trim().isEmpty() || audiences.contains(aud)) continue;
                audiences.add(aud);
            }
            if (audiences.isEmpty()) {
                String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{"aud", newaudiences});
                throw new InvalidClaimException(err);
            }
        } else {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{"aud", newaudiences});
            throw new InvalidClaimException(err);
        }
        this.claims.put("aud", audiences);
        return this;
    }

    @Override
    public Builder expirationTime(long exp) throws InvalidClaimException {
        long currTime = System.currentTimeMillis() / 1000L;
        if (exp < currTime) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_EXP_CLAIM_ERR", (Object[])new Object[]{"exp", exp, JwtUtils.getDate(exp * 1000L), JwtUtils.getDate(currTime * 1000L)});
            throw new InvalidClaimException(err);
        }
        this.claims.put("exp", exp);
        return this;
    }

    private Builder issueTime(long iat) throws InvalidClaimException {
        if (iat <= 0L) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TIME_CLAIM_ERR", (Object[])new Object[]{"iat"});
            throw new InvalidClaimException(err);
        }
        this.claims.put("iat", iat);
        return this;
    }

    @Override
    public Builder jwtId(boolean create) {
        if (create) {
            String jti = JwtUtils.getRandom(16);
            this.claims.put("jti", jti);
        } else {
            this.claims.remove("jti");
        }
        return this;
    }

    @Override
    public Builder notBefore(long time_from) throws InvalidClaimException {
        if (time_from <= 0L) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TIME_CLAIM_ERR", (Object[])new Object[]{"nbf"});
            throw new InvalidClaimException(err);
        }
        this.claims.put("nbf", time_from);
        return this;
    }

    @Override
    public Builder subject(String username) throws InvalidClaimException {
        if (username == null || username.isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{"sub", username});
            throw new InvalidClaimException(err);
        }
        this.claims.put("sub", username);
        return this;
    }

    @Override
    public Builder signWith(String algorithm, Key key) throws KeyException {
        if (!this.isValidAlgorithmForJavaSecurityKey(algorithm)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_ALGORITHM_ERR", (Object[])new Object[]{algorithm, this.getValidAlgorithmListForJavaSecurityKey()});
            throw new KeyException(err);
        }
        if (!this.isValidKeyType(key, algorithm)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_KEY_ERR", (Object[])new Object[]{algorithm, key});
            throw new KeyException(err);
        }
        this.alg = algorithm;
        this.privateKey = key;
        return this;
    }

    boolean isValidAlgorithmForJavaSecurityKey(String algorithm) {
        return KeyAlgorithmChecker.isRSAlgorithm((String)algorithm) || KeyAlgorithmChecker.isESAlgorithm((String)algorithm);
    }

    String getValidAlgorithmListForJavaSecurityKey() {
        return "RS256, RS384, RS512, ES256, ES384, ES512";
    }

    boolean isValidKeyType(Key key, String algorithm) {
        if (key == null) {
            return false;
        }
        return KeyAlgorithmChecker.isPrivateKeyValidType((Key)key, (String)algorithm);
    }

    @Override
    public Builder signWith(String algorithm, String key) throws KeyException {
        if (!this.isValidAlgorithmForStringKey(algorithm)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_ALGORITHM_ERR", (Object[])new Object[]{algorithm, this.getValidAlgorithmListForStringKey()});
            throw new KeyException(err);
        }
        if (key == null || key.isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_KEY_ERR", (Object[])new Object[]{algorithm, key});
            throw new KeyException(err);
        }
        this.alg = algorithm;
        this.sharedKey = key;
        return this;
    }

    boolean isValidAlgorithmForStringKey(String algorithm) {
        return KeyAlgorithmChecker.isHSAlgorithm((String)algorithm);
    }

    String getValidAlgorithmListForStringKey() {
        return "HS256, HS384, HS512";
    }

    @Override
    public Builder encryptWith(String keyManagementAlg, Key keyManagementKey, String contentEncryptionAlg) throws KeyException {
        if (keyManagementKey == null) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"KEY_MANAGEMENT_KEY_MISSING", (Object[])new Object[]{this.configId});
            throw new KeyException(err);
        }
        if (keyManagementAlg == null || keyManagementAlg.isEmpty()) {
            keyManagementAlg = DEFAULT_KEY_MANAGEMENT_ALGORITHM;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Null or empty key management algorithm provided; defaulting to " + keyManagementAlg), (Object[])new Object[0]);
            }
        }
        if (contentEncryptionAlg == null || contentEncryptionAlg.isEmpty()) {
            contentEncryptionAlg = DEFAULT_CONTENT_ENCRYPTION_ALGORITHM;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Null or empty content encryption algorithm provided; defaulting to " + contentEncryptionAlg), (Object[])new Object[0]);
            }
        }
        this.keyManagementAlg = keyManagementAlg;
        this.keyManagementKey = keyManagementKey;
        this.contentEncryptionAlg = contentEncryptionAlg;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Builder claim(String name, Object value) throws InvalidClaimException {
        if (!this.isValidClaim(name, value)) return this;
        if (name.equals("aud")) {
            if (value instanceof ArrayList) {
                this.audience((ArrayList)value);
                return this;
            }
            if (!(value instanceof String)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{"aud"});
                throw new InvalidClaimException(msg);
            }
            String[] auds = ((String)value).split(" ");
            ArrayList<String> audList = new ArrayList<String>();
            String[] stringArray = auds;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (audList.isEmpty()) return this;
                    this.audience(audList);
                    return this;
                }
                String aud = stringArray[n2];
                if (!aud.isEmpty()) {
                    audList.add(aud.trim());
                }
                ++n2;
            }
        }
        if (name.equals("exp")) {
            if (value instanceof Long) {
                this.expirationTime((Long)value);
                return this;
            }
            if (value instanceof Integer) {
                this.expirationTime(((Integer)value).longValue());
                return this;
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{"exp"});
            throw new InvalidClaimException(msg);
        }
        if (name.equals("iat")) {
            if (value instanceof Long) {
                this.issueTime((Long)value);
                return this;
            }
            if (value instanceof Integer) {
                this.expirationTime(((Integer)value).longValue());
                return this;
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{"iat"});
            throw new InvalidClaimException(msg);
        }
        if (name.equals("nbf")) {
            if (value instanceof Long) {
                this.notBefore((Long)value);
                return this;
            }
            if (value instanceof Integer) {
                this.expirationTime(((Integer)value).longValue());
                return this;
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{"nbf"});
            throw new InvalidClaimException(msg);
        }
        if (!name.equals("iss") && !name.equals("sub")) {
            this.claims.put(name, value);
            return this;
        }
        if (!(value instanceof String)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{name});
            throw new InvalidClaimException(msg);
        }
        if (name.equals("iss")) {
            this.issuer((String)value);
            return this;
        }
        this.subject((String)value);
        return this;
    }

    @Override
    public Builder claim(Map<String, Object> map) throws InvalidClaimException {
        if (map == null) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIMS_ERR", (Object[])new Object[0]);
            throw new InvalidClaimException(err);
        }
        return this.copyClaimsMap(map);
    }

    @Override
    public Builder fetch(String name) throws InvalidClaimException {
        if (JwtUtils.isNullEmpty(name)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{name});
            throw new InvalidClaimException(err);
        }
        String sub = this.claims.getSubject();
        if (!JwtUtils.isNullEmpty(sub)) {
            Object obj = null;
            try {
                obj = JwtUtils.fetch(name, sub);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.BuilderImpl", (String)"668", (Object)this, (Object[])new Object[]{name});
            }
            if (obj != null) {
                this.claims.put(name, obj);
            }
        }
        return this;
    }

    @Override
    public Builder remove(String name) throws InvalidClaimException {
        if (JwtUtils.isNullEmpty(name)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{name});
            throw new InvalidClaimException(err);
        }
        this.claims.remove(name);
        return this;
    }

    @Override
    public Builder claimFrom(String jsonOrJwt, String claim) throws InvalidClaimException, InvalidTokenException {
        if (JwtUtils.isNullEmpty(claim)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{claim});
            throw new InvalidClaimException(err);
        }
        if (this.isValidToken(jsonOrJwt)) {
            boolean isJson;
            String decoded = jsonOrJwt;
            if (JwtUtils.isBase64Encoded(jsonOrJwt)) {
                decoded = JwtUtils.decodeFromBase64String(jsonOrJwt);
            }
            if (!(isJson = JwtUtils.isJson(decoded))) {
                String jwtPayload = JwtUtils.getPayload(jsonOrJwt);
                decoded = JwtUtils.decodeFromBase64String(jwtPayload);
            }
            if (decoded != null) {
                Object claimValue = null;
                try {
                    claimValue = JwtUtils.claimFromJsonObject(decoded, claim);
                    if (claimValue != null) {
                        this.claims.put(claim, claimValue);
                    }
                }
                catch (JoseException joseException) {
                    FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.jwt.internal.BuilderImpl", (String)"735", (Object)this, (Object[])new Object[]{jsonOrJwt, claim});
                    String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
                    throw new InvalidTokenException(err);
                }
            }
        }
        return this;
    }

    @Override
    public Builder claimFrom(String jsonOrJwt) throws InvalidTokenException {
        boolean isJson;
        this.isValidToken(jsonOrJwt);
        String decoded = jsonOrJwt;
        if (JwtUtils.isBase64Encoded(jsonOrJwt)) {
            decoded = JwtUtils.decodeFromBase64String(jsonOrJwt);
        }
        if (!(isJson = JwtUtils.isJson(decoded))) {
            String jwtPayload = JwtUtils.getPayload(jsonOrJwt);
            decoded = JwtUtils.decodeFromBase64String(jwtPayload);
        }
        if (decoded != null) {
            Map claimsFromAnother = null;
            try {
                claimsFromAnother = JwtUtils.claimsFromJsonObject(decoded);
            }
            catch (JoseException joseException) {
                FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.jwt.internal.BuilderImpl", (String)"784", (Object)this, (Object[])new Object[]{jsonOrJwt});
                String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
                throw new InvalidTokenException(err);
            }
            if (claimsFromAnother != null && !claimsFromAnother.isEmpty()) {
                this.claims.putAll(claimsFromAnother);
            }
        }
        return this;
    }

    @Override
    public Builder claimFrom(JwtToken jwt, String claimName) throws InvalidClaimException, InvalidTokenException {
        this.isValidToken(jwt);
        if (JwtUtils.isNullEmpty(claimName)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{claimName});
            throw new InvalidClaimException(err);
        }
        if (jwt.getClaims().get(claimName) != null) {
            this.claims.put(claimName, jwt.getClaims().get(claimName));
        }
        return this;
    }

    @Override
    public Builder claimFrom(JwtToken jwt) throws InvalidTokenException {
        if (jwt == null || jwt.getClaims().isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
            throw new InvalidTokenException(err);
        }
        this.claims.putAll(jwt.getClaims());
        return this;
    }

    @Override
    public JwtToken buildJwt() throws JwtException, InvalidBuilderException {
        JwtConfig config = this.getConfig(this.configId);
        TokenImpl jwt = new TokenImpl(this, config);
        return jwt;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public Key getKey() {
        return this.privateKey;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public String getAlgorithm() {
        return this.alg;
    }

    public String getKeyManagementAlg() {
        return this.keyManagementAlg;
    }

    public Key getKeyManagementKey() {
        return this.keyManagementKey;
    }

    public String getContentEncryptionAlg() {
        return this.contentEncryptionAlg;
    }

    private boolean isValidClaim(String key, Object value) throws InvalidClaimException {
        String err = null;
        if (JwtUtils.isNullEmpty(key)) {
            err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{key});
            throw new InvalidClaimException(err);
        }
        if (value == null) {
            err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{key, "null"});
            throw new InvalidClaimException(err);
        }
        return true;
    }

    private boolean isValidToken(String tokenString) throws InvalidTokenException {
        String err = null;
        if (JwtUtils.isNullEmpty(tokenString)) {
            err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
            throw new InvalidTokenException(err);
        }
        return true;
    }

    private boolean isValidToken(JwtToken jwt) throws InvalidTokenException {
        String err = null;
        if (jwt == null) {
            err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
            throw new InvalidTokenException(err);
        }
        return true;
    }

    private Builder copyClaimsMap(Map<String, Object> map) throws InvalidClaimException {
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Builder Claims Key : " + key + ", Value: " + value), (Object[])new Object[0]);
            }
            this.claim(key, value);
        }
        return this;
    }

    private void checkAmrAttrInSubject(List<String> amrAttr) throws Exception {
        Subject subj = WSSubject.getRunAsSubject();
        ArrayList<Object> amrValues = new ArrayList<Object>();
        if (subj != null) {
            WSCredential wscred = this.getWSCredential(subj);
            for (String attr : amrAttr) {
                Object subjValue = wscred != null ? wscred.get(attr) : null;
                if (subjValue == null) continue;
                amrValues.add(subjValue);
            }
        }
        if (amrValues.size() > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Builder Claims Key: amr: [" + amrValues + "]"), (Object[])new Object[0]);
            }
            this.claims.put("amr", amrValues);
        }
    }

    private WSCredential getWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }
}

