/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CompletionKey {
    private static final TraceComponent tc = Tr.register(CompletionKey.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private static final int CHANNEL_ID_INDEX = 0;
    private static final int CALL_ID_INDEX = 1;
    private static final int RETURN_CODE_INDEX = 2;
    private static final int BYTES_AFFECTED_INDEX = 3;
    private static final int NATIVE_STRUCTURE_INDEX = 4;
    private static final int JIT_BUFFER_USED = 4;
    private static final int RETURN_STATUS_INDEX = 5;
    private static final int FIRST_BUFFER_INDEX = 6;
    private WsByteBuffer wsByteBuf;
    private ByteBuffer rawData;
    private LocalByteBuffer stagingByteBuffer;
    private int bufferCount = 0;
    private long channelIdentifier;
    private long callIdentifier;

    CompletionKey() {
        this(0L, 0L, 1);
    }

    public CompletionKey(long channelIdentifier, long callIdentifier, int bufferCount) {
        if (bufferCount < 1) {
            throw new IllegalArgumentException("Buffer count cannot be < 0 !");
        }
        int bufferLength = 8 * (6 + bufferCount * 2);
        this.getNewDirectByteBuffer(bufferLength);
        this.stagingByteBuffer.putLong(0, channelIdentifier);
        this.stagingByteBuffer.putLong(8, callIdentifier);
        this.stagingByteBuffer.putLong(24, -1L);
        this.stagingByteBuffer.putLong(16, 0L);
        this.stagingByteBuffer.putLong(32, 0L);
        this.stagingByteBuffer.putLong(40, 0L);
        this.stagingByteBuffer.putLong(48, 0L);
        this.stagingByteBuffer.putLong(56, 0L);
        this.channelIdentifier = channelIdentifier;
        this.callIdentifier = callIdentifier;
        this.bufferCount = bufferCount;
    }

    protected void getNewDirectByteBuffer(int bufferLength) {
        WsByteBufferPoolManager wsByteBufferManager = ChannelFrameworkFactory.getBufferManager();
        if (this.rawData != null) {
            if (this.wsByteBuf != null) {
                this.wsByteBuf.release();
                this.wsByteBuf = null;
            }
            this.rawData = null;
            this.stagingByteBuffer = null;
        }
        this.wsByteBuf = wsByteBufferManager.allocateDirect(bufferLength);
        this.rawData = this.wsByteBuf.getWrappedByteBufferNonSafe();
        this.rawData.order(ByteOrder.nativeOrder());
        this.stagingByteBuffer = new LocalByteBuffer(bufferLength);
    }

    protected void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CompletionKey::destroy entered for:" + this), (Object[])new Object[0]);
        }
        if (this.rawData != null) {
            if (this.wsByteBuf != null) {
                this.wsByteBuf.release();
                this.wsByteBuf = null;
            }
            this.rawData = null;
            this.stagingByteBuffer = null;
        }
    }

    public long getAddress() {
        return AbstractAsyncChannel.getBufAddress(this.rawData);
    }

    public void setBuffer(long address, long length, int index) {
        if (index < 0 || index >= this.bufferCount) {
            throw new IllegalArgumentException();
        }
        this.stagingByteBuffer.putLong((6 + 2 * index) * 8, address);
        this.stagingByteBuffer.putLong((6 + 2 * index + 1) * 8, length);
    }

    public int getBufferCount() {
        return this.bufferCount;
    }

    public long getBytesAffected() {
        return this.stagingByteBuffer.getLong(24);
    }

    public void setBytesAffected(int count) {
        this.stagingByteBuffer.putLong(24, count);
    }

    public long getCallIdentifier() {
        return this.stagingByteBuffer.getLong(8);
    }

    public void setCallIdentifier(long callid) {
        this.callIdentifier = callid;
        this.stagingByteBuffer.putLong(8, callid);
    }

    public long getChannelIdentifier() {
        return this.stagingByteBuffer.getLong(0);
    }

    public long getReturnStatus() {
        return this.stagingByteBuffer.getLong(40);
    }

    public void setReturnStatus(int status) {
        this.stagingByteBuffer.putLong(40, status);
    }

    public int getReturnCode() {
        long returnCode = this.stagingByteBuffer.getLong(16);
        if (returnCode > Integer.MAX_VALUE) {
            AsyncException ae = new AsyncException("Return code value invalid");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid value returned for return code, exception: " + ae.getMessage()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)ae, (String)this.getClass().getName(), (String)"227", (Object)this);
            return Integer.MAX_VALUE;
        }
        return (int)returnCode;
    }

    public void setJITBufferUsed() {
        this.stagingByteBuffer.putLong(32, 1L);
    }

    public boolean wasJITBufferUsed() {
        return 1L == this.stagingByteBuffer.getLong(32);
    }

    public void setReturnCode(int rc) {
        this.stagingByteBuffer.putLong(16, rc);
    }

    protected void expandBuffers(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Buffer count cannot be < 0 !");
        }
        int bufferLength = 8 * (6 + count * 2);
        long nativeStruct = this.stagingByteBuffer.getLong(32);
        this.getNewDirectByteBuffer(bufferLength);
        this.stagingByteBuffer.putLong(0, this.channelIdentifier);
        this.stagingByteBuffer.putLong(8, this.callIdentifier);
        this.stagingByteBuffer.putLong(24, -1L);
        this.stagingByteBuffer.putLong(16, 0L);
        this.stagingByteBuffer.putLong(32, nativeStruct);
        this.stagingByteBuffer.putLong(40, 0L);
        this.bufferCount = count;
    }

    protected void reset() {
        this.stagingByteBuffer.putLong(24, -1L);
        this.stagingByteBuffer.putLong(16, 0L);
        this.stagingByteBuffer.putLong(32, 0L);
        this.stagingByteBuffer.putLong(40, 0L);
    }

    protected void initializePoolEntry(long _channelIdentifier, long _callIdentifier) {
        this.stagingByteBuffer.putLong(0, _channelIdentifier);
        this.stagingByteBuffer.putLong(8, _callIdentifier);
        this.stagingByteBuffer.putLong(24, -1L);
        this.stagingByteBuffer.putLong(16, 0L);
        this.stagingByteBuffer.putLong(32, 0L);
        this.stagingByteBuffer.putLong(40, 0L);
        this.stagingByteBuffer.putLong(48, 0L);
        this.stagingByteBuffer.putLong(56, 0L);
        this.channelIdentifier = _channelIdentifier;
        this.callIdentifier = _callIdentifier;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.getClass().getName());
        buffer.append("[channel id=").append(Long.toHexString(this.getChannelIdentifier()));
        buffer.append(", call id=").append(Long.toHexString(this.getCallIdentifier()));
        buffer.append(", wsByteBuf native addr=").append(Long.toHexString(this.getAddress()));
        buffer.append(", rc=").append(this.getReturnCode());
        buffer.append(", bytes=").append(this.getBytesAffected());
        buffer.append(", JIT Buffer used=").append(this.wasJITBufferUsed());
        buffer.append(", Native address/JIT used=").append(Long.toHexString(this.stagingByteBuffer.getLong(32)));
        buffer.append(", return status=").append(Long.toHexString(this.getReturnStatus()));
        buffer.append(", 1st Buff address=").append(Long.toHexString(this.stagingByteBuffer.getLong(48)));
        buffer.append(", 1st Buff len=").append(Long.toHexString(this.stagingByteBuffer.getLong(56)));
        buffer.append("]\n");
        return buffer.toString();
    }

    protected void postNativePrep() {
        this.rawData.position(0);
        this.rawData.get(this.stagingByteBuffer.data);
    }

    protected void preNativePrep() {
        this.rawData.clear();
        this.rawData.put(this.stagingByteBuffer.data);
    }

    @Trivial
    private static final class LocalByteBuffer {
        private byte[] data = null;

        LocalByteBuffer(int size) {
            this.data = new byte[size];
        }

        long getLong(int index) {
            return ((long)(this.data[index + 7] & 0xFF) << 0) + ((long)(this.data[index + 6] & 0xFF) << 8) + ((long)(this.data[index + 5] & 0xFF) << 16) + ((long)(this.data[index + 4] & 0xFF) << 24) + ((long)(this.data[index + 3] & 0xFF) << 32) + ((long)(this.data[index + 2] & 0xFF) << 40) + ((long)(this.data[index + 1] & 0xFF) << 48) + ((long)this.data[index + 0] << 56);
        }

        void putLong(int index, long value) {
            this.data[index + 7] = (byte)(value >>> 0);
            this.data[index + 6] = (byte)(value >>> 8);
            this.data[index + 5] = (byte)(value >>> 16);
            this.data[index + 4] = (byte)(value >>> 24);
            this.data[index + 3] = (byte)(value >>> 32);
            this.data[index + 2] = (byte)(value >>> 40);
            this.data[index + 1] = (byte)(value >>> 48);
            this.data[index + 0] = (byte)(value >>> 56);
        }
    }
}

