/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.util.ByteArray;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSAuthenticationData
implements AuthenticationData {
    private final HashMap<String, Object> credentialsMap = new HashMap();
    private int hash = -1;
    static final long serialVersionUID = 1167868542153630158L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public void set(String key, @Sensitive Object value) {
        Object tempValue = value;
        if (this.isSensitive(key)) {
            if (value == null) {
                tempValue = ProtectedString.NULL_PROTECTED_STRING;
            } else if (value instanceof String) {
                tempValue = ((String)value).isEmpty() ? ProtectedString.EMPTY_PROTECTED_STRING : new ProtectedString(((String)value).toCharArray());
            } else if (value instanceof char[]) {
                tempValue = new ProtectedString((char[])value);
            } else if (value instanceof ProtectedString) {
                tempValue = value;
            } else {
                throw new IllegalArgumentException("Setting a password into WSAuthenticationData expects the stored Object to be either a String, char[] or ProtectedString. Instead, stored Object was of type " + value.getClass().getName());
            }
        }
        if (value instanceof byte[]) {
            tempValue = new ByteArray((byte[])value);
        }
        this.credentialsMap.put(key, tempValue);
        this.hash = -1;
    }

    @Override
    @Sensitive
    public Object get(String key) {
        Object retrievedValue = this.credentialsMap.get(key);
        if (retrievedValue != null && this.isSensitive(key)) {
            retrievedValue = ((ProtectedString)retrievedValue).getChars();
        }
        if (retrievedValue instanceof ByteArray) {
            retrievedValue = ((ByteArray)retrievedValue).getArray();
        }
        return retrievedValue;
    }

    protected boolean isSensitive(String key) {
        return "PASSWORD".equals(key);
    }

    public String toString() {
        return this.credentialsMap.toString();
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof WSAuthenticationData)) {
            return false;
        }
        return this.credentialsMap.equals(((WSAuthenticationData)otherObject).credentialsMap);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.credentialsMap.hashCode();
        }
        return this.hash;
    }

    @Override
    public boolean isEmpty() {
        return this.credentialsMap.isEmpty();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.WSAuthenticationData", WSAuthenticationData.class, null, null);
    }
}

