/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.UnaryOperator;

public class CopyUtils {
    public static <T> List<T> copyCollection(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> copyCollection(Collection<T> collection, UnaryOperator<T> clone) {
        if (collection == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (T element : collection) {
            result.add(clone.apply(element));
        }
        return result;
    }

    public static Date copyDate(Date date) {
        if (date == null) {
            return null;
        }
        return (Date)date.clone();
    }

    public static Calendar copyCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return (Calendar)calendar.clone();
    }

    public static <T> T copyObject(T object, UnaryOperator<T> copyConstructor) {
        if (object == null) {
            return null;
        }
        return (T)copyConstructor.apply(object);
    }
}

