/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.net.InetAddress;
import javax.net.ssl.SSLException;

class SSLHandshakeErrorTracker {
    private static final TraceComponent tc = Tr.register(SSLHandshakeErrorTracker.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private final boolean shouldLogError;
    private final long maxLogEntries;
    private long numberOfLogEntries = 0L;
    private boolean loggingStopped = false;

    SSLHandshakeErrorTracker(boolean shouldLogError, long maxLogEntries) {
        this.shouldLogError = shouldLogError;
        this.maxLogEntries = maxLogEntries;
    }

    void noteHandshakeError(Exception failure, InetAddress localAddr, int localPort, InetAddress remoteAddr, int remotePort) {
        ++this.numberOfLogEntries;
        Exception ssle = failure;
        if (failure.getMessage().contains("plaintext connection?")) {
            ssle = new SSLException("The WebSphere server received an unencrypted inbound communication on a secure connection.  This does not indicate a problem with the WebSphere server. To resolve the issue, configure the client to use SSL or to connect to a port on the WebSphere server that does not require SSL.", failure.getCause());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("noteHandshakeError (" + this.numberOfLogEntries + "): " + ssle.getMessage()), (Object[])new Object[]{ssle});
        }
        if (this.shouldLogError) {
            if (this.numberOfLogEntries <= this.maxLogEntries) {
                Tr.error((TraceComponent)tc, (String)"handshake.failure", (Object[])new Object[]{ssle, remoteAddr.getHostAddress(), remotePort, localAddr.getHostAddress(), localPort});
            } else if (!this.loggingStopped && this.numberOfLogEntries > this.maxLogEntries) {
                this.loggingStopped = true;
                Tr.info((TraceComponent)tc, (String)"handshake.failure.stop.logging", (Object[])new Object[0]);
            }
        }
    }
}

