/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.session.utils.LoggingUtil;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.servlet.SessionCookieConfig;

public class SessionCookieConfigImpl
implements SessionCookieConfig,
Cloneable {
    private static final String methodClassName = "SessionCookieConfigImpl";
    protected String comment = null;
    private boolean maxAgeSet = false;
    protected String name = null;
    private boolean httpOnlySet = false;
    private boolean secureSet = false;
    protected boolean contextInitialized = false;
    protected boolean programmaticChange = false;
    protected static final boolean EXTERNALCALL = true;
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String PATH = "Path";
    private static final String SECURE = "Secure";
    private static final String HTTPONLY = "HttpOnly";
    protected Map<String, String> attributes = null;
    private static TraceNLS nls = TraceNLS.getTraceNLS(SessionCookieConfigImpl.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public SessionCookieConfigImpl() {
        this(null, null, null, null, -1, true, false);
    }

    public SessionCookieConfigImpl(String name, String domain, String path, String comment, int maxAge, boolean httpOnly, boolean secure) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl Constructor , cookie name [" + name + "]");
        }
        this.name = name;
        this.comment = comment;
        this.putAttribute(DOMAIN, domain);
        this.putAttribute(PATH, path);
        this.putAttribute(MAX_AGE, String.valueOf(maxAge));
        this.putAttribute(HTTPONLY, String.valueOf(httpOnly));
        this.putAttribute(SECURE, String.valueOf(secure));
    }

    protected String getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    protected Map<String, String> getAttributes() {
        return this.attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.attributes);
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomain() {
        return this.getAttribute(DOMAIN);
    }

    public int getMaxAge() {
        String maxAge = this.getAttribute(MAX_AGE);
        return maxAge == null ? -1 : Integer.parseInt(maxAge);
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl getName returns [" + this.name + "] , this [{0}]", this);
        }
        return this.name;
    }

    public String getPath() {
        return this.getAttribute(PATH);
    }

    public boolean isHttpOnly() {
        return Boolean.parseBoolean(this.getAttribute(HTTPONLY));
    }

    public boolean isSecure() {
        return Boolean.parseBoolean(this.getAttribute(SECURE));
    }

    protected void putAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        if (value == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl putAttribute value is null, remove name [" + name + "] , this [{0}]", this);
            }
            this.attributes.remove(name);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl putAttribute name [" + name + "] , value [" + value + "] , this [{0}]", this);
            }
            this.attributes.put(name, value);
        }
    }

    public void setComment(String c) {
        this.setComment(c, true);
    }

    public void setDomain(String d) {
        this.setDomain(d, true);
    }

    public void setHttpOnly(boolean b) {
        this.setHttpOnly(b, true);
    }

    public void setMaxAge(int m) {
        this.setMaxAge(m, true);
    }

    public void setName(String n) {
        this.setName(n, true);
    }

    public void setPath(String p) {
        this.setPath(p, true);
    }

    public void setSecure(boolean b) {
        this.setSecure(b, true);
    }

    public boolean isMaxAgeSet() {
        return this.maxAgeSet;
    }

    public boolean isHttpOnlySet() {
        return this.httpOnlySet;
    }

    public boolean isSecureSet() {
        return this.secureSet;
    }

    public void setContextInitialized() {
        this.contextInitialized = true;
    }

    public void setComment(String c, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.comment = c;
    }

    public void setDomain(String d, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.putAttribute(DOMAIN, d != null ? d : null);
    }

    public void setHttpOnly(boolean b, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.putAttribute(HTTPONLY, String.valueOf(b));
        this.httpOnlySet = true;
    }

    public void setMaxAge(int m, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.putAttribute(MAX_AGE, String.valueOf(m));
        this.maxAgeSet = true;
    }

    public void setName(String n, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl setName [" + n + "] , this [{0}]", this);
        }
        this.name = n;
    }

    public void setPath(String p, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.putAttribute(PATH, p);
    }

    public void setSecure(boolean b, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.putAttribute(SECURE, String.valueOf(b));
        this.secureSet = true;
    }

    public SessionCookieConfig clone() throws CloneNotSupportedException {
        SessionCookieConfigImpl temp = new SessionCookieConfigImpl(this.getName(), this.getDomain(), this.getPath(), this.comment, this.getMaxAge(), this.isHttpOnly(), this.isSecure());
        temp.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        temp.attributes.putAll(this.attributes);
        return temp;
    }

    protected void throwWarning() {
        String msg = nls.getString("programmatic.sessions.already.been.initialized");
        throw new IllegalStateException(msg);
    }

    public boolean isProgrammaticChange() {
        return this.programmaticChange;
    }
}

