/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.common.jwt.jws;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.common.jwt.exceptions.JwtContextMissingJoseObjects;
import io.openliberty.security.common.jwt.exceptions.SignatureAlgorithmNotInAllowedList;
import io.openliberty.security.common.jwt.exceptions.SigningKeyNotSpecifiedException;
import java.security.Key;
import java.util.Arrays;
import java.util.List;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwsSignatureVerifier {
    private static final TraceComponent tc = Tr.register(JwsSignatureVerifier.class, null, null);
    private final Key key;
    private final String signatureAlgorithm;
    private final List<String> signatureAlgorithmsSupported;
    static final long serialVersionUID = -2371047077102890785L;

    private JwsSignatureVerifier(Builder builder) {
        this.key = builder.key;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.signatureAlgorithmsSupported = builder.signatureAlgorithmsSupported;
    }

    public List<String> getSignatureAlgorithmsSupported() {
        if (this.signatureAlgorithm != null) {
            return Arrays.asList(this.signatureAlgorithm);
        }
        if (this.signatureAlgorithmsSupported != null) {
            return this.signatureAlgorithmsSupported;
        }
        return Arrays.asList("RS256");
    }

    public static String verifyJwsAlgHeaderOnly(JwtContext jwtContext, List<String> signingAlgorithmsAllowed) throws JwtContextMissingJoseObjects, SignatureAlgorithmNotInAllowedList {
        JsonWebSignature jws = (JsonWebSignature)JwtParsingUtils.getJsonWebStructureFromJwtContext(jwtContext);
        String algHeader = jws.getAlgorithmHeaderValue();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Signing algorithm from header: " + algHeader), (Object[])new Object[0]);
        }
        if (!signingAlgorithmsAllowed.contains(algHeader)) {
            throw new SignatureAlgorithmNotInAllowedList(algHeader, signingAlgorithmsAllowed);
        }
        return algHeader;
    }

    public JwtClaims validateJwsSignature(JwtContext jwtContext) throws JwtContextMissingJoseObjects, SignatureAlgorithmNotInAllowedList, SigningKeyNotSpecifiedException, InvalidJwtException {
        String algHeader = JwsSignatureVerifier.verifyJwsAlgHeaderOnly(jwtContext, this.getSignatureAlgorithmsSupported());
        JwtConsumerBuilder builder = this.createJwtConsumerBuilderWithConstraints(algHeader);
        JwtConsumer jwtConsumer = builder.build();
        JwtContext validatedJwtContext = jwtConsumer.process(jwtContext.getJwt());
        return validatedJwtContext.getJwtClaims();
    }

    public JwtConsumerBuilder createJwtConsumerBuilderWithConstraints(String algHeader) throws SigningKeyNotSpecifiedException {
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        this.setJwsAlgorithmConstraints(builder);
        builder.setSkipDefaultAudienceValidation();
        if ("none".equals(algHeader)) {
            builder.setDisableRequireSignature().setSkipSignatureVerification();
        } else {
            if (this.key == null) {
                throw new SigningKeyNotSpecifiedException(algHeader);
            }
            builder.setVerificationKey(this.key).setRelaxVerificationKeyValidation();
        }
        return builder;
    }

    private void setJwsAlgorithmConstraints(JwtConsumerBuilder builder) {
        List<String> signatureAlgorithmsSupported = this.getSignatureAlgorithmsSupported();
        String[] algsAsArray = signatureAlgorithmsSupported.toArray(new String[signatureAlgorithmsSupported.size()]);
        builder.setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, algsAsArray));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Builder {
        private Key key = null;
        private String signatureAlgorithm = null;
        private List<String> signatureAlgorithmsSupported = null;
        static final long serialVersionUID = 6951115412487941774L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public Builder signatureAlgorithmsSupported(String ... signatureAlgorithmsSupported) {
            this.signatureAlgorithmsSupported = Arrays.asList(signatureAlgorithmsSupported);
            return this;
        }

        public JwsSignatureVerifier build() {
            return new JwsSignatureVerifier(this);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.jwt.jws.JwsSignatureVerifier$Builder", Builder.class, null, null);
        }
    }
}

