/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.ext.DefaultMethod;
import org.apache.cxf.jaxrs.ext.xml.ElementClass;
import org.apache.cxf.jaxrs.ext.xml.XMLName;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ResourceTypes;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.model.UserOperation;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class ResourceUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ResourceUtils.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String NOT_RESOURCE_METHOD_MESSAGE_ID = "NOT_RESOURCE_METHOD";
    private static final String NOT_SUSPENDED_ASYNC_MESSAGE_ID = "NOT_SUSPENDED_ASYNC_METHOD";
    private static final String NO_VOID_RETURN_ASYNC_MESSAGE_ID = "NO_VOID_RETURN_ASYNC_METHOD";
    private static final Set<String> SERVER_PROVIDER_CLASS_NAMES = new HashSet<String>();
    static final long serialVersionUID = 715176357862263079L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ResourceUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Method findPostConstructMethod(Class<?> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", new Object[]{c});
        }
        Method method = ResourceUtils.findPostConstructMethod(c, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Method findPostConstructMethod(final Class<?> c, String name) {
        Method[] methods;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", new Object[]{c, name});
        }
        if (Object.class == c || null == c) {
            Method method = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", method);
            }
            return method;
        }
        for (Method m : methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){
            static final long serialVersionUID = 8103132506568451477L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Method[] run() {
                return ReflectionUtil.getDeclaredMethods(c);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.ResourceUtils$1", 1.class, null, null);
            }
        })) {
            if (name != null) {
                if (!m.getName().equals(name)) continue;
                Method method = ReflectionUtil.setAccessible(m);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    method = method;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", method);
                }
                return method;
            }
            if (m.getAnnotation(PostConstruct.class) == null) continue;
            Method method = ReflectionUtil.setAccessible(m);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", method);
            }
            return method;
        }
        Method m = ResourceUtils.findPostConstructMethod(c.getSuperclass(), name);
        if (m != null) {
            Method method = ReflectionUtil.setAccessible(m);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", method);
            }
            return method;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPostConstructMethod(i, name);
            if (m == null) continue;
            Method method = ReflectionUtil.setAccessible(m);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", method);
            }
            return method;
        }
        Method method = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPostConstructMethod", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Method findPreDestroyMethod(Class<?> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", new Object[]{c});
        }
        Method method = ResourceUtils.findPreDestroyMethod(c, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Method findPreDestroyMethod(Class<?> c, String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", new Object[]{c, name});
        }
        if (Object.class == c || null == c) {
            Method method = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", method);
            }
            return method;
        }
        for (Method m : ReflectionUtil.getDeclaredMethods(c)) {
            if (name != null) {
                if (!m.getName().equals(name)) continue;
                Method method = ReflectionUtil.setAccessible(m);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    method = method;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", method);
                }
                return method;
            }
            if (m.getAnnotation(PreDestroy.class) == null) continue;
            Method method = ReflectionUtil.setAccessible(m);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", method);
            }
            return method;
        }
        Method m = ResourceUtils.findPreDestroyMethod(c.getSuperclass(), name);
        if (m != null) {
            Method method = ReflectionUtil.setAccessible(m);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", method);
            }
            return method;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPreDestroyMethod(i, name);
            if (m == null) continue;
            Method method = ReflectionUtil.setAccessible(m);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                method = method;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", method);
            }
            return method;
        }
        Method method = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findPreDestroyMethod", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ClassResourceInfo createClassResourceInfo(Map<String, UserResource> resources, UserResource model, Class<?> defaultClass, boolean isRoot, boolean enableStatic, Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createClassResourceInfo", new Object[]{resources, model, defaultClass, isRoot, enableStatic, bus});
        }
        boolean isDefaultClass = defaultClass != null;
        Class<?> sClass = !isDefaultClass ? ResourceUtils.loadClass(model.getName()) : defaultClass;
        ClassResourceInfo classResourceInfo = ResourceUtils.createServiceClassResourceInfo(resources, model, sClass, isRoot, enableStatic, bus);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classResourceInfo = classResourceInfo;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createClassResourceInfo", classResourceInfo);
        }
        return classResourceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ClassResourceInfo createServiceClassResourceInfo(Map<String, UserResource> resources, UserResource model, Class<?> sClass, boolean isRoot, boolean enableStatic, Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createServiceClassResourceInfo", new Object[]{resources, model, sClass, isRoot, enableStatic, bus});
        }
        if (model == null) {
            throw new RuntimeException("Resource class " + sClass.getName() + " has no model info");
        }
        ClassResourceInfo cri = new ClassResourceInfo(sClass, sClass, isRoot, enableStatic, true, model.getConsumes(), model.getProduces(), bus);
        String classNameandPath = ResourceUtils.getClassNameandPath(cri.getResourceClass().getName(), model.getPath());
        URITemplate t = URITemplate.createTemplate(model.getPath(), classNameandPath);
        cri.setURITemplate(t);
        MethodDispatcher md = new MethodDispatcher();
        Map<String, UserOperation> ops = model.getOperationsAsMap();
        Method defaultMethod = null;
        HashMap<String, Method> methodNames = new HashMap<String, Method>();
        for (Method m : cri.getServiceClass().getMethods()) {
            if (m.getAnnotation(DefaultMethod.class) != null) {
                defaultMethod = m;
            }
            methodNames.put(m.getName(), m);
        }
        for (Map.Entry entry : ops.entrySet()) {
            UserOperation op = (UserOperation)entry.getValue();
            Method actualMethod = (Method)methodNames.get(op.getName());
            if (actualMethod == null) {
                actualMethod = defaultMethod;
            }
            if (actualMethod == null) continue;
            String classNameandPath2 = ResourceUtils.getClassNameandPath(cri.getResourceClass().getName(), op.getName());
            URITemplate t2 = URITemplate.createTemplate(op.getName(), classNameandPath2);
            OperationResourceInfo ori = new OperationResourceInfo(actualMethod, cri, t2, op.getVerb(), op.getConsumes(), op.getProduces(), op.getParameters(), op.isOneway());
            String rClassName = actualMethod.getReturnType().getName();
            if (op.getVerb() == null) {
                ClassResourceInfo subCri;
                if (!resources.containsKey(rClassName) || (subCri = rClassName.equals(model.getName()) ? cri : ResourceUtils.createServiceClassResourceInfo(resources, resources.get(rClassName), actualMethod.getReturnType(), false, enableStatic, bus)) == null) continue;
                cri.addSubClassResourceInfo(subCri);
                md.bind(ori, actualMethod);
                continue;
            }
            md.bind(ori, actualMethod);
        }
        cri.setMethodDispatcher(md);
        ClassResourceInfo classResourceInfo = ResourceUtils.checkMethodDispatcher(cri) ? cri : null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classResourceInfo = classResourceInfo;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createServiceClassResourceInfo", classResourceInfo);
        }
        return classResourceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root, boolean enableStatic) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createClassResourceInfo", new Object[]{rClass, sClass, root, enableStatic});
        }
        ClassResourceInfo classResourceInfo = ResourceUtils.createClassResourceInfo(rClass, sClass, root, enableStatic, BusFactory.getThreadDefaultBus());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classResourceInfo = classResourceInfo;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createClassResourceInfo", classResourceInfo);
        }
        return classResourceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root, boolean enableStatic, Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createClassResourceInfo", new Object[]{rClass, sClass, root, enableStatic, bus});
        }
        ClassResourceInfo classResourceInfo = ResourceUtils.createClassResourceInfo(rClass, sClass, null, root, enableStatic, bus);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classResourceInfo = classResourceInfo;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createClassResourceInfo", classResourceInfo);
        }
        return classResourceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, ClassResourceInfo parent, boolean root, boolean enableStatic, Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createClassResourceInfo", new Object[]{rClass, sClass, parent, root, enableStatic, bus});
        }
        ClassResourceInfo cri = new ClassResourceInfo(rClass, sClass, root, enableStatic, bus);
        cri.setParent(parent);
        if (root) {
            String classNameandPath = ResourceUtils.getClassNameandPath(cri.getResourceClass().getName(), cri.getPath());
            URITemplate t = URITemplate.createTemplate(cri.getPath(), classNameandPath);
            cri.setURITemplate(t);
        }
        ResourceUtils.evaluateResourceClass(cri, enableStatic);
        ClassResourceInfo classResourceInfo = ResourceUtils.checkMethodDispatcher(cri) ? cri : null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classResourceInfo = classResourceInfo;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createClassResourceInfo", classResourceInfo);
        }
        return classResourceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void evaluateResourceClass(ClassResourceInfo cri, boolean enableStatic) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "evaluateResourceClass", new Object[]{cri, enableStatic});
        }
        MethodDispatcher md = new MethodDispatcher();
        Class<?> serviceClass = cri.getServiceClass();
        boolean isFineLevelLoggable = LOG.isLoggable(Level.FINE);
        for (Method m : serviceClass.getMethods()) {
            Method annotatedMethod = AnnotationUtils.getAnnotatedMethod(serviceClass, m);
            String httpMethod = AnnotationUtils.getHttpMethodValue(annotatedMethod);
            Path path = AnnotationUtils.getMethodAnnotation(annotatedMethod, Path.class);
            if (httpMethod != null || path != null) {
                if (!ResourceUtils.checkAsyncResponse(annotatedMethod)) continue;
                md.bind(ResourceUtils.createOperationInfo(m, annotatedMethod, cri, path, httpMethod), m);
                if (httpMethod != null) continue;
                Class<?> subClass = m.getReturnType();
                if (subClass == Class.class) {
                    subClass = InjectionUtils.getActualType(m.getGenericReturnType());
                }
                if (!enableStatic) continue;
                ClassResourceInfo subCri = cri.findResource(subClass, subClass);
                if (subCri == null) {
                    ClassResourceInfo ancestor = ResourceUtils.getAncestorWithSameServiceClass(cri, subClass);
                    ClassResourceInfo classResourceInfo = subCri = ancestor != null ? ancestor : ResourceUtils.createClassResourceInfo(subClass, subClass, cri, false, enableStatic, cri.getBus());
                }
                if (subCri == null) continue;
                cri.addSubClassResourceInfo(subCri);
                continue;
            }
            ResourceUtils.reportInvalidResourceMethod(m, NOT_RESOURCE_METHOD_MESSAGE_ID, Level.FINE);
        }
        cri.setMethodDispatcher(md);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "evaluateResourceClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void reportInvalidResourceMethod(Method m, String messageId, Level logLevel) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "reportInvalidResourceMethod", new Object[]{m, messageId, logLevel});
        }
        if (LOG.isLoggable(logLevel)) {
            LOG.log(logLevel, new org.apache.cxf.common.i18n.Message(messageId, BUNDLE, m.getDeclaringClass().getName(), m.getName()).toString());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "reportInvalidResourceMethod");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean checkAsyncResponse(Method m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkAsyncResponse", new Object[]{m});
        }
        Class<?>[] types = m.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != AsyncResponse.class) continue;
            if (AnnotationUtils.getAnnotation(m.getParameterAnnotations()[i], Suspended.class) == null) {
                ResourceUtils.reportInvalidResourceMethod(m, NOT_SUSPENDED_ASYNC_MESSAGE_ID, Level.FINE);
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkAsyncResponse", bl);
                }
                return bl;
            }
            if (m.getReturnType() == Void.TYPE || m.getReturnType() == Void.class) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkAsyncResponse", bl);
                }
                return bl;
            }
            ResourceUtils.reportInvalidResourceMethod(m, NO_VOID_RETURN_ASYNC_MESSAGE_ID, Level.WARNING);
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkAsyncResponse", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkAsyncResponse", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static ClassResourceInfo getAncestorWithSameServiceClass(ClassResourceInfo parent, Class<?> subClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAncestorWithSameServiceClass", new Object[]{parent, subClass});
        }
        if (parent == null) {
            ClassResourceInfo classResourceInfo = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                classResourceInfo = classResourceInfo;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAncestorWithSameServiceClass", classResourceInfo);
            }
            return classResourceInfo;
        }
        if (parent.getServiceClass() == subClass) {
            ClassResourceInfo classResourceInfo = parent;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                classResourceInfo = classResourceInfo;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAncestorWithSameServiceClass", classResourceInfo);
            }
            return classResourceInfo;
        }
        ClassResourceInfo classResourceInfo = ResourceUtils.getAncestorWithSameServiceClass(parent.getParent(), subClass);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classResourceInfo = classResourceInfo;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAncestorWithSameServiceClass", classResourceInfo);
        }
        return classResourceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Constructor<?> findResourceConstructor(Class<?> resourceClass, boolean perRequest) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "findResourceConstructor", new Object[]{resourceClass, perRequest});
        }
        LinkedList cs = new LinkedList();
        for (Constructor<?> c : resourceClass.getConstructors()) {
            Annotation[] anna = c.getDeclaredAnnotations();
            boolean hasInject = ResourceUtils.hasInjectAnnotation(anna);
            Class<?>[] params = c.getParameterTypes();
            Annotation[][] anns = c.getParameterAnnotations();
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if (!perRequest) {
                    if (AnnotationUtils.getAnnotation(anns[i], Context.class) != null || ResourceUtils.isInjectionPara(hasInject, anns[i])) continue;
                    match = false;
                    break;
                }
                if (AnnotationUtils.isValidParamAnnotations(anns[i]) || ResourceUtils.isInjectionPara(hasInject, anns[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            cs.add(c);
        }
        Collections.sort(cs, new Comparator<Constructor<?>>(){
            static final long serialVersionUID = -6087286648029871609L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(Constructor<?> c1, Constructor<?> c2) {
                int p2;
                int p1 = c1.getParameterTypes().length;
                return p1 > (p2 = c2.getParameterTypes().length) ? -1 : (p1 < p2 ? 1 : 0);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.ResourceUtils$2", 2.class, null, null);
            }
        });
        Constructor constructor = cs.size() == 0 ? null : (Constructor)cs.get(0);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            constructor = constructor;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "findResourceConstructor", constructor);
        }
        return constructor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isInjectionPara(boolean hasInject, Annotation[] anns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "isInjectionPara", new Object[]{hasInject, anns});
        }
        boolean bl = anns.length == 0 && hasInject;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isInjectionPara", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean hasInjectAnnotation(Annotation[] anna) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "hasInjectAnnotation", new Object[]{anna});
        }
        for (Annotation a : anna) {
            String annotationName = a.annotationType().getCanonicalName();
            if (!annotationName.equalsIgnoreCase("javax.inject.Inject")) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "hasInjectAnnotation", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "hasInjectAnnotation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static List<Parameter> getParameters(Method resourceMethod) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameters", new Object[]{resourceMethod});
        }
        Annotation[][] paramAnns = resourceMethod.getParameterAnnotations();
        if (paramAnns.length == 0) {
            List<Parameter> list = CastUtils.cast(Collections.emptyList(), Parameter.class);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameters", list);
            }
            return list;
        }
        Class<?>[] types = resourceMethod.getParameterTypes();
        ArrayList<Parameter> params = new ArrayList<Parameter>(paramAnns.length);
        for (int i = 0; i < paramAnns.length; ++i) {
            Parameter p = ResourceUtils.getParameter(i, paramAnns[i], types[i]);
            params.add(p);
        }
        ArrayList<Parameter> arrayList = params;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameters", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Parameter getParameter(int index, Annotation[] anns, Class<?> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", new Object[]{index, anns, type});
        }
        Context ctx = AnnotationUtils.getAnnotation(anns, Context.class);
        if (ctx != null) {
            Parameter parameter = new Parameter(ParameterType.CONTEXT, index, null);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
            }
            return parameter;
        }
        boolean isEncoded = AnnotationUtils.getAnnotation(anns, Encoded.class) != null;
        BeanParam bp = AnnotationUtils.getAnnotation(anns, BeanParam.class);
        if (bp != null) {
            Parameter parameter = new Parameter(ParameterType.BEAN, index, null, isEncoded, null);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
            }
            return parameter;
        }
        String dValue = AnnotationUtils.getDefaultParameterValue(anns);
        PathParam a = AnnotationUtils.getAnnotation(anns, PathParam.class);
        if (a != null) {
            Parameter p = new Parameter(ParameterType.PATH, index, a.value(), isEncoded, dValue);
            p.setJavaType(type);
            Parameter parameter = p;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
            }
            return parameter;
        }
        QueryParam q = AnnotationUtils.getAnnotation(anns, QueryParam.class);
        if (q != null) {
            Parameter parameter = new Parameter(ParameterType.QUERY, index, q.value(), isEncoded, dValue);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
            }
            return parameter;
        }
        MatrixParam m = AnnotationUtils.getAnnotation(anns, MatrixParam.class);
        if (m != null) {
            Parameter parameter = new Parameter(ParameterType.MATRIX, index, m.value(), isEncoded, dValue);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
            }
            return parameter;
        }
        FormParam f = AnnotationUtils.getAnnotation(anns, FormParam.class);
        if (f != null) {
            Parameter parameter = new Parameter(ParameterType.FORM, index, f.value(), isEncoded, dValue);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
            }
            return parameter;
        }
        HeaderParam h = AnnotationUtils.getAnnotation(anns, HeaderParam.class);
        if (h != null) {
            Parameter parameter = new Parameter(ParameterType.HEADER, index, h.value(), isEncoded, dValue);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
            }
            return parameter;
        }
        CookieParam c = AnnotationUtils.getAnnotation(anns, CookieParam.class);
        if (c != null) {
            Parameter parameter = new Parameter(ParameterType.COOKIE, index, c.value(), isEncoded, dValue);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameter = parameter;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
            }
            return parameter;
        }
        Parameter parameter = new Parameter(ParameterType.REQUEST_BODY, index, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            parameter = parameter;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getParameter", parameter);
        }
        return parameter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static OperationResourceInfo createOperationInfo(Method m, Method annotatedMethod, ClassResourceInfo cri, Path path, String httpMethod) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createOperationInfo", new Object[]{m, annotatedMethod, cri, path, httpMethod});
        }
        OperationResourceInfo ori = new OperationResourceInfo(m, annotatedMethod, cri);
        String classNameandPath = ResourceUtils.getClassNameandPath(cri.getResourceClass().getName(), path);
        URITemplate t = URITemplate.createTemplate(path, ori.getParameters(), classNameandPath);
        ori.setURITemplate(t);
        ori.setHttpMethod(httpMethod);
        OperationResourceInfo operationResourceInfo = ori;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            operationResourceInfo = operationResourceInfo;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createOperationInfo", operationResourceInfo);
        }
        return operationResourceInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getClassNameandPath(String className, Path path) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClassNameandPath", new Object[]{className, path});
        }
        if (path == null) {
            String string = ResourceUtils.getClassNameandPath(className, "/");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClassNameandPath", string);
            }
            return string;
        }
        String string = ResourceUtils.getClassNameandPath(className, path.value());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClassNameandPath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getClassNameandPath(String className, String pathValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClassNameandPath", new Object[]{className, pathValue});
        }
        int pathLength = pathValue == null ? 0 : pathValue.length();
        StringBuilder sb = new StringBuilder(className.length() + pathLength + 1);
        sb.append('/').append(className);
        if (pathLength == 0) {
            sb.append('/');
        } else {
            if (pathValue.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(pathValue);
        }
        String string = sb.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClassNameandPath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean checkMethodDispatcher(ClassResourceInfo cr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkMethodDispatcher", new Object[]{cr});
        }
        if (cr.getMethodDispatcher().getOperationResourceInfos().isEmpty()) {
            LOG.warning(new org.apache.cxf.common.i18n.Message("NO_RESOURCE_OP_EXC", BUNDLE, cr.getServiceClass().getName()).toString());
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkMethodDispatcher", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkMethodDispatcher", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Class<?> loadClass(String cName) {
        Class<?> clazz;
        block3: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "loadClass", new Object[]{cName});
            }
            try {
                clazz = ClassLoaderUtils.loadClass(cName.trim(), ResourceUtils.class);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block3;
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("No class " + cName.trim() + " can be found", ex);
            }
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "loadClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static List<UserResource> getUserResources(String loc, Bus bus) {
        List<UserResource> list;
        block7: {
            InputStream is;
            block5: {
                List<UserResource> list2;
                block6: {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getUserResources", new Object[]{loc, bus});
                    }
                    try {
                        is = ResourceUtils.getResourceStream(loc, bus);
                        if (is != null) break block5;
                        list2 = null;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
                    }
                    catch (Exception ex) {
                        LOG.warning("Problem with processing a user model at " + loc);
                        List<UserResource> list3 = null;
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            list3 = list3;
                            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getUserResources", list3);
                        }
                        return list3;
                    }
                    list2 = list2;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getUserResources", list2);
                }
                return list2;
            }
            list = ResourceUtils.getUserResources(is);
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getUserResources", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static InputStream getResourceStream(String loc, Bus bus) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResourceStream", new Object[]{loc, bus});
        }
        URL url = ResourceUtils.getResourceURL(loc, bus);
        InputStream inputStream = url == null ? null : url.openStream();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResourceStream", inputStream);
        }
        return inputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URL getResourceURL(final String loc, final Bus bus) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResourceURL", new Object[]{loc, bus});
        }
        URL url = null;
        if (loc.startsWith(CLASSPATH_PREFIX)) {
            String path = loc.substring(CLASSPATH_PREFIX.length());
            url = ResourceUtils.getClasspathResourceURL(path, ResourceUtils.class, bus);
        } else {
            try {
                url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){
                    static final long serialVersionUID = 6567485814790185062L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public URL run() throws MalformedURLException {
                        URL url;
                        block2: {
                            try {
                                url = new URL(loc);
                            }
                            catch (Exception ex) {
                                File file;
                                url = ResourceUtils.getClasspathResourceURL(loc, ResourceUtils.class, bus);
                                if (url != null || !(file = new File(loc)).exists()) break block2;
                                url = file.toURI().toURL();
                            }
                        }
                        return url;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.ResourceUtils$3", 3.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        if (url == null) {
            LOG.warning("No resource " + loc + " is available");
        }
        URL uRL = url;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRL = uRL;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResourceURL", uRL);
        }
        return uRL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static InputStream getClasspathResourceStream(String path, Class<?> callingClass, Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClasspathResourceStream", new Object[]{path, callingClass, bus});
        }
        InputStream is = ClassLoaderUtils.getResourceAsStream(path, callingClass);
        InputStream inputStream = is == null ? ResourceUtils.getResource(path, InputStream.class, bus) : is;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClasspathResourceStream", inputStream);
        }
        return inputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URL getClasspathResourceURL(String path, Class<?> callingClass, Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClasspathResourceURL", new Object[]{path, callingClass, bus});
        }
        URL url = ClassLoaderUtils.getResource(path, callingClass);
        URL uRL = url == null ? ResourceUtils.getResource(path, URL.class, bus) : url;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRL = uRL;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getClasspathResourceURL", uRL);
        }
        return uRL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static <T> T getResource(String path, Class<T> resourceClass, Bus bus) {
        ResourceManager rm;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResource", new Object[]{path, resourceClass, bus});
        }
        if (bus != null && (rm = bus.getExtension(ResourceManager.class)) != null) {
            T t = rm.resolveResource(path, resourceClass);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t = t;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResource", t);
            }
            return t;
        }
        T t = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResource", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Properties loadProperties(String propertiesLocation, Bus bus) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "loadProperties", new Object[]{propertiesLocation, bus});
        }
        Properties props = new Properties();
        InputStream is = ResourceUtils.getResourceStream(propertiesLocation, bus);
        props.load(is);
        Properties properties = props;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            properties = properties;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "loadProperties", properties);
        }
        return properties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static List<UserResource> getUserResources(String loc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getUserResources", new Object[]{loc});
        }
        List<UserResource> list = ResourceUtils.getUserResources(loc, BusFactory.getThreadDefaultBus());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getUserResources", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static List<UserResource> getUserResources(InputStream is) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getUserResources", new Object[]{is});
        }
        Document doc = StaxUtils.read(new InputStreamReader(is, StandardCharsets.UTF_8));
        List<UserResource> list = ResourceUtils.getResourcesFromElement(doc.getDocumentElement());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getUserResources", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static List<UserResource> getResourcesFromElement(Element modelEl) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResourcesFromElement", new Object[]{modelEl});
        }
        ArrayList<UserResource> resources = new ArrayList<UserResource>();
        List<Element> resourceEls = DOMUtils.findAllElementsByTagNameNS(modelEl, "http://cxf.apache.org/jaxrs", "resource");
        for (Element e : resourceEls) {
            resources.add(ResourceUtils.getResourceFromElement(e));
        }
        ArrayList<UserResource> arrayList = resources;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResourcesFromElement", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ResourceTypes getAllRequestResponseTypes(List<ClassResourceInfo> cris, boolean jaxbOnly) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAllRequestResponseTypes", new Object[]{cris, jaxbOnly});
        }
        ResourceTypes resourceTypes = ResourceUtils.getAllRequestResponseTypes(cris, jaxbOnly, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            resourceTypes = resourceTypes;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAllRequestResponseTypes", resourceTypes);
        }
        return resourceTypes;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ResourceTypes getAllRequestResponseTypes(List<ClassResourceInfo> cris, boolean jaxbOnly, MessageBodyWriter<?> jaxbWriter) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAllRequestResponseTypes", new Object[]{cris, jaxbOnly, jaxbWriter});
        }
        ResourceTypes types = new ResourceTypes();
        for (ClassResourceInfo resource : cris) {
            ResourceUtils.getAllTypesForResource(resource, types, jaxbOnly, jaxbWriter);
        }
        ResourceTypes resourceTypes = types;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            resourceTypes = resourceTypes;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAllRequestResponseTypes", resourceTypes);
        }
        return resourceTypes;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> getActualJaxbType(Class<?> type, Method resourceMethod, boolean inbound) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getActualJaxbType", new Object[]{type, resourceMethod, inbound});
        }
        ElementClass element = resourceMethod.getAnnotation(ElementClass.class);
        if (element != null) {
            Class<?> cls;
            Class<?> clazz = cls = inbound ? element.request() : element.response();
            if (cls != Object.class) {
                Class<?> clazz2 = cls;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    clazz2 = clazz2;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getActualJaxbType", clazz2);
                }
                return clazz2;
            }
        }
        Class<?> clazz = type;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getActualJaxbType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void getAllTypesForResource(ClassResourceInfo resource, ResourceTypes types, boolean jaxbOnly, MessageBodyWriter<?> jaxbWriter) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAllTypesForResource", new Object[]{resource, types, jaxbOnly, jaxbWriter});
        }
        for (OperationResourceInfo ori : resource.getMethodDispatcher().getOperationResourceInfos()) {
            Method method = ori.getAnnotatedMethod() == null ? ori.getMethodToInvoke() : ori.getAnnotatedMethod();
            Class<?> realReturnType = method.getReturnType();
            Class<?> cls = realReturnType;
            if (cls == Response.class || ori.isAsync()) {
                cls = ResourceUtils.getActualJaxbType(cls, method, false);
            }
            Type type = method.getGenericReturnType();
            if (jaxbOnly) {
                ResourceUtils.checkJaxbType(resource.getServiceClass(), cls, realReturnType == Response.class || ori.isAsync() ? cls : type, types, method.getAnnotations(), jaxbWriter);
            } else {
                types.getAllTypes().put(cls, type);
            }
            for (Parameter pm : ori.getParameters()) {
                Class<?> inType;
                if (pm.getType() != ParameterType.REQUEST_BODY || (inType = method.getParameterTypes()[pm.getIndex()]) == AsyncResponse.class) continue;
                Type paramType = method.getGenericParameterTypes()[pm.getIndex()];
                if (jaxbOnly) {
                    ResourceUtils.checkJaxbType(resource.getServiceClass(), inType, paramType, types, method.getParameterAnnotations()[pm.getIndex()], jaxbWriter);
                    continue;
                }
                types.getAllTypes().put(inType, paramType);
            }
        }
        for (ClassResourceInfo sub : resource.getSubResources()) {
            if (ResourceUtils.isRecursiveSubResource(resource, sub)) continue;
            ResourceUtils.getAllTypesForResource(sub, types, jaxbOnly, jaxbWriter);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getAllTypesForResource");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isRecursiveSubResource(ClassResourceInfo parent, ClassResourceInfo sub) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "isRecursiveSubResource", new Object[]{parent, sub});
        }
        if (parent == null) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isRecursiveSubResource", bl);
            }
            return bl;
        }
        if (parent == sub) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isRecursiveSubResource", bl);
            }
            return bl;
        }
        boolean bl = ResourceUtils.isRecursiveSubResource(parent.getParent(), sub);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isRecursiveSubResource", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void checkJaxbType(Class<?> serviceClass, Class<?> type, Type genericType, ResourceTypes types, Annotation[] anns, MessageBodyWriter<?> jaxbWriter) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkJaxbType", new Object[]{serviceClass, type, genericType, types, anns, jaxbWriter});
        }
        boolean isCollection = false;
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            type = InjectionUtils.getActualType(genericType);
            isCollection = true;
        }
        if (type == Object.class && !(genericType instanceof Class) || genericType instanceof TypeVariable) {
            Type theType = InjectionUtils.processGenericTypeIfNeeded(serviceClass, Object.class, genericType);
            type = InjectionUtils.getActualType(theType);
        }
        if (type == null || InjectionUtils.isPrimitive(type) || JAXBElement.class.isAssignableFrom(type) || Response.class.isAssignableFrom(type) || type.isInterface()) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkJaxbType");
            }
            return;
        }
        MessageBodyWriter<?> writer = jaxbWriter;
        if (writer == null) {
            JAXBElementProvider defaultWriter = new JAXBElementProvider();
            defaultWriter.setMarshallAsJaxbElement(true);
            defaultWriter.setXmlTypeAsJaxbElementOnly(true);
            writer = defaultWriter;
        }
        if (writer.isWriteable(type, type, anns, MediaType.APPLICATION_XML_TYPE)) {
            XMLName name;
            QName qname;
            types.getAllTypes().put(type, type);
            Class<?> genCls = InjectionUtils.getActualType(genericType);
            if (genCls != type && genCls != null && genCls != Object.class && !InjectionUtils.isSupportedCollectionOrArray(genCls)) {
                types.getAllTypes().put(genCls, genCls);
            }
            QName qName = qname = (name = AnnotationUtils.getAnnotation(anns, XMLName.class)) != null ? JAXRSUtils.convertStringToQName(name.value()) : null;
            if (isCollection) {
                types.getCollectionMap().put(type, qname);
            } else {
                types.getXmlNameMap().put(type, qname);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "checkJaxbType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static UserResource getResourceFromElement(Element e) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResourceFromElement", new Object[]{e});
        }
        UserResource resource = new UserResource();
        resource.setName(e.getAttribute("name"));
        resource.setPath(e.getAttribute("path"));
        resource.setConsumes(e.getAttribute("consumes"));
        resource.setProduces(e.getAttribute("produces"));
        List<Element> operEls = DOMUtils.findAllElementsByTagNameNS(e, "http://cxf.apache.org/jaxrs", "operation");
        ArrayList<UserOperation> opers = new ArrayList<UserOperation>(operEls.size());
        for (Element operEl : operEls) {
            opers.add(ResourceUtils.getOperationFromElement(operEl));
        }
        resource.setOperations(opers);
        UserResource userResource = resource;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            userResource = userResource;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getResourceFromElement", userResource);
        }
        return userResource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static UserOperation getOperationFromElement(Element e) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "getOperationFromElement", new Object[]{e});
        }
        UserOperation op = new UserOperation();
        op.setName(e.getAttribute("name"));
        op.setVerb(e.getAttribute("verb"));
        op.setPath(e.getAttribute("path"));
        op.setOneway(Boolean.parseBoolean(e.getAttribute("oneway")));
        op.setConsumes(e.getAttribute("consumes"));
        op.setProduces(e.getAttribute("produces"));
        List<Element> paramEls = DOMUtils.findAllElementsByTagNameNS(e, "http://cxf.apache.org/jaxrs", "param");
        ArrayList<Parameter> params = new ArrayList<Parameter>(paramEls.size());
        for (int i = 0; i < paramEls.size(); ++i) {
            Element paramEl = paramEls.get(i);
            Parameter p = new Parameter(paramEl.getAttribute("type"), i, paramEl.getAttribute("name"));
            p.setEncoded(Boolean.valueOf(paramEl.getAttribute("encoded")));
            p.setDefaultValue(paramEl.getAttribute("defaultValue"));
            String pClass = paramEl.getAttribute("class");
            if (!StringUtils.isEmpty(pClass)) {
                try {
                    p.setJavaType(ClassLoaderUtils.loadClass(pClass, ResourceUtils.class));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            params.add(p);
        }
        op.setParameters(params);
        UserOperation userOperation = op;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            userOperation = userOperation;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "getOperationFromElement", userOperation);
        }
        return userOperation;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object[] createConstructorArguments(Constructor<?> c, Message m, boolean perRequest) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createConstructorArguments", new Object[]{c, m, perRequest});
        }
        Object[] objectArray = ResourceUtils.createConstructorArguments(c, m, perRequest, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            objectArray = objectArray;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createConstructorArguments", objectArray);
        }
        return objectArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object[] createConstructorArguments(Constructor<?> c, Message m, boolean perRequest, Map<Class<?>, Object> contextValues) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createConstructorArguments", new Object[]{c, m, perRequest, contextValues});
        }
        Class<?>[] params = c.getParameterTypes();
        Annotation[][] anns = c.getParameterAnnotations();
        Type[] genericTypes = c.getGenericParameterTypes();
        Object[] objectArray = ResourceUtils.createConstructorArguments(c, m, perRequest, contextValues, params, anns, genericTypes);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            objectArray = objectArray;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createConstructorArguments", objectArray);
        }
        return objectArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object[] createConstructorArguments(Constructor<?> c, Message m, boolean perRequest, Map<Class<?>, Object> contextValues, Class<?>[] params, Annotation[][] anns, Type[] genericTypes) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createConstructorArguments", new Object[]{c, m, perRequest, contextValues, params, anns, genericTypes});
        }
        if (m == null) {
            m = new MessageImpl();
        }
        MultivaluedMap templateValues = (MultivaluedMap)m.get("jaxrs.template.parameters");
        Object[] values = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (AnnotationUtils.getAnnotation(anns[i], Context.class) != null) {
                Object contextValue;
                Object object = contextValue = contextValues != null ? contextValues.get(params[i]) : null;
                if (contextValue == null) {
                    if (perRequest) {
                        values[i] = JAXRSUtils.createContextValue(m, genericTypes[i], params[i]);
                        continue;
                    }
                    values[i] = InjectionUtils.createThreadLocalProxy(params[i]);
                    continue;
                }
                values[i] = contextValue;
                continue;
            }
            Parameter p = ResourceUtils.getParameter(i, anns[i], params[i]);
            values[i] = JAXRSUtils.createHttpParameterValue(p, params[i], genericTypes[i], anns[i], m, (MultivaluedMap<String, String>)templateValues, null);
        }
        Object[] objectArray = values;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            objectArray = objectArray;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createConstructorArguments", objectArray);
        }
        return objectArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JAXRSServerFactoryBean createApplication(Application app, boolean ignoreAppPath, boolean staticSubresourceResolution, boolean useSingletonResourceProvider, Bus bus) {
        Object appPath;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createApplication", new Object[]{app, ignoreAppPath, staticSubresourceResolution, useSingletonResourceProvider, bus});
        }
        Set singletons = app.getSingletons();
        ResourceUtils.verifySingletons(singletons);
        ArrayList resourceClasses = new ArrayList();
        ArrayList<Object> providers = new ArrayList<Object>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        HashMap map = new HashMap();
        for (Class cls : app.getClasses()) {
            if (!ResourceUtils.isValidApplicationClass(cls, singletons)) continue;
            if (ResourceUtils.isValidProvider(cls)) {
                providers.add(ResourceUtils.createProviderInstance(cls));
                continue;
            }
            if (Feature.class.isAssignableFrom(cls)) {
                features.add(ResourceUtils.createFeatureInstance(cls));
                continue;
            }
            resourceClasses.add(cls);
            if (useSingletonResourceProvider) {
                map.put(cls, new SingletonResourceProvider(ResourceUtils.createProviderInstance(cls)));
                continue;
            }
            map.put(cls, new PerRequestResourceProvider(cls));
        }
        for (Object o : singletons) {
            if (ResourceUtils.isValidProvider(o.getClass())) {
                providers.add(o);
                continue;
            }
            if (o instanceof Feature) {
                features.add((Feature)o);
                continue;
            }
            resourceClasses.add(o.getClass());
            map.put(o.getClass(), new SingletonResourceProvider(o));
        }
        JAXRSServerFactoryBean bean = new JAXRSServerFactoryBean();
        if (bus != null) {
            bean.setBus(bus);
        }
        String address = "/";
        if (!ignoreAppPath && (appPath = ResourceUtils.locateApplicationPath(app.getClass())) != null) {
            address = appPath.value();
        }
        if (!address.startsWith("/")) {
            address = "/" + address;
        }
        bean.setAddress(address);
        bean.setStaticSubresourceResolution(staticSubresourceResolution);
        bean.setResourceClasses(resourceClasses);
        bean.setProviders(providers);
        bean.setFeatures(features);
        for (Map.Entry entry : map.entrySet()) {
            bean.setResourceProvider((Class)entry.getKey(), (ResourceProvider)entry.getValue());
        }
        Map appProps = app.getProperties();
        if (appProps != null) {
            bean.getProperties(true).putAll(appProps);
        }
        bean.setApplication(app);
        JAXRSServerFactoryBean jAXRSServerFactoryBean = bean;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXRSServerFactoryBean = jAXRSServerFactoryBean;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createApplication", jAXRSServerFactoryBean);
        }
        return jAXRSServerFactoryBean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object createProviderInstance(Class<?> cls) {
        Constructor<?> constructor;
        block6: {
            Constructor<?> c;
            block4: {
                Object obj;
                block5: {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createProviderInstance", new Object[]{cls});
                    }
                    try {
                        c = ResourceUtils.findResourceConstructor(cls, false);
                        if (c.getParameterTypes().length != 0) break block4;
                        obj = c.newInstance(new Object[0]);
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException("Provider " + cls.getName() + " can not be created", ex);
                    }
                    obj = obj;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createProviderInstance", obj);
                }
                return obj;
            }
            constructor = c;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            constructor = constructor;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createProviderInstance", constructor);
        }
        return constructor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Feature createFeatureInstance(Class<? extends Feature> cls) {
        Feature feature;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createFeatureInstance", new Object[]{cls});
            }
            try {
                Constructor<?> c = ResourceUtils.findResourceConstructor(cls, false);
                if (c == null) {
                    throw new RuntimeException("No valid constructor found for " + cls.getName());
                }
                feature = (Feature)c.newInstance(new Object[0]);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable ex) {
                throw new RuntimeException("Feature " + cls.getName() + " can not be created", ex);
            }
            feature = feature;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createFeatureInstance", feature);
        }
        return feature;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isValidProvider(Class<?> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidProvider", new Object[]{c});
        }
        if (c == null || c == Object.class) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidProvider", bl);
            }
            return bl;
        }
        if (c.getAnnotation(Provider.class) != null) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidProvider", bl);
            }
            return bl;
        }
        for (Class<?> itf : c.getInterfaces()) {
            if (!SERVER_PROVIDER_CLASS_NAMES.contains(itf.getName())) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidProvider", bl);
            }
            return bl;
        }
        boolean bl = ResourceUtils.isValidProvider(c.getSuperclass());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidProvider", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void verifySingletons(Set<Object> singletons) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "verifySingletons", new Object[]{singletons});
        }
        if (singletons.isEmpty()) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "verifySingletons");
            }
            return;
        }
        HashSet<String> map = new HashSet<String>();
        for (Object s : singletons) {
            if (map.contains(s.getClass().getName())) {
                throw new RuntimeException("More than one instance of the same singleton class " + s.getClass().getName() + " is available");
            }
            map.add(s.getClass().getName());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "verifySingletons");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isValidResourceClass(Class<?> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidResourceClass", new Object[]{c});
        }
        if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
            LOG.info("Ignoring invalid resource class " + c.getName());
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidResourceClass", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidResourceClass", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ApplicationPath locateApplicationPath(Class<?> appClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "locateApplicationPath", new Object[]{appClass});
        }
        ApplicationPath appPath = appClass.getAnnotation(ApplicationPath.class);
        if (appPath == null && appClass.getSuperclass() != Application.class) {
            ApplicationPath applicationPath = ResourceUtils.locateApplicationPath(appClass.getSuperclass());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                applicationPath = applicationPath;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "locateApplicationPath", applicationPath);
            }
            return applicationPath;
        }
        ApplicationPath applicationPath = appPath;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            applicationPath = applicationPath;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "locateApplicationPath", applicationPath);
        }
        return applicationPath;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isValidApplicationClass(Class<?> c, Set<Object> singletons) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidApplicationClass", new Object[]{c, singletons});
        }
        if (!ResourceUtils.isValidResourceClass(c)) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidApplicationClass", bl);
            }
            return bl;
        }
        for (Object s : singletons) {
            if (c != s.getClass()) continue;
            LOG.info("Ignoring per-request resource class " + c.getName() + " as it is also registered as singleton");
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidApplicationClass", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "isValidApplicationClass", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JAXBContext createJaxbContext(Set<Class<?>> classes, Class<?>[] extraClass, Map<String, Object> contextProperties) {
        JAXBContext jAXBContext;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.ResourceUtils", "createJaxbContext", new Object[]{classes, extraClass, contextProperties});
            }
            if (classes == null || classes.isEmpty()) {
                JAXBContext jAXBContext2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    jAXBContext2 = jAXBContext2;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createJaxbContext", jAXBContext2);
                }
                return jAXBContext2;
            }
            JAXBUtils.scanPackages(classes, extraClass, null);
            try {
                JAXBContext ctx;
                jAXBContext = ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), contextProperties);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (JAXBException ex) {
                LOG.log(Level.SEVERE, "No JAXB context can be created", ex);
                JAXBContext jAXBContext3 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    jAXBContext3 = jAXBContext3;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createJaxbContext", jAXBContext3);
                }
                return jAXBContext3;
            }
            jAXBContext = jAXBContext;
            LOG.exiting("org.apache.cxf.jaxrs.utils.ResourceUtils", "createJaxbContext", jAXBContext);
        }
        return jAXBContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.MessageBodyWriter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.MessageBodyReader");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ExceptionMapper");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ContextResolver");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ReaderInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.WriterInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ParamConverterProvider");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.ContainerRequestFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.ContainerResponseFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.DynamicFeature");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.core.Feature");
        SERVER_PROVIDER_CLASS_NAMES.add("org.apache.cxf.jaxrs.ext.ContextProvider");
    }
}

