/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.injectionengine.ffdc.Formattable;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessorContext;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.injectionengine.ObjectFactoryInfo;
import com.ibm.wsspi.injectionengine.OverrideInjectionProcessor;
import com.ibm.wsspi.injectionengine.factory.OverrideReferenceFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class InjectionProcessor<A extends Annotation, AS extends Annotation>
implements Formattable {
    private static final TraceComponent tc = Tr.register(InjectionProcessor.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private final Class<A> ivAnnotationClass;
    final Class<AS> ivAnnotationsClass;
    private InjectionProcessorContext ivContext;
    protected ComponentNameSpaceConfiguration ivNameSpaceConfig;
    InjectionProcessor<? extends Annotation, ? extends Annotation> ivOverrideProcessor;
    private Map<Class<?>, ObjectFactoryInfo> ivObjectFactoryMap;
    private Map<String, ObjectFactoryInfo> ivObjectFactoryByNameMap;
    private Map<Class<?>, ObjectFactoryInfo> ivNoOverrideObjectFactoryMap;
    private Map<String, ObjectFactoryInfo> ivNoOverrideObjectFactoryByNameMap;
    protected ArrayList<OverrideReferenceFactory<A>> ivOverrideReferenceFactories;
    protected final Map<String, InjectionBinding<A>> ivAllAnnotationsCollection = new BindingMap();
    private Map<Member, InjectionBinding<A>> ivSimpleInjectionBindings;
    protected ArrayList<String> ivMissingBindings = new ArrayList();

    public InjectionProcessor(Class<A> annotationClass, Class<AS> annotationsClass) {
        this.ivAnnotationClass = annotationClass;
        this.ivAnnotationsClass = annotationsClass;
    }

    void initProcessor(ComponentNameSpaceConfiguration compNSConfig, InjectionProcessorContext context) throws InjectionException {
        J2EEName j2eeName;
        if (this.ivNameSpaceConfig != null || this.ivContext != null || !this.ivAllAnnotationsCollection.isEmpty()) {
            throw new InjectionException("Internal error: " + this.getClass().getName() + ".createInjectionProcessor() returned an instance with initial state; createInjectionProcessor() must return a new uninitialized instance of the InjectionProcessor");
        }
        this.ivNameSpaceConfig = compNSConfig;
        this.ivContext = context;
        this.ivObjectFactoryMap = this.ivContext.ivObjectFactoryMap.get(this.ivAnnotationClass);
        this.ivNoOverrideObjectFactoryMap = this.ivContext.ivNoOverrideObjectFactoryMap.get(this.ivAnnotationClass);
        OverrideReferenceFactory[] factories = (OverrideReferenceFactory[])OverrideReferenceFactory[].class.cast(this.ivContext.ivOverrideReferenceFactoryMap.get(this.ivAnnotationClass));
        if (factories != null && (j2eeName = this.ivNameSpaceConfig.getJ2EEName()) != null) {
            String appName = j2eeName.getApplication();
            String modName = j2eeName.getModule();
            for (OverrideReferenceFactory factory : factories) {
                if (!factory.hasModuleOverride(appName, modName)) continue;
                if (this.ivOverrideReferenceFactories == null) {
                    this.ivOverrideReferenceFactories = new ArrayList();
                }
                this.ivOverrideReferenceFactories.add(factory);
            }
        }
        if (!this.ivContext.ivSaveNonCompInjectionBindings) {
            this.addSavedInjectionBindings(this.ivContext.ivSavedGlobalInjectionBindings);
            this.addSavedInjectionBindings(this.ivContext.ivSavedAppInjectionBindings);
            this.addSavedInjectionBindings(this.ivContext.ivSavedModuleInjectionBindings);
        }
        this.initProcessor();
    }

    private void addSavedInjectionBindings(Map<Class<?>, Map<String, InjectionBinding<?>>> savedInjectionBindings) throws InjectionException {
        Map<String, InjectionBinding<A>> injectionBindingsMap;
        if (savedInjectionBindings != null && (injectionBindingsMap = this.getSavedInjectionBindings(savedInjectionBindings, false)) != null) {
            this.ivAllAnnotationsCollection.putAll(injectionBindingsMap);
        }
    }

    private Map<String, InjectionBinding<A>> getSavedInjectionBindings(Map<Class<?>, Map<String, InjectionBinding<?>>> savedInjectionBindings, boolean create) {
        Map<String, InjectionBinding<A>> result = savedInjectionBindings.get(this.getClass());
        if (result == null && create) {
            result = new HashMap<String, InjectionBinding<A>>();
            savedInjectionBindings.put(this.getClass(), result);
        }
        return result;
    }

    protected void initProcessor() throws InjectionException {
    }

    protected final ObjectFactoryInfo getObjectFactoryInfo(Class<?> klass, String className) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectFactory: " + klass + ", " + className), (Object[])new Object[0]);
        }
        if (this.ivObjectFactoryMap == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectFactory: no factories");
            }
            return null;
        }
        if (klass != null && klass != Object.class) {
            ObjectFactoryInfo result = this.ivObjectFactoryMap.get(klass);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectFactory: " + result));
            }
            return result;
        }
        if (this.ivObjectFactoryByNameMap == null) {
            this.ivObjectFactoryByNameMap = new HashMap<String, ObjectFactoryInfo>();
            for (Map.Entry entry : this.ivObjectFactoryMap.entrySet()) {
                this.ivObjectFactoryByNameMap.put(((Class)entry.getKey()).getName(), (ObjectFactoryInfo)entry.getValue());
            }
        }
        ObjectFactoryInfo result = this.ivObjectFactoryByNameMap.get(className);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getObjectFactory (by-name): " + result));
        }
        return result;
    }

    protected final ObjectFactoryInfo getNoOverrideObjectFactory(Class<?> klass, String className) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNoOverrideObjectFactory: " + klass + ", " + className), (Object[])new Object[0]);
        }
        if (this.ivNoOverrideObjectFactoryMap == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getNoOverrideObjectFactory: no factories");
            }
            return null;
        }
        if (klass != null && klass != Object.class) {
            ObjectFactoryInfo result = this.ivNoOverrideObjectFactoryMap.get(klass);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getNoOverrideObjectFactory: " + result));
            }
            return result;
        }
        if (this.ivNoOverrideObjectFactoryByNameMap == null) {
            this.ivNoOverrideObjectFactoryByNameMap = new HashMap<String, ObjectFactoryInfo>();
            for (Map.Entry entry : this.ivNoOverrideObjectFactoryMap.entrySet()) {
                this.ivNoOverrideObjectFactoryByNameMap.put(((Class)entry.getKey()).getName(), (ObjectFactoryInfo)entry.getValue());
            }
        }
        ObjectFactoryInfo result = this.ivNoOverrideObjectFactoryByNameMap.get(className);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getObjectFactory (by-name): " + result));
        }
        return result;
    }

    private void updateInjectionBinding(String jndiName, InjectionBinding<A> injectionBinding) {
        if (!jndiName.equals(injectionBinding.getJndiName())) {
            injectionBinding.setJndiName(jndiName);
        }
    }

    private InjectionBinding<A> getInjectionBindingForAnnotation(String jndiName) {
        InjectionBinding<?> completedInjectionBinding;
        InjectionBinding<Object> injectionBinding = this.ivAllAnnotationsCollection.get(jndiName);
        if (injectionBinding == null && this.ivContext.ivCompletedInjectionBindings != null && (completedInjectionBinding = this.ivContext.ivCompletedInjectionBindings.get(jndiName)) != null && completedInjectionBinding.ivProcessorClass == this.getClass()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("reusing completed " + completedInjectionBinding.toSimpleString()), (Object[])new Object[0]);
            }
            InjectionBinding<?> uncheckedInjectionBinding = completedInjectionBinding;
            injectionBinding = uncheckedInjectionBinding;
            injectionBinding.metadataProcessingInitialize(this.ivNameSpaceConfig);
            this.ivAllAnnotationsCollection.put(jndiName, injectionBinding);
        }
        return injectionBinding;
    }

    private <P extends Annotation> InjectionBinding<?> addOrMergeOverrideInjectionBinding(Class<?> instanceClass, Member member, A annotation, String jndiName) throws InjectionException {
        InjectionProcessor<? extends Annotation, ? extends Annotation> processor = this.ivOverrideProcessor;
        if (processor != null) {
            InjectionBinding<Annotation> injectionBinding = super.getInjectionBindingForAnnotation(jndiName);
            OverrideInjectionProcessor overrideProcessor = (OverrideInjectionProcessor)((Object)processor);
            if (injectionBinding == null) {
                injectionBinding = overrideProcessor.createOverrideInjectionBinding(instanceClass, member, annotation, jndiName);
                if (injectionBinding != null) {
                    super.updateInjectionBinding(jndiName, injectionBinding);
                    processor.addInjectionBinding(injectionBinding);
                    return injectionBinding;
                }
            } else {
                overrideProcessor.mergeOverrideInjectionBinding(instanceClass, member, annotation, injectionBinding);
                return injectionBinding;
            }
        }
        return null;
    }

    void addOrMergeInjectionBinding(Class<?> instanceClass, Member member, A annotation) throws InjectionException {
        InjectionBinding<Object> resultInjectionBinding;
        String jndiName = this.getJndiName(annotation);
        String propertyName = null;
        if (jndiName == null || jndiName.length() == 0) {
            if (member == null) {
                this.validateMissingJndiName(instanceClass, annotation);
                return;
            }
            propertyName = this.getJavaBeansPropertyName(member);
            if (propertyName == null && !this.isNonJavaBeansPropertyMethodAllowed()) {
                Tr.error((TraceComponent)tc, (String)"NOT_A_SETTER_METHOD_ON_METHOD_ANNOTATION_CWNEN0008E", (Object[])new Object[]{member.getName()});
                if (this.isValidationFailable()) {
                    throw new InjectionException("The " + member.getDeclaringClass() + '.' + member.getName() + " method is annotated @" + annotation.annotationType().getSimpleName() + ", but it is not a setter method.");
                }
                return;
            }
        }
        if (jndiName == null) {
            if (this.ivSimpleInjectionBindings == null) {
                this.ivSimpleInjectionBindings = new LinkedHashMap<Member, InjectionBinding<A>>();
            }
            if (this.ivSimpleInjectionBindings.containsKey(member)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("binding found, merge not needed : " + member), (Object[])new Object[0]);
                }
                return;
            }
            InjectionBinding<A> injectionBinding = this.createInjectionBinding(annotation, instanceClass, member, null);
            resultInjectionBinding = injectionBinding;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("adding " + injectionBinding), (Object[])new Object[0]);
            }
            this.ivSimpleInjectionBindings.put(member, injectionBinding);
        } else {
            InjectionBinding<A> injectionBinding;
            if (propertyName != null) {
                jndiName = instanceClass.getCanonicalName() + '/' + propertyName;
            }
            if ((injectionBinding = this.getInjectionBindingForAnnotation(jndiName)) == null) {
                resultInjectionBinding = this.addOrMergeOverrideInjectionBinding(instanceClass, member, annotation, jndiName);
                if (resultInjectionBinding == null) {
                    resultInjectionBinding = injectionBinding = this.createInjectionBinding(annotation, instanceClass, member, jndiName);
                    this.updateInjectionBinding(jndiName, injectionBinding);
                    this.addInjectionBinding(injectionBinding);
                }
            } else {
                resultInjectionBinding = injectionBinding;
                injectionBinding.merge(annotation, instanceClass, member);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("merged " + injectionBinding), (Object[])new Object[0]);
                }
            }
        }
        if (member == null) {
            resultInjectionBinding.addInjectionClass(instanceClass);
        } else {
            resultInjectionBinding.addInjectionTarget(member);
        }
    }

    protected void validateMissingJndiName(Class<?> instanceClass, A annotation) throws InjectionException {
        if (this.isValidationLoggable()) {
            Tr.error((TraceComponent)tc, (String)"MISSING_CLASS_LEVEL_ANNOTATION_NAME_CWNEN0073E", (Object[])new Object[]{'@' + annotation.annotationType().getSimpleName(), instanceClass.getName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName()});
            if (this.isValidationFailable()) {
                throw new InjectionException("The @" + annotation.annotationType().getSimpleName() + " class-level annotation on the " + instanceClass.getName() + " class in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application does not specify a JNDI name.");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ignoring class-level annotation without name", (Object[])new Object[0]);
        }
    }

    protected boolean isNonJavaBeansPropertyMethodAllowed() {
        return false;
    }

    void resolveInjectionBindings() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolveInjectionBindings: " + this), (Object[])new Object[0]);
        }
        Collection<InjectionBinding<A>> allInjectionBindings = this.ivAllAnnotationsCollection.values();
        for (InjectionBinding<A> injectionBinding : allInjectionBindings) {
            String jndiName;
            Map<Class<?>, Map<String, InjectionBinding<?>>> savedInjectionBindings;
            Map<String, InjectionBinding<A>> injectionBindingsMap;
            InjectionBinding<A> savedBinding;
            if (injectionBinding.ivResolveAttempted) {
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("skipping already resolved " + injectionBinding.toSimpleString()), (Object[])new Object[0]);
                continue;
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("resolving " + injectionBinding.toSimpleString()), (Object[])new Object[0]);
            }
            injectionBinding.resolveJndiName();
            this.resolve(injectionBinding);
            injectionBinding.ivResolveAttempted = true;
            InjectionScope injectionScope = injectionBinding.getInjectionScope();
            if (injectionScope == InjectionScope.COMP || !this.ivContext.ivSaveNonCompInjectionBindings) continue;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("saving " + (Object)((Object)injectionScope) + " injection binding " + injectionBinding.toSimpleString()), (Object[])new Object[0]);
            }
            if ((savedBinding = (injectionBindingsMap = this.getSavedInjectionBindings(savedInjectionBindings = injectionScope == InjectionScope.MODULE ? this.ivContext.ivSavedModuleInjectionBindings : (injectionScope == InjectionScope.APP ? this.ivContext.ivSavedAppInjectionBindings : this.ivContext.ivSavedGlobalInjectionBindings), true)).get(jndiName = injectionBinding.getJndiName())) == null) {
                injectionBindingsMap.put(jndiName, injectionBinding);
                continue;
            }
            savedBinding.mergeSaved(injectionBinding);
        }
        this.ivContext.ivProcessedInjectionBindings.addAll(allInjectionBindings);
        if (this.ivSimpleInjectionBindings != null) {
            Collection<InjectionBinding<A>> injectionBindings = this.ivSimpleInjectionBindings.values();
            for (InjectionBinding<A> injectionBinding : injectionBindings) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resolving " + injectionBinding.toSimpleString()), (Object[])new Object[0]);
                }
                this.resolve(injectionBinding);
            }
            this.ivContext.ivProcessedInjectionBindings.addAll(injectionBindings);
        }
        if (!this.ivMissingBindings.isEmpty()) {
            Iterator<String> missingBindingIter = this.ivMissingBindings.iterator();
            String string = this.ivNameSpaceConfig.getDisplayName();
            while (missingBindingIter.hasNext()) {
                String string2 = missingBindingIter.next();
                Tr.error((TraceComponent)tc, (String)"UNABLE_TO_RESOLVE_THE_RESOURCE_REFERENCE_CWNEN0044E", (Object[])new Object[]{string2, string});
            }
            throw new InjectionException("CWNEN0044E: A resource reference binding could not be found for the following resource references " + this.ivMissingBindings.toString() + ", defined for the " + string + " component.");
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolveInjectionBindings");
        }
    }

    void performJavaNameSpaceBinding() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("performJavaNameSpaceBinding: " + this), (Object[])new Object[0]);
        }
        for (InjectionBinding<A> injectionBinding : this.ivAllAnnotationsCollection.values()) {
            if (injectionBinding.getInjectionScope() == InjectionScope.COMP || this.ivContext.ivBindNonCompInjectionBindings) {
                if (injectionBinding.getBindingObject() == null) {
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("skipping empty " + injectionBinding), (Object[])new Object[0]);
                    continue;
                }
                injectionBinding.bindInjectedObject();
                continue;
            }
            if (!isTraceOn || !tc.isEntryEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("skipping non-java:comp " + injectionBinding.toSimpleString()), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performJavaNameSpaceBinding");
        }
    }

    public final void addInjectionBinding(InjectionBinding<A> injectionBinding) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addInjectionBinding: " + injectionBinding), (Object[])new Object[0]);
        }
        this.ivAllAnnotationsCollection.put(injectionBinding.getJndiName(), injectionBinding);
    }

    protected final String getJavaBeansPropertyName(Member fieldOrMethod) {
        String propertyName;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getJavaBeansPropertyName : " + fieldOrMethod), (Object[])new Object[0]);
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            propertyName = field.getName();
        } else {
            Method method = (Method)fieldOrMethod;
            String name = method.getName();
            propertyName = name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3)) ? Character.toLowerCase(name.charAt(3)) + (name.length() > 4 ? name.substring(4) : "") : null;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getJavaBeansPropertyName : " + propertyName));
        }
        return propertyName;
    }

    public abstract void processXML() throws InjectionException;

    public abstract InjectionBinding<A> createInjectionBinding(A var1, Class<?> var2, Member var3, String var4) throws InjectionException;

    public abstract void resolve(InjectionBinding<A> var1) throws InjectionException;

    public abstract String getJndiName(A var1);

    public abstract A[] getAnnotations(AS var1);

    protected final boolean isValidationLoggable() {
        return InjectionEngineAccessor.getInternalInstance().isValidationLoggable(this.ivNameSpaceConfig.isCheckApplicationConfiguration());
    }

    protected final boolean isValidationFailable() {
        return InjectionEngineAccessor.getInternalInstance().isValidationFailable(this.ivNameSpaceConfig.isCheckApplicationConfiguration());
    }

    @Override
    public final void formatTo(IncidentStream is) {
        is.writeLine("", ">--- Start InjectionProcessor Dump ---> " + Util.identity((Object)this));
        is.writeLine("", "Annotation  = " + this.ivAnnotationClass);
        is.writeLine("", "Annotations = " + this.ivAnnotationsClass);
        is.writeLine("", "");
        is.writeLine("", this.ivContext != null ? this.ivContext.toString() : "ivContext = null");
        is.writeLine("", "");
        is.writeLine("", this.ivNameSpaceConfig != null ? this.ivNameSpaceConfig.toString() : "ivNameSpaceConfig = null");
        is.writeLine("", "");
        is.writeLine("", "Override Processor : " + this.ivOverrideProcessor);
        is.writeLine("", "");
        is.writeLine("", "Object Factory Map : ");
        for (Class<?> clazz : this.ivObjectFactoryMap.keySet()) {
            is.writeLine("", "   " + clazz.getName() + " : " + Util.identity((Object)this.ivObjectFactoryMap.get(clazz)));
        }
        is.writeLine("", "");
        is.writeLine("", "No-Override Object Factory Map : ");
        for (Class<?> clazz : this.ivNoOverrideObjectFactoryMap.keySet()) {
            is.writeLine("", "   " + clazz.getName() + " : " + Util.identity((Object)this.ivNoOverrideObjectFactoryMap.get(clazz)));
        }
        is.writeLine("", "");
        is.writeLine("", "Override Reference Factories : ");
        for (OverrideReferenceFactory overrideReferenceFactory : this.ivOverrideReferenceFactories) {
            is.writeLine("", "   " + Util.identity((Object)overrideReferenceFactory));
        }
        is.writeLine("", "");
        is.writeLine("", "All Bindings : ");
        for (String string : this.ivAllAnnotationsCollection.keySet()) {
            is.writeLine("", "   " + string + " : " + Util.identity(this.ivAllAnnotationsCollection.get(string)));
        }
        is.writeLine("", "<--- InjectionProcessor Dump Complete---< ");
    }

    class BindingMap
    extends LinkedHashMap<String, InjectionBinding<A>> {
        private static final long serialVersionUID = 1483058422051408034L;

        BindingMap() {
        }

        @Override
        public InjectionBinding<A> put(String key, InjectionBinding<A> value) {
            value.ivProcessorClass = InjectionProcessor.this.getClass();
            return super.put(key, value);
        }

        @Override
        public InjectionBinding<A> get(Object key) {
            String jndiName = (String)key;
            return (InjectionBinding)super.get(InjectionScope.normalize(jndiName));
        }
    }
}

