/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyFileUtilityImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyFileCreator;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPAKeyFileCreatorImpl
extends LTPAKeyFileUtilityImpl
implements LTPAKeyFileCreator {
    private static final TraceComponent tc = Tr.register(LTPAKeyFileCreatorImpl.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    static final long serialVersionUID = 7624499851410987452L;

    /*
     * WARNING - void declaration
     */
    private String getRealmName() {
        String realm;
        block3: {
            realm = "defaultRealm";
            try {
                String r;
                UserRegistry ur = RegistryHelper.getUserRegistry(null);
                if (ur != null && (r = ur.getRealm()) != null) {
                    realm = r;
                }
            }
            catch (Exception ur) {
                void ex;
                FFDCFilter.processException((Throwable)ur, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAKeyFileCreatorImpl", (String)"52", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Cannot get the UR service since it may not be available so use the default value for the realm.", (Object[])new Object[]{ex});
            }
        }
        return realm;
    }

    @Override
    public Properties createLTPAKeysFile(WsLocationAdmin locService, String keyFile, @Sensitive byte[] keyPasswordBytes) throws Exception {
        Properties ltpaProps = this.generateLTPAKeys(keyPasswordBytes, this.getRealmName());
        this.addLTPAKeysToFile(this.getOutputStream(locService, keyFile), ltpaProps);
        return ltpaProps;
    }

    private OutputStream getOutputStream(WsLocationAdmin locService, String keyImportFile) throws IOException {
        WsResource ltpaFile = locService.resolveResource(keyImportFile);
        ltpaFile.create();
        if (ltpaFile.isType(WsResource.Type.FILE)) {
            FileUtils.setUserReadWriteOnly((File)ltpaFile.asFile());
        }
        return ltpaFile.putStream();
    }
}

