/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jmx.connector.server.rest.helpers.AttributeRoutingHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/router/mbeans/{objectName}/attributes", "com.ibm.wsspi.rest.handler.root=/router/mbeans/{objectName}/attributes/{attribute}"})
public class MBeanAttributeRouterHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(MBeanAttributeRouterHandler.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    private final String KEY_ROUTING_HELPER = "routingHelper";
    private final AtomicServiceReference<AttributeRoutingHelper> routingHelperRef = new AtomicServiceReference("routingHelper");
    static final long serialVersionUID = 7851085361386213923L;

    @Activate
    protected void activate(ComponentContext context) {
        this.routingHelperRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.routingHelperRef.deactivate(context);
    }

    @Reference(service=AttributeRoutingHelper.class, name="routingHelper", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRoutingHelper(ServiceReference<AttributeRoutingHelper> routingHelper) {
        this.routingHelperRef.setReference(routingHelper);
    }

    protected void unsetRoutingHelper(ServiceReference<AttributeRoutingHelper> routingHelper) {
        this.routingHelperRef.unsetReference(routingHelper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (request.getPathVariable("attribute") != null) {
            if (RESTHelper.isGetMethod(method)) {
                this.getRoutedAttribute(request, response);
                return;
            } else if (RESTHelper.isPostMethod(method)) {
                this.postRoutedAttribute(request, response);
                return;
            } else if (RESTHelper.isPutMethod(method)) {
                this.putRoutedAttribute(request, response);
                return;
            } else {
                if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,POST,PUT,DELETE");
                this.deleteRoutedAttribute(request, response);
            }
            return;
        } else if (RESTHelper.isGetMethod(method)) {
            this.getRoutedAttributes(request, response);
            return;
        } else if (RESTHelper.isPostMethod(method)) {
            this.postRoutedAttributes(request, response);
            return;
        } else if (RESTHelper.isPutMethod(method)) {
            this.putRoutedAttributes(request, response);
            return;
        } else {
            if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,POST,PUT,DELETE");
            this.deleteRoutedAttributes(request, response);
        }
    }

    private void getRoutedAttributes(RESTRequest request, RESTResponse response) {
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        objectName = RESTHelper.repairSlashes(objectName, request);
        List<String> queryAttributes = RESTHelper.getQueryParams(request, "attribute");
        this.getRoutingHelper().getAttributes(request, response, objectName, queryAttributes, true);
        response.setContentType("application/json");
    }

    private void getRoutedAttribute(RESTRequest request, RESTResponse response) {
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        objectName = RESTHelper.repairSlashes(objectName, request);
        String attribute = RESTHelper.getRequiredParam(request, "attribute");
        this.getRoutingHelper().getAttribute(request, response, objectName, attribute, true);
        response.setContentType("application/json");
    }

    private void putRoutedAttributes(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "objectName");
        this.getRoutingHelper().setAttributes(request, response, true);
        response.setContentType("application/json");
    }

    private void putRoutedAttribute(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "objectName");
        RESTHelper.getRequiredParam(request, "attribute");
        this.getRoutingHelper().setAttribute(request, response, true);
        response.setContentType("application/json");
    }

    private void postRoutedAttributes(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "objectName");
        this.getRoutingHelper().setAttributes(request, response, true);
        response.setContentType("application/json");
    }

    private void postRoutedAttribute(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "objectName");
        RESTHelper.getRequiredParam(request, "attribute");
        this.getRoutingHelper().setAttribute(request, response, true);
        response.setContentType("application/json");
    }

    private void deleteRoutedAttributes(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "objectName");
        this.getRoutingHelper().deleteAttributes(request, response, true);
        response.setContentType("application/json");
    }

    private void deleteRoutedAttribute(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "objectName");
        RESTHelper.getRequiredParam(request, "attribute");
        this.getRoutingHelper().deleteAttribute(request, response, true);
        response.setContentType("application/json");
    }

    private AttributeRoutingHelper getRoutingHelper() {
        AttributeRoutingHelper routingHelper = (AttributeRoutingHelper)this.routingHelperRef.getService();
        if (routingHelper == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"AttributeRoutingHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return routingHelper;
    }
}

