/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.DefaultReflectionCache;
import org.jboss.weld.resources.FileLogger;

public class HotspotReflectionCache
extends DefaultReflectionCache {
    private final Class<?> annotationTypeLock;
    private static final String JBOSS_HOTSPOT_TRACE_ENABLED_VALUE = HotspotReflectionCache.getSystemProperty("jboss.hotspot.trace.enabled");
    private static final boolean JBOSS_HOTSPOT_TRACE_ENABLED = JBOSS_HOTSPOT_TRACE_ENABLED_VALUE != null && JBOSS_HOTSPOT_TRACE_ENABLED_VALUE.equals("true");
    private static volatile boolean sentWarning;

    private static void sendWarning() {
        if (!sentWarning) {
            sentWarning = true;
            System.out.println("Warning you have enabled logging that should only be seen in an IBM test environment");
        }
    }

    public HotspotReflectionCache(TypeStore store) {
        super(store);
        try {
            this.annotationTypeLock = Class.forName("sun.reflect.annotation.AnnotationType");
        }
        catch (ClassNotFoundException e) {
            throw new WeldException(e);
        }
    }

    protected static final void dump(Class<?> targetClass) {
        byte[] classBytes;
        String className = "HotspotReflectionCache";
        String methodName = "dump";
        String resourceName = FileLogger.getClassResourceName(targetClass);
        String text = "Class [ " + targetClass.getName() + " ] as [ " + resourceName + " ]";
        FileLogger.fileLog(className, methodName, text);
        try {
            classBytes = FileLogger.read(targetClass.getClassLoader(), resourceName);
        }
        catch (IOException e) {
            FileLogger.fileStack(className, methodName, "Failed to read [ " + resourceName + " ]", e);
            return;
        }
        FileLogger.fileDump(className, methodName, text, classBytes);
    }

    @Override
    @FFDCIgnore(value={Exception.class})
    protected Annotation[] internalGetAnnotations(AnnotatedElement element) {
        if (JBOSS_HOTSPOT_TRACE_ENABLED) {
            HotspotReflectionCache.sendWarning();
            return this.internalGetAnnotationsLogged(element);
        }
        return this.internalGetAnnotationsUnlogged(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Annotation[] internalGetAnnotationsUnlogged(AnnotatedElement element) {
        Class clazz;
        if (element instanceof Class && (clazz = (Class)element).isAnnotation()) {
            Class<?> clazz2 = this.annotationTypeLock;
            synchronized (clazz2) {
                return element.getAnnotations();
            }
        }
        return element.getAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Annotation[] internalGetAnnotationsLogged(AnnotatedElement element) {
        String className = "HotspotReflectionCache";
        String methodName = "internalGetAnnotations";
        try {
            Class clazz;
            if (element instanceof Class && (clazz = (Class)element).isAnnotation()) {
                Annotation[] classAnno;
                Class<?> clazz2 = this.annotationTypeLock;
                synchronized (clazz2) {
                    classAnno = element.getAnnotations();
                }
                Integer numClassAnno = classAnno == null ? null : Integer.valueOf(classAnno.length);
                FileLogger.fileLog(className, methodName, "Class [ " + clazz.getName() + " ] [ " + numClassAnno + " ]");
                return classAnno;
            }
            Annotation[] anno = element.getAnnotations();
            Integer numAnno = anno == null ? null : Integer.valueOf(anno.length);
            FileLogger.fileLog(className, methodName, "Element [ " + element + " ] [ " + numAnno + " ]");
            return anno;
        }
        catch (IllegalArgumentException e) {
            String text = "Constant Pool GREP:";
            Class clazz = null;
            if (element instanceof Class) {
                clazz = (Class)element;
                text = text + " Class [ " + clazz.getName() + " ]:";
            }
            FileLogger.fileLog(className, methodName, text, element);
            if (clazz != null) {
                HotspotReflectionCache.dump(clazz);
            }
            FileLogger.fileStack(className, methodName, text, e);
            throw e;
        }
    }

    private static String getSystemProperty(final String name) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }
}

