/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.utility.utils;

import com.ibm.ws.webserver.plugin.utility.utils.CommandUtils;
import com.ibm.ws.webserver.plugin.utility.utils.PluginUtilityConsole;

public class ParseLoginAddress {
    String inputAddress = null;
    static final String INVALID_PORT_ARG_MESSAGE = "invalidPortArg";
    static final String MISSING_USER_VALUE_MESSAGE = "missingUsernameValue";
    static final String MISSING_PASS_VALUE_MESSAGE = "missingPasswordValue";
    static final String MISSING_HOST_VALUE_MESSAGE = "missingHostValue";
    static final String MISSING_PORT_VALUE_MESSAGE = "missingPortValue";
    static final String MISSING_HOSTPORT_VALUE_MESSAGE = "missingHostorPortValue";
    String userName = null;
    String password = null;
    String host = null;
    String port = null;
    Boolean isLocal = true;
    String serverName = null;
    protected PluginUtilityConsole commandConsole;

    public ParseLoginAddress() {
    }

    public ParseLoginAddress(String input, PluginUtilityConsole commandConsole2) {
        this.inputAddress = input;
        this.commandConsole = commandConsole2;
    }

    public void parseLoginAddressValue(String option) throws IllegalArgumentException {
        int uphpdelimiter = this.inputAddress.lastIndexOf("@");
        if (uphpdelimiter >= 0) {
            this.isLocal = false;
            String userpass = this.inputAddress.substring(0, uphpdelimiter);
            String hostport = this.inputAddress.substring(uphpdelimiter + 1, this.inputAddress.length());
            if (userpass.length() > 1) {
                int userindex = userpass.indexOf(":");
                if (userindex >= 0) {
                    this.userName = userpass.substring(0, userindex);
                    if (this.userName.length() == 0) {
                        this.promptForUser(option);
                    }
                    this.password = userpass.substring(userindex + 1, userpass.length());
                    if (this.password.length() == 0) {
                        this.promptForPassword(option);
                    }
                } else {
                    this.promptForUser(option);
                    this.promptForPassword(option);
                }
            } else {
                this.promptForUser(option);
                this.promptForPassword(option);
            }
            if (hostport.length() > 1) {
                int hostindex = hostport.indexOf(":");
                if (hostindex >= 0) {
                    this.host = hostport.substring(0, hostindex);
                    if (this.host.length() == 0) {
                        this.throwIAE(MISSING_HOST_VALUE_MESSAGE, option);
                    }
                } else {
                    this.throwIAE(MISSING_HOSTPORT_VALUE_MESSAGE, option);
                }
                this.port = hostport.substring(hostindex + 1, hostport.length());
                if (this.port.length() == 0) {
                    this.throwIAE(MISSING_PORT_VALUE_MESSAGE, option);
                }
                try {
                    Double.parseDouble(this.port);
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException(CommandUtils.getMessage(INVALID_PORT_ARG_MESSAGE, this.port, option));
                }
            } else {
                this.throwIAE(MISSING_HOSTPORT_VALUE_MESSAGE, option);
            }
        } else {
            this.isLocal = true;
            this.serverName = this.inputAddress;
        }
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    private void promptForUser(String option) {
        this.userName = this.commandConsole.promptForUser("userName");
        if (this.userName == null) {
            throw new IllegalArgumentException(CommandUtils.getMessage(MISSING_USER_VALUE_MESSAGE, option));
        }
    }

    private void promptForPassword(String option) {
        this.password = this.commandConsole.promptForPassword("password");
        if (this.password == null) {
            throw new IllegalArgumentException(CommandUtils.getMessage(MISSING_PASS_VALUE_MESSAGE, option));
        }
    }

    private void throwIAE(String msg, String option) {
        throw new IllegalArgumentException(CommandUtils.getMessage(msg, option));
    }
}

