/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.AioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;

public class AioTCPReadRequestContextImpl
extends TCPReadRequestContextImpl {
    private static final TraceComponent tc = Tr.register(AioTCPReadRequestContextImpl.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private boolean immedTimeoutRequested = false;
    private boolean jITAllocatedDirect = false;

    public AioTCPReadRequestContextImpl(TCPConnLink value) {
        super(value);
    }

    @Override
    public VirtualConnection processAsyncReadRequest() {
        IOException exThisTime = null;
        this.immedTimeoutRequested = false;
        this.setJITAllocateAction(false);
        this.jITAllocatedDirect = false;
        if (this.getJITAllocateSize() > 0 && this.getBuffers() == null) {
            if (this.oTCPConnLink.getConfig().getAllocateBuffersDirect()) {
                this.setBuffer(ChannelFrameworkFactory.getBufferManager().allocateDirect(this.getJITAllocateSize()));
                this.jITAllocatedDirect = true;
            } else {
                this.setBuffer(ChannelFrameworkFactory.getBufferManager().allocate(this.getJITAllocateSize()));
            }
            this.setJITAllocateAction(true);
        }
        try {
            boolean complete = ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).readAIO(this, this.isForceQueue(), this.getTimeoutInterval());
            if (complete) {
                return this.oTCPConnLink.getVirtualConnection();
            }
        }
        catch (IOException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("IOexception caught: " + ex), (Object[])new Object[0]);
            }
            exThisTime = ex;
        }
        if (exThisTime != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SocketIOChannel x = this.getTCPConnLink().getSocketIOChannel();
                Socket socket = null;
                SocketAddress la = null;
                String las = null;
                SocketAddress ra = null;
                String ras = null;
                if (x != null && (socket = x.getSocket()) != null) {
                    la = socket.getLocalSocketAddress();
                    if (la != null) {
                        las = la.toString();
                    }
                    if ((ra = socket.getRemoteSocketAddress()) != null) {
                        ras = ra.toString();
                    }
                }
                Tr.event((TraceComponent)tc, (String)("IOException while processing readAsynch request local: " + las + " remote: " + ras), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Exception is: " + exThisTime), (Object[])new Object[0]);
            }
            if (this.getJITAllocateAction()) {
                this.getBuffer().release();
                this.setBuffer(null);
                this.setJITAllocateAction(false);
            }
            this.getReadCompletedCallback().error(this.getTCPConnLink().getVirtualConnection(), this, exThisTime);
        }
        return null;
    }

    @Override
    public long processSyncReadRequest(long numBytes, int timeout) throws IOException {
        long bytesRead = 0L;
        boolean freeJIT = false;
        IOException exThisTime = null;
        this.immedTimeoutRequested = false;
        this.setJITAllocateAction(false);
        this.jITAllocatedDirect = false;
        if (this.getJITAllocateSize() > 0 && this.getBuffers() == null) {
            if (this.oTCPConnLink.getConfig().getAllocateBuffersDirect()) {
                this.setBuffer(ChannelFrameworkFactory.getBufferManager().allocateDirect(this.getJITAllocateSize()));
                this.jITAllocatedDirect = true;
            } else {
                this.setBuffer(ChannelFrameworkFactory.getBufferManager().allocate(this.getJITAllocateSize()));
            }
            this.setJITAllocateAction(true);
        }
        this.setIOAmount(numBytes);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setTimeoutTime(timeout);
        try {
            bytesRead = ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).readAIOSync(numBytes, this);
            if (numBytes == 0L && bytesRead == 0L) {
                freeJIT = true;
            }
        }
        catch (AsyncTimeoutException ate) {
            exThisTime = new SocketTimeoutException(ate.getMessage());
            exThisTime.initCause(ate);
            freeJIT = true;
        }
        catch (IOException ioe) {
            exThisTime = ioe;
            freeJIT = true;
        }
        if (freeJIT && this.getJITAllocateAction()) {
            this.getBuffer().release();
            this.setBuffer(null);
            this.setJITAllocateAction(false);
        }
        if (exThisTime != null) {
            throw exThisTime;
        }
        return bytesRead;
    }

    @Override
    protected void immediateTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"immediateTimeout", (Object[])new Object[0]);
        }
        this.immedTimeoutRequested = true;
        ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).timeoutReadFuture();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"immediateTimeout");
        }
    }

    protected boolean isImmedTimeoutRequested() {
        return this.immedTimeoutRequested;
    }

    protected boolean getJITAllocatedDirect() {
        return this.jITAllocatedDirect;
    }
}

