/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ValidBridge {
    private static final TraceComponent tc = Tr.register(ValidBridge.class, (String)"registyUtil", (String)"com.ibm.ws.security.wim.registry.util.resources.RegistryUtilMessages");
    private TypeMappings propertyMap = null;
    private BridgeUtils mappingUtils = null;
    static final long serialVersionUID = 3219368833523822611L;

    public ValidBridge(BridgeUtils mappingUtil) {
        this.mappingUtils = mappingUtil;
        this.propertyMap = new TypeMappings(mappingUtil);
    }

    @FFDCIgnore(value={WIMException.class})
    public boolean isValidUser(String inputUserSecurityName) throws RegistryException {
        String methodName = "isValidUser";
        boolean returnValue = false;
        try {
            String outputAttrName;
            String inputAttrName;
            Root resultRoot;
            this.mappingUtils.validateId(inputUserSecurityName);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputUserSecurityName);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            if ((resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName = this.propertyMap.getInputUserSecurityName(idAndRealm.getRealm()), id, outputAttrName = this.propertyMap.getOutputUniqueUserId(idAndRealm.getRealm()), this.mappingUtils)) != null) {
                root = resultRoot;
            } else {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName = this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm()))) {
                    searchControl.getProperties().add(outputAttrName);
                }
                searchControl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputAttrName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useUserFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.size() == 1) {
                returnValue = returnList.get(0) instanceof PersonAccount;
            }
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[]{toCatch});
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    @FFDCIgnore(value={WIMException.class})
    public boolean isValidGroup(String inputGroupSecurityName) throws RegistryException {
        String methodName = "isValidGroup";
        boolean returnValue = false;
        try {
            String outputAttrName;
            String inputAttrName;
            Root resultRoot;
            this.mappingUtils.validateId(inputGroupSecurityName);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputGroupSecurityName);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            if ((resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName = this.propertyMap.getInputGroupSecurityName(idAndRealm.getRealm()), id, outputAttrName = this.propertyMap.getOutputUniqueGroupId(idAndRealm.getRealm()), this.mappingUtils)) != null) {
                root = resultRoot;
            } else {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName = this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm()))) {
                    searchControl.getProperties().add(outputAttrName);
                }
                searchControl.setExpression("//entities[@xsi:type='Group' and " + inputAttrName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useGroupFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.size() == 1) {
                returnValue = returnList.get(0) instanceof Group;
            }
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[]{toCatch});
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }
}

