/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.monitor.internal.jmx.PmiCollaboratorFactory;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.wire.WpdCollection;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class PmiRegistry
implements PmiConstants {
    public static final String COPYRIGHT = "Copyright (c) 2000, 2004 IBM Corporation and others.\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v1.0\n which accompanies this distribution, and is available at\n http://www.eclipse.org/legal/epl-v10.html\n \n Contributors:\n     IBM Corporation - initial API and implementation";
    public static final String PLATFORM = PmiRegistry.initPlatform();
    public static final String MSG_BUNDLE = "com.ibm.ws.pmi.properties.PMIMessages";
    private static boolean disabled = true;
    private static boolean initialized = false;
    private static boolean allLevelNone = true;
    private static boolean beanMethodDisabled = true;
    public static String nodeName = "mynode";
    public static String serverName = "myserver";
    private static ModuleItem moduleRoot;
    private static Hashtable moduleAggregates;
    private static HashMap mbeanToModuleMap;
    private static PerfLevelDescriptor[] _plds;
    private static String defaultLevel;
    private static final TraceComponent tc;
    private static final String beanMethodWccmType = "beanModule#beanModule.methods";
    static final long serialVersionUID = -6916453768925867324L;

    private static String initPlatform() {
        return "distributed";
    }

    @ManualTrace
    public static synchronized void init() {
        if (initialized) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object[])new Object[0]);
        }
        initialized = true;
        defaultLevel = "basic";
        moduleRoot = new ModuleItem();
        PmiRegistry.setInstrumentationLevel(defaultLevel);
        try {
            MBeanServer mServer = AccessController.doPrivileged(() -> ManagementFactory.getPlatformMBeanServer());
            ObjectName pmiMBean = new ObjectName("WebSphere:type=Perf");
            mServer.registerMBean(PmiCollaboratorFactory.getPmiCollaborator(), pmiMBean);
            PmiRegistry.printAllMBeans();
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"Unable to create Perf MBean.", (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.pmi.server.PmiRegistry", (String)"Init");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    private static void printAllMBeans() {
    }

    public static boolean isDisabled() {
        return disabled;
    }

    public static void disable() {
        disabled = true;
    }

    public static void enable() {
        disabled = false;
    }

    public static boolean isAllLevelNone() {
        return allLevelNone;
    }

    public static boolean isBeanMethodDisabled() {
        if (moduleRoot != null) {
            beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
            return beanMethodDisabled;
        }
        return beanMethodDisabled;
    }

    public static void setAllLevelNone(boolean allNone) {
        allLevelNone = allNone;
    }

    @ManualTrace
    public static synchronized ModuleItem registerModule(PmiModule instance) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerModule", (Object[])new Object[0]);
        }
        if (!initialized) {
            PmiRegistry.init();
        }
        if (!PmiRegistry.validateModule(instance)) {
            Tr.exit((TraceComponent)tc, (String)"registerModule - module is null");
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("**** registerModule: " + instance.getModuleID() + ", " + instance.getName()), (Object[])new Object[0]);
        }
        String[] path = instance.getPath();
        ModuleItem parent = null;
        if (path == null || path.length == 0) {
            Tr.warning((TraceComponent)tc, (String)"PMI0001W", (Object[])new Object[]{instance.getName()});
            return null;
        }
        if (path.length == 1) {
            parent = moduleRoot;
            if (tc.isDebugEnabled()) {
                PmiRegistry.printPMITree(parent);
            }
        } else {
            String[] parentPath = PmiRegistry.getParentPath(path);
            parent = moduleRoot.add(parentPath, 0);
        }
        instance.setInstrumentationBySet(defaultLevel);
        ModuleItem retItem = new ModuleItem(instance);
        if (!parent.add(retItem)) {
            Tr.warning((TraceComponent)tc, (String)"PMI0023W", (Object[])new Object[]{instance.getName()});
            if (tc.isDebugEnabled()) {
                String p = "root";
                if (parent.getInstance() != null) {
                    p = parent.getInstance().getName();
                }
                StringBuffer b = new StringBuffer("Current entries under: " + p);
                ModuleItem[] c = parent.children();
                if (c != null) {
                    for (int k = 0; k < c.length; ++k) {
                        PmiModule pm = c[k].getInstance();
                        if (pm == null) continue;
                        b.append("\r\n").append(pm.getName());
                    }
                }
                Tr.debug((TraceComponent)tc, (String)b.toString(), (Object[])new Object[0]);
            }
            retItem = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerModule");
        }
        return retItem;
    }

    private static ModuleItem _getAggregateParent(ModuleItem mi) {
        ModuleItem p = mi;
        do {
            if (p.getInstance() == null) {
                return null;
            }
            if (!(p.getInstance() instanceof ModuleAggregate)) continue;
            return p;
        } while ((p = p.getParent()) != null);
        return null;
    }

    @ManualTrace
    public static synchronized void unregisterModule(PmiModule instance) {
        if (disabled) {
            return;
        }
        if (instance == null) {
            return;
        }
        String[] path = instance.getPath();
        if (path == null || path.length == 0) {
            return;
        }
        for (int k = 0; k < path.length; ++k) {
            if (path[k] != null) continue;
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("unregisterModule: " + instance.getModuleID() + ", " + instance.getName()), (Object[])new Object[0]);
        }
        String[] parentPath = new String[path.length - 1];
        System.arraycopy(path, 0, parentPath, 0, parentPath.length);
        ModuleItem parent = moduleRoot.find(parentPath, 0);
        if (parent != null) {
            String[] mypath;
            parent.remove(parent.find(path[path.length - 1]));
            if (instance.isCustomModule()) {
                return;
            }
            if (!(parent.children != null && parent.children.size() != 0 || parent.getInstance() == null || (mypath = parent.getInstance().getPath()).length == 2 && mypath[0].equals("webServicesModule"))) {
                parent.getInstance().unregister();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unregisterModule");
        }
    }

    private static boolean validateModule(PmiModule instance) {
        return instance != null;
    }

    private static String[] getParentPath(String[] path) {
        if (path == null || path.length <= 1) {
            return null;
        }
        String[] parentPath = new String[path.length - 1];
        System.arraycopy(path, 0, parentPath, 0, parentPath.length);
        return parentPath;
    }

    public static synchronized boolean addModuleInfo(String moduleID, String modulePrefix) {
        return PerfModules.addModuleInfo(modulePrefix + moduleID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ModuleAggregate getModuleAggregate(String moduleID) {
        ModuleAggregate aggregate = (ModuleAggregate)moduleAggregates.get(moduleID);
        if (aggregate != null) {
            return aggregate;
        }
        Hashtable hashtable = moduleAggregates;
        synchronized (hashtable) {
            aggregate = (ModuleAggregate)moduleAggregates.get(moduleID);
            if (aggregate != null) {
                return aggregate;
            }
            PmiModuleConfig config = PmiRegistry.getConfig(moduleID);
            if (config == null) {
                return null;
            }
            aggregate = new ModuleAggregate(moduleID);
            moduleAggregates.put(moduleID, aggregate);
            return aggregate;
        }
    }

    public static PmiModuleConfig getConfig(String moduleID) {
        if (disabled) {
            return null;
        }
        return StatsConfigHelper.getTranslatedStatsConfig(moduleID);
    }

    public static PmiModuleConfig[] getConfigs() {
        return PmiRegistry.getConfigs(null);
    }

    public static PmiModuleConfig[] getConfigs(Locale l) {
        if (disabled) {
            return null;
        }
        PmiModuleConfig[] allConfigs = PerfModules.getConfigs();
        for (int i = 0; i < allConfigs.length; ++i) {
            StatsConfigHelper.translateAndCache(allConfigs[i], l);
        }
        return StatsConfigHelper.getAllConfigs(null);
    }

    public static PmiModule findPmiModule(DataDescriptor dd) {
        if (disabled) {
            return null;
        }
        ModuleItem item = PmiRegistry.findModuleItem(dd);
        if (item == null) {
            return null;
        }
        return item.getInstance();
    }

    public static ModuleItem findModuleItem(String[] path) {
        if (disabled) {
            return null;
        }
        if (path == null || path[0].equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot.find(path, 0);
    }

    public static ModuleItem findModuleItem(DataDescriptor dd) {
        if (disabled) {
            return null;
        }
        if (dd == null || dd.getModuleName().equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot.find(dd.getPath(), 0);
    }

    private static ModuleItem findParentModuleItem(DataDescriptor dd) {
        String[] path = dd.getPath();
        String[] parentPath = new String[path.length - 1];
        System.arraycopy(path, 0, parentPath, 0, parentPath.length);
        return PmiRegistry.findModuleItem(new DataDescriptor(parentPath));
    }

    private static boolean isSameNodeAndServer(ObjectName mName) {
        String processName = mName.getKeyProperty("process");
        String nodeName = mName.getKeyProperty("node");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isSameNodeAndServer: " + mName.toString()), (Object[])new Object[0]);
        }
        if (processName != null && !processName.equals(serverName)) {
            if (tc.isDebugEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"PMI0002W", (Object[])new Object[]{mName.toString() + ", expected process name is " + serverName});
            }
            return false;
        }
        if (nodeName != null && !nodeName.equals(PmiRegistry.nodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"PMI0002W", (Object[])new Object[]{mName.toString() + ", expected node name is " + PmiRegistry.nodeName});
            }
            return false;
        }
        return true;
    }

    public static DataDescriptor[] listMembers() {
        if (disabled) {
            return null;
        }
        ModuleItem[] modItems = moduleRoot.children();
        if (modItems == null) {
            return null;
        }
        DataDescriptor[] res = new DataDescriptor[modItems.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new DataDescriptor(new String[]{modItems[i].getInstance().getName()});
        }
        return res;
    }

    public static DataDescriptor[] listMembers(DataDescriptor dd) {
        if (disabled) {
            return null;
        }
        if (dd == null || dd.getPath() == null) {
            return PmiRegistry.listMembers();
        }
        if (dd.getType() == -1) {
            return null;
        }
        ModuleItem module = PmiRegistry.findModuleItem(dd);
        if (module == null) {
            return null;
        }
        return module.listMembers(dd, false);
    }

    public static StatDescriptor[] listStatMembers(StatDescriptor sd, boolean recursive) {
        if (disabled) {
            return null;
        }
        ModuleItem module = null;
        module = sd == null ? moduleRoot : PmiRegistry.findModuleItem(sd.getPath());
        if (module == null) {
            return null;
        }
        ArrayList list = module.listChildStatDescriptors(recursive);
        int n = list.size();
        StatDescriptor[] ret = new StatDescriptor[n];
        for (int k = 0; k < n; ++k) {
            ret[k] = (StatDescriptor)list.get(k);
        }
        return ret;
    }

    public static WpdCollection get(DataDescriptor dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(dd), recursive);
    }

    public static WpdCollection[] gets(DataDescriptor[] dds, boolean recursive) {
        if (disabled) {
            return null;
        }
        WpdCollection[] ret = new StatsImpl[dds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(dds[i]), recursive);
        }
        return ret;
    }

    private static StatsImpl getStats(ModuleItem moduleItem, boolean recursive) {
        if (moduleItem == null) {
            return null;
        }
        return moduleItem.getStats(recursive);
    }

    public static StatsImpl getStats(DataDescriptor dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        return PmiRegistry.getStats(PmiRegistry.findModuleItem(dd), recursive);
    }

    public static StatsImpl[] getStats(DataDescriptor[] dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        StatsImpl[] stats = new StatsImpl[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            stats[i] = PmiRegistry.getStats(dd[i], recursive);
        }
        return stats;
    }

    public static StatsImpl[] getStats(StatDescriptor[] dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        StatsImpl[] stats = new StatsImpl[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            stats[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(dd[i].getPath()), recursive);
        }
        return stats;
    }

    public static StatsImpl[] getStats(StatDescriptor[] dd, boolean recursive, PmiModuleConfig config) {
        PmiModuleConfig[] pmconfigs = StatsConfigHelper.getAllConfigs(null);
        ModuleItem mi = PmiRegistry.findModuleItemList(null);
        StatsImpl sil = mi.getStats(true);
        for (int i = 0; i < sil.getSubStats().length; ++i) {
            for (int j = 0; j < pmconfigs.length; ++j) {
                if (!sil.getSubStats()[i].getStatsType().contains(pmconfigs[j].getUID())) continue;
                sil.getSubStats()[i].mSetConfig(pmconfigs[j]);
                if (sil.getSubStats()[i].getSubStats().length <= 0) continue;
                for (int k = 0; k < pmconfigs.length; ++k) {
                    for (int l = 0; l < sil.getSubStats()[i].getSubStats().length; ++l) {
                        if (!sil.getSubStats()[i].getSubStats()[l].getStatsType().equalsIgnoreCase(pmconfigs[k].getUID())) continue;
                        sil.getSubStats()[i].getSubStats()[l].setConfig(pmconfigs[k]);
                        if (sil.getSubStats()[i].getSubStats()[l].getSubStats().length <= 0) continue;
                        for (int m = 0; m < sil.getSubStats()[i].getSubStats()[l].getSubStats().length; ++m) {
                            for (int n = 0; n < pmconfigs.length; ++n) {
                                if (!sil.getSubStats()[i].getSubStats()[l].getSubStats()[m].getStatsType().equalsIgnoreCase(pmconfigs[n].getUID())) continue;
                                sil.getSubStats()[i].getSubStats()[l].getSubStats()[m].setConfig(pmconfigs[n]);
                                if (sil.getSubStats()[i].getSubStats()[l].getSubStats()[m].getSubStats().length <= 0) continue;
                                for (int p = 0; p < sil.getSubStats()[i].getSubStats()[l].getSubStats()[m].getSubStats().length; ++p) {
                                    sil.getSubStats()[i].getSubStats()[l].getSubStats()[m].getSubStats()[p].setConfig(pmconfigs[n]);
                                }
                            }
                        }
                    }
                }
            }
        }
        StatsImpl[] stats = new StatsImpl[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            stats[i] = PmiRegistry.getStats(PmiRegistry.findModuleItem(dd[i].getPath()), recursive);
        }
        return stats;
    }

    public static ModuleItem findModuleItemList(String[] path) {
        if (disabled) {
            return null;
        }
        if (path == null || path[0].equals("pmi")) {
            return moduleRoot;
        }
        return moduleRoot;
    }

    public static StatLevelSpec[] getInstrumentationLevel(StatDescriptor sd, boolean recursive) {
        if (disabled) {
            return null;
        }
        ModuleItem item = PmiRegistry.findModuleItem(sd.getPath());
        if (item == null) {
            return null;
        }
        if (!recursive) {
            StatLevelSpec[] pld = new StatLevelSpec[1];
            PmiModule instance = item.getInstance();
            if (instance != null) {
                pld[0] = new StatLevelSpec(sd.getPath(), instance.getEnabled());
                return pld;
            }
            return null;
        }
        ArrayList res = item.getStatLevelSpec(recursive);
        StatLevelSpec[] pld = new StatLevelSpec[res.size()];
        for (int i = 0; i < pld.length; ++i) {
            pld[i] = (StatLevelSpec)res.get(i);
        }
        return pld;
    }

    public static void appendInstrumentationLevel(StatLevelSpec[] plds, boolean recursive) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < plds.length; ++i) {
            ModuleItem item;
            if (plds[i] == null || (item = PmiRegistry.findModuleItem(plds[i].getPath())) == null) continue;
            if (item.getInstance() == null) {
                int[] e = plds[i].getEnabled();
                if (e == null || e.length <= 0 || e[0] != -3) continue;
                item.setInstanceLevel(e, new int[0], -2, recursive);
                continue;
            }
            int[] oldCounters = item.getInstance().getEnabled();
            int[] newCounters = plds[i].getEnabled();
            if (oldCounters.length != 0 && oldCounters[0] == -3 || newCounters.length == 0) continue;
            if (newCounters[0] == -3 || oldCounters.length == 0) {
                item.setInstanceLevel(newCounters, new int[0], -2, recursive);
                continue;
            }
            item.setInstanceLevel(PmiRegistry.getUnionForAppendInstrumentationLevel(oldCounters, newCounters), new int[0], -2, recursive);
        }
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    private static int[] getUnionForAppendInstrumentationLevel(int[] oldCounters, int[] newCounters) {
        int i;
        int[] merged = new int[newCounters.length + oldCounters.length];
        int k = -1;
        for (i = 0; i < oldCounters.length; ++i) {
            merged[i] = oldCounters[i];
            ++k;
        }
        boolean flag = false;
        for (i = 0; i < newCounters.length; ++i) {
            for (int j = 0; j < oldCounters.length && !flag; ++j) {
                if (newCounters[i] != oldCounters[j]) continue;
                flag = true;
            }
            if (!flag) {
                merged[++k] = newCounters[i];
            }
            flag = false;
        }
        int[] final_result = new int[k + 1];
        for (i = 0; i <= k; ++i) {
            final_result[i] = merged[i];
        }
        return final_result;
    }

    public static PerfLevelDescriptor[] getInstrumentationLevel(DataDescriptor dd, boolean recursive) {
        if (disabled) {
            return null;
        }
        ModuleItem item = PmiRegistry.findModuleItem(dd);
        if (item == null) {
            return null;
        }
        if (!recursive) {
            PerfLevelDescriptor[] pld = new PerfLevelDescriptor[1];
            String[] path = item.getInstance().getPath();
            PmiModule instance = item.getInstance();
            pld[0] = new PerfLevelDescriptor(instance.getPath(), instance.getInstrumentationLevel(), instance.getModuleID());
            return pld;
        }
        ArrayList res = item.getPerfLevelDescriptors(false);
        PerfLevelDescriptor[] pld = new PerfLevelDescriptor[res.size()];
        for (int i = 0; i < pld.length; ++i) {
            pld[i] = (PerfLevelDescriptor)res.get(i);
        }
        return pld;
    }

    public static int getInstrumentationLevel(String[] path) {
        if (disabled) {
            return -1;
        }
        DataDescriptor dd = new DataDescriptor(path);
        ModuleItem item = PmiRegistry.findModuleItem(dd);
        if (item == null) {
            return -1;
        }
        return item.getInstance().getInstrumentationLevel();
    }

    public static PerfLevelDescriptor[] getAllInstrumentationLevels() {
        if (disabled) {
            return null;
        }
        ArrayList res = moduleRoot.getPerfLevelDescriptors(false);
        PerfLevelDescriptor[] retArray = new PerfLevelDescriptor[res.size()];
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = (PerfLevelDescriptor)res.get(i);
        }
        return retArray;
    }

    public static String getInstrumentationLevelString() {
        if (disabled) {
            return null;
        }
        Map modules = PmiRegistry.moduleRoot.children;
        if (modules == null) {
            return "";
        }
        PerfLevelDescriptor[] plds = new PerfLevelDescriptor[modules.size()];
        Iterator values = modules.values().iterator();
        int i = 0;
        while (values.hasNext()) {
            PmiModule instance = ((ModuleItem)values.next()).getInstance();
            plds[i++] = new PerfLevelDescriptor(instance.getPath(), instance.getInstrumentationLevel(), instance.getModuleID());
        }
        return PmiUtil.getStringFromPerfLevelSpecs(plds);
    }

    public static String getInstrumentationLevelString60() {
        StatLevelSpec[] specs = PmiRegistry.getInstrumentationLevel(new StatDescriptor(null), true);
        if (specs == null || specs.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(specs[0].toString());
        for (int k = 1; k < specs.length; ++k) {
            buf.append(":").append(specs[k].toString());
        }
        return buf.toString();
    }

    public static void setInstrumentationLevel(StatLevelSpec[] plds, boolean recursive) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < plds.length; ++i) {
            ModuleItem item;
            if (plds[i] == null || (item = PmiRegistry.findModuleItem(plds[i].getPath())) == null) continue;
            if (item.getInstance() == null) {
                int[] e = plds[i].getEnabled();
                if (e == null || e.length <= 0 || e[0] != -3) continue;
                item.setInstanceLevel(e, new int[0], -2, recursive);
                continue;
            }
            item.setInstanceLevel(plds[i].getEnabled(), new int[0], -2, recursive);
        }
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(PerfLevelDescriptor pld, boolean recursive) {
        if (disabled) {
            return;
        }
        PmiRegistry.setLevel(pld, recursive);
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    public static void setInstrumentationLevel(PerfLevelDescriptor[] plds, boolean recursive) {
        if (disabled) {
            return;
        }
        for (int i = 0; i < plds.length; ++i) {
            PmiRegistry.setLevel(plds[i], recursive);
        }
        allLevelNone = PmiRegistry.checkAllLevelNone(moduleRoot);
        beanMethodDisabled = PmiRegistry.checkBeanMethodDisabled(moduleRoot);
    }

    private static void setLevel(PerfLevelDescriptor pld, boolean recursive) {
        if (pld == null) {
            return;
        }
        String[] path = pld.getPath();
        ModuleItem item = null;
        if (path == null) {
            Tr.warning((TraceComponent)tc, (String)"PMI0001W", (Object[])new Object[]{"PmiRegistry.setLevel"});
            return;
        }
        if (path.length == 1 && path[0].equals("pmi")) {
            item = moduleRoot;
        } else if (path[0].equals("pmi")) {
            String[] thisPath = new String[path.length - 1];
            System.arraycopy(path, 1, thisPath, 0, thisPath.length);
            item = PmiRegistry.findModuleItem(new DataDescriptor(thisPath));
        }
        if (item != null) {
            item.setInstanceLevel(null, null, pld.getLevel(), recursive);
        }
    }

    private static boolean checkAllLevelNone(ModuleItem item) {
        if (item.instance != null && item.instance.getInstrumentationLevel() != 0) {
            return false;
        }
        if (item.children == null) {
            return true;
        }
        ModuleItem child2 = null;
        for (ModuleItem child2 : item.children.values()) {
            if (PmiRegistry.checkAllLevelNone(child2)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBeanMethodDisabled(ModuleItem item) {
        if (item.instance != null && !item.instance.getModuleID().equals("beanModule")) {
            return true;
        }
        if (item.instance != null) {
            int[] en;
            int inLevel = item.instance.getInstrumentationLevel();
            if (inLevel >= 7) {
                return false;
            }
            if (inLevel == -2 && item.instance.getModuleID().equals("beanModule") && (en = item.instance.getEnabled()) != null && en.length > 0) {
                return false;
            }
        }
        if (item.children == null) {
            return true;
        }
        ModuleItem child2 = null;
        for (ModuleItem child2 : item.children.values()) {
            if (!child2.getInstance().getModuleID().equals("beanModule") || PmiRegistry.checkBeanMethodDisabled(child2)) continue;
            return false;
        }
        return true;
    }

    public static void enableData(DataDescriptor[] dds, boolean recursive) {
        if (disabled) {
            return;
        }
        PmiRegistry.turnOnOffData(dds, true, recursive);
    }

    public static void disableData(DataDescriptor[] dds, boolean recursive) {
        if (disabled) {
            return;
        }
        PmiRegistry.turnOnOffData(dds, false, recursive);
    }

    private static void turnOnOffData(DataDescriptor[] dds, boolean on, boolean recursive) {
        for (int i = 0; i < dds.length; ++i) {
            ModuleItem item = PmiRegistry.findModuleItem(dds[i]);
            if (item == null) continue;
            int[] dataIds = dds[i].getDataIds();
            if (dataIds == null) {
                item.turnOnOffData(-3, on, recursive);
                continue;
            }
            for (int j = 0; j < dataIds.length; ++j) {
                item.turnOnOffData(dataIds[j], on, recursive);
            }
        }
    }

    public static PerfLevelDescriptor[] getDefaultPerfLevelSpecs() {
        String[] existingModules = PerfModules.moduleIDs;
        PerfLevelDescriptor[] ret = new PerfLevelDescriptor[existingModules.length + 1];
        ret[0] = new PerfLevelDescriptor(null, 0);
        for (int i = 0; i < existingModules.length; ++i) {
            ret[i + 1] = new PerfLevelDescriptor(new String[]{existingModules[i]}, 0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMBeanToModuleMap(ModuleItem moduleItem, MBeanStatDescriptor msd) {
        if (moduleItem == null || msd == null) {
            return false;
        }
        HashMap hashMap = mbeanToModuleMap;
        synchronized (hashMap) {
            ModuleItem prevVal = mbeanToModuleMap.put(msd.getIdentifier(), moduleItem);
            if (moduleItem.getInstance() != null) {
                moduleItem.getInstance().setMBeanName(msd.getObjectName(), msd.getStatDescriptor());
            }
            if (prevVal != null && tc.isDebugEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"PMI0024W", (Object[])new Object[]{prevVal.getInstance().getName()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setMBeanToModuleMap(): " + msd.getIdentifier()), (Object[])new Object[0]);
            }
        }
        return true;
    }

    public static void removeMBeanToModuleMap(MBeanStatDescriptor msd) {
        if (msd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removeMBeanToModuleMap(): " + msd.getIdentifier()), (Object[])new Object[0]);
            }
            mbeanToModuleMap.remove(msd.getIdentifier());
        }
    }

    public static boolean isDuplicateModule(String name) {
        return moduleRoot.find(name) != null;
    }

    public static WSStats getServerSnapshot() {
        return moduleRoot.getStats(true);
    }

    public static void printpath(String[] path) {
        StringBuffer b = new StringBuffer("printpath: ");
        for (int i = 0; i < path.length; ++i) {
            b.append(path[i]).append("/");
        }
        Tr.debug((TraceComponent)tc, (String)b.toString(), (Object[])new Object[0]);
    }

    private static String pathToString(int indent, String[] path) {
        StringBuffer b = new StringBuffer("|");
        while (indent != 0) {
            b.append("_");
            --indent;
        }
        b.append("_ ");
        for (int i = 0; i < path.length; ++i) {
            b.append("/").append(path[i]);
        }
        return b.toString();
    }

    public static void printPMITree(ModuleItem root) {
        if (moduleRoot == null) {
            Tr.debug((TraceComponent)tc, (String)"Specified PMI ModuleItem is empty!", (Object[])new Object[0]);
            return;
        }
        Tr.debug((TraceComponent)tc, (String)">> Begin PMI tree", (Object[])new Object[0]);
        StringBuffer b = new StringBuffer();
        PmiRegistry._printTree(0, root, b);
        System.err.println(b.toString());
        Tr.debug((TraceComponent)tc, (String)"<< End PMI tree", (Object[])new Object[0]);
    }

    private static void _printTree(int level, ModuleItem root, StringBuffer buf) {
        ModuleItem[] child = root.children();
        if (child == null) {
            return;
        }
        for (int i = 0; i < child.length; ++i) {
            buf.append("\r\n").append(PmiRegistry.pathToString(level, child[i].getInstance().getPath()));
            PmiRegistry._printTree(level + 1, child[i], buf);
        }
    }

    public static void setSynchronizedUpdate(boolean flag) {
        if (moduleRoot != null) {
            PmiRegistry._setSyncEnabled(moduleRoot, flag);
        }
    }

    private static void _setSyncEnabled(ModuleItem m, boolean flag) {
        if (m != null) {
            ModuleItem[] mi;
            PmiModule pm = m.getInstance();
            if (pm != null) {
                pm.setSyncEnabled(flag);
            }
            if ((mi = m.children()) != null) {
                for (int i = 0; i < mi.length; ++i) {
                    PmiRegistry._setSyncEnabled(mi[i], flag);
                }
            }
        }
    }

    public static void setInstrumentationLevel(String statisticSet) {
        if (statisticSet != null) {
            moduleRoot.setInstanceLevel_Set(statisticSet, true);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        moduleAggregates = new Hashtable();
        mbeanToModuleMap = new HashMap();
        _plds = null;
        tc = Tr.register(PmiRegistry.class, (String)"PMI", (String)MSG_BUNDLE);
    }
}

