/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.utility.utils;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class RepositoryPathUtility {
    @Trivial
    private static final boolean isLowerAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    @Trivial
    private static final boolean isUpperAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    @Trivial
    private static final boolean isAlpha(char c) {
        return RepositoryPathUtility.isLowerAlpha(c) || RepositoryPathUtility.isUpperAlpha(c);
    }

    @Trivial
    private static final boolean hasWindowsDrivePrefix(String path) {
        if (path.length() < 3) {
            return false;
        }
        return RepositoryPathUtility.isAlpha(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '/';
    }

    @Trivial
    private static final String capitalizeDriveLetter(String path) {
        if (RepositoryPathUtility.hasWindowsDrivePrefix(path) && RepositoryPathUtility.isLowerAlpha(path.charAt(0))) {
            return Character.toUpperCase(path.charAt(0)) + path.substring(1);
        }
        return path;
    }

    public static final String normalizePath(String path) {
        if (path == null) {
            return path;
        }
        if (path.isEmpty()) {
            return path;
        }
        path = PathUtils.normalize((String)path);
        if ((path = path.replaceAll("//+", "/")).startsWith("file:") && (path = path.substring(5)).length() > 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        if (!((path = RepositoryPathUtility.capitalizeDriveLetter(path)).length() == 3 && RepositoryPathUtility.hasWindowsDrivePrefix(path) || path.length() <= 1 || path.charAt(path.length() - 1) != '/')) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static final String getURLEncodedPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("getURLEncodedPath: path is null");
        }
        try {
            path = RepositoryPathUtility.normalizePath(path);
            return URLEncoder.encode(path, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Got a really un expected UnsupportedEncodingException. A JVM with no UTF8 support!";
            throw new IllegalStateException(msg, e);
        }
    }

    public static final String decodeURLEncodedDir(String urlEncodedUserDir) {
        try {
            return URLDecoder.decode(urlEncodedUserDir, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Got a really un expected UnsupportedEncodingException. A JVM with no UTF8 support!";
            throw new IllegalStateException(msg, e);
        }
    }
}

