/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.ISessionObserver;
import java.util.ArrayList;
import java.util.logging.Level;

public class SessionEventDispatcher
implements ISessionObserver {
    private static boolean _loggedVersion = false;
    private ArrayList _sessionObservers = null;
    private String _id = null;
    private static final String methodClassName = "SessionEventDispatcher";

    protected SessionEventDispatcher(ArrayList sessionObservers) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.4 3/12/08 09:24:11");
            _loggedVersion = true;
        }
        this._sessionObservers = sessionObservers;
        this._id = methodClassName;
    }

    @Override
    public void sessionCreated(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionCreated", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionCreated(session);
        }
    }

    @Override
    public void sessionAccessed(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAccessed", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionAccessed(session);
        }
    }

    @Override
    public void sessionAccessUnknownKey(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAccessUnknownKey", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionAccessUnknownKey(key);
        }
    }

    @Override
    public void sessionDestroyed(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "sessionDestroyed", "sessionid=" + session.getId());
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionDestroyed", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionDestroyed(session);
        }
    }

    @Override
    public void sessionDestroyedByTimeout(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "sessionDestroyedByTimeout", "sessionid=" + session.getId());
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionDestroyedByTimeout", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionDestroyedByTimeout(session);
        }
    }

    @Override
    public void sessionReleased(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionReleased", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionReleased(session);
        }
    }

    @Override
    public void sessionDidActivate(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionDidActivate", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionDidActivate(session);
        }
    }

    @Override
    public void sessionWillPassivate(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionWillPassivate", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionWillPassivate(session);
        }
    }

    @Override
    public void sessionFlushed(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionFlushed", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionFlushed(session);
        }
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void sessionAffinityBroke(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAffinityBroke", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionAffinityBroke(session);
        }
    }

    @Override
    public void sessionCacheDiscard(Object value) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionCacheDiscard", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionCacheDiscard(value);
        }
    }

    @Override
    public void sessionLiveCountInc(Object value) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionLiveCountInc", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionLiveCountInc(value);
        }
    }

    @Override
    public void sessionLiveCountDec(Object value) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionLiveCountDec", "sessionObservers.size()=" + this._sessionObservers.size());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionLiveCountDec(value);
        }
    }

    @Override
    public void sessionIdChanged(String oldId, ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionIdChanged", "application " + session.getContextId() + ":: from " + oldId + " to " + session.getId());
        }
        if (this._sessionObservers == null || this._sessionObservers.size() < 1) {
            return;
        }
        ISessionObserver sessionObserver = null;
        for (int i = 0; i < this._sessionObservers.size(); ++i) {
            sessionObserver = (ISessionObserver)this._sessionObservers.get(i);
            sessionObserver.sessionIdChanged(oldId, session);
        }
    }
}

